<?php
include_once "classes/Comercial.class.php";
include_once "classes/Residencial.class.php";
include_once "classes/Empresarial.class.php";
include_once "classes/Financeiro.class.php";
include_once "funcoes/funcoes.php";
$dt_i = addslashes($_GET['dt_i']);
$dt_f = addslashes($_GET['dt_f']);
$comercio = new Comercial();
$empresa = new Empresarial();
$residencia = new Residencial();
$financeiro = new Financeiro();
$comercio->query($dt_i,$dt_f);
$empresa->query($dt_i,$dt_f);
$residencia->query($dt_i,$dt_f);
$financeiro->query($dt_i,$dt_f);
$financeiro->saldo_CR();
$financeiro->saldototal_Cartao();
$financeiro->saldo_Pagseguro();
$financeiro->saldototalCR_NaoIdentificados();
$total = ($comercio->somaTotal() + $empresa->somaTotal() + $residencia->somaTotal());
$outros_lanca = ($financeiro->getSaldo_Cartao() + $financeiro->getSaldo_Pagseguro() + $financeiro->getSaldoCR_NaoIdentificados());
$total_geral = $total + $outros_lanca;

$array_to = [["tipo" => "Comércio" , "total" => $comercio->somaTotal(),"percentual" => round($percent = ($comercio->somaTotal() / $financeiro->getSaldo_CR()) * 100)],
    ["tipo" => "Residência", "total" => $residencia->somaTotal(),"percentual" => round($percent = ($residencia->somaTotal() / $financeiro->getSaldo_CR()) * 100)],
    ["tipo" => "Empresa", "total" => $empresa->somaTotal(),"percentual" => round($percent = ($empresa->somaTotal() / $financeiro->getSaldo_CR()) * 100)],
    ["tipo" => "Cartão", "total" => $financeiro->getSaldo_Cartao(),"percentual" => round($percent = ($financeiro->getSaldo_Cartao() / $financeiro->getSaldo_CR()) * 100)],
    ["tipo" => "PagSeguro", "total" => $financeiro->getSaldo_Pagseguro(),"percentual" => round($percent = ($financeiro->getSaldo_Pagseguro() / $financeiro->getSaldo_CR()) * 100)],
    ["tipo" => "Outros", "total" => $financeiro->getSaldoCR_NaoIdentificados(),"percentual" => round($percent = ($financeiro->getSaldoCR_NaoIdentificados() / $financeiro->getSaldo_CR()) * 100)]];
function cmp($a, $b){
    return $a['total'] < $b['total'];
}

usort($array_to, 'cmp');
?>

<br/>
<?php foreach ($array_to as $row) : ?>
    <div class="widget_summary">
        <div class="w_left w_25" style="width: 27%">
            <span><?php echo $row['tipo']?></span>
        </div>
        <div class="w_center w_55">
            <div class="progress">
                <div class="progress-bar progress-bar-success animated slideInLeft" title="<?php echo $row['percentual']?>%" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo $row['percentual'];?>%;">
                </div>
            </div>
        </div>
        <div class="w_right w_20">
            <p><?php echo formata_valor($row['total'])?></p>
        </div>
        <div class="clearfix"></div>
    </div>
<?php endforeach; ?>
<div class="clearfix"></div>
<span><strong>Total</strong></span>
<div class="pull-right">
    <?php  if(((int)$total_geral) == ((int)$financeiro->getSaldo_CR())) :?>
        <span><strong class="green"><?php echo formata_valor($total_geral)?></strong></span>
    <?php else :?>
        <span><strong class="bg-danger red" data-toggle='tooltip' data-placement='top' title='Valor em processo de verificação e aprovação'><?php echo formata_valor($total_geral)?></strong></span>
    <?php endif;?>
</div>