<?php
include_once "classes/Comercial.class.php";
include_once "classes/Residencial.class.php";
include_once "classes/Empresarial.class.php";
include_once "funcoes/funcoes.php";
date_default_timezone_set('America/Sao_Paulo');
$dt_i = addslashes($_GET['dt_i']);
$dt_f = addslashes($_GET['dt_f']);
$comercio = new Comercial();
$empresa = new Empresarial();
$residencia = new Residencial();
$comercio->tipoRecebimento($dt_i,$dt_f);
$empresa->tipoRecebimento($dt_i,$dt_f);
$residencia->tipoRecebimento($dt_i,$dt_f);
?>
<div class="x_panel">
    <div class="x_content">
        <!-- start accordion -->
        <div class="accordion" id="accordion" role="tablist" aria-multiselectable="true">
            <div class="panel">
                <a class="panel-heading" role="tab" id="headingOne" data-toggle="collapse" data-parent="#accordion" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                    <h4 class="panel-title">Comercial</h4>
                </a>
                <div id="collapseOne" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingOne">
                    <div class="panel-body" style="padding: 0px">
                        <div class="row tile_count" style="margin-bottom: 0px">
                            <div class="col-md-4 col-sm-6 col-xs-8 tile_stats_count text-center">
                                <span class="count_top"> Recebimentos Rádio </span>
                                <div class="count green" style="font-size:150%"><?php echo "R$ ". formata_valor($comercio->getTotalRadio())?></div>

                            </div>
                            <div class="col-md-4 col-sm-6 col-xs-8 tile_stats_count text-center">
                                <span class="count_top"> Recebimentos Fibra </span>
                                <div class="count green" style="font-size:150%"><?php echo "R$ ". formata_valor($comercio->getTotalFibra())?></div>

                            </div>
                            <div class="col-md-4 col-sm-6 col-sm-8 tile_stats_count text-center">
                                <span class="count_top"> Total Recebimentos </span>
                                <div class="count" style="font-size: 150%"><?php echo "R$ ". formata_valor($comercio->getTotalRadio() + $comercio->getTotalFibra())?></div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="clearfix"></div>
            <div class="panel">
                <a class="panel-heading collapsed" role="tab" id="headingTwo" data-toggle="collapse" data-parent="#accordion" href="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                    <h4 class="panel-title">Empresarial</h4>
                </a>
                <div id="collapseTwo" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingTwo">
                    <div class="panel-body" style="padding: 0px">
                        <div class="row tile_count" style="margin-bottom: 0px">
                            <div class="col-md-4 col-sm-6 col-xs-8 tile_stats_count text-center">
                                <span class="count_top"> Recebimentos Rádio </span>
                                <div class="count green" style="font-size:150%"><?php echo "R$ ". formata_valor($empresa->getTotalRadio())?></div>

                            </div>
                            <div class="col-md-4 col-sm-6 col-xs-8 tile_stats_count text-center">
                                <span class="count_top"> Recebimentos Fibra </span>
                                <div class="count green" style="font-size:150%"><?php echo "R$ ". formata_valor($empresa->getTotalFibra())?></div>

                            </div>
                            <div class="col-md-4 col-sm-6 col-xs-8 tile_stats_count text-center">
                                <span class="count_top"> Total Recebimentos </span>
                                <div class="count" style="font-size: 150%"><?php echo "R$ ". formata_valor($empresa->getTotalRadio() + $empresa->getTotalFibra())?></div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="panel">
                <a class="panel-heading collapsed" role="tab" id="headingThree" data-toggle="collapse" data-parent="#accordion" href="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                    <h4 class="panel-title">Residencial</h4>
                </a>
                <div id="collapseThree" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingThree">
                    <div class="panel-body" style="padding: 0px">
                        <div class="row tile_count" style="margin-bottom: 0px">
                            <div class="col-md-3 col-sm-5 col-xs-7 tile_stats_count text-center">
                                <span class="count_top"> Recebimentos Rádio </span>
                                <div class="count green" style="font-size:150%"><?php echo "R$ ". formata_valor($residencia->getTotalRadio())?></div>

                            </div>
                            <div class="col-md-3 col-sm-5 col-xs-7 tile_stats_count text-center">
                                <span class="count_top"> Recebimentos Fibra </span>
                                <div class="count green" style="font-size:150%"><?php echo "R$ ". formata_valor($residencia->getTotalFibra())?></div>

                            </div>
                            <div class="col-md-3 col-sm-5 col-xs-7 tile_stats_count text-center">
                                <span class="count_top"> Recebimentos Cabo </span>
                                <div class="count green" style="font-size:150%"><?php echo "R$ ". formata_valor($residencia->getTotalCabo())?></div>

                            </div>
                            <div class="col-md-3 col-sm-5 col-sm-7 tile_stats_count text-center">
                                <span class="count_top"> Total Recebimentos </span>
                                <div class="count" style="font-size: 150%"><?php echo "R$ ". formata_valor($residencia->getTotalRadio() + $residencia->getTotalFibra() + $residencia->getTotalCabo())?></div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div><!-- end of accordion -->
</div>