function carrega_logradouro() {

    $('#tabela-markers').dataTable().fnDestroy();

    $.ajax({
        type: "GET",
        url: './controle_mapa/carrega_logradouro_maps.php',
        beforeSend: function () {
            $('#logradouro').html('<div class="text-center"><br/><br/><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i><h2 class="animated slideInLeft">Carregando...</h2></div>');
        },
        success: function (data) {
            $('#logradouro').html(data);
            $('#tabela_logradouro').dataTable({
                fixedHeader: !0,
                "lengthMenu": [[25, 50, 100, -1], [25, 50, 100, "All"]],
                "order": [[0, "desc"]]
            });
            $('[data-toggle="tooltip"]').tooltip();
        }
    });
}

function editar_logradouro(id) {

    $('#modal-geral').modal('show');

    $.ajax({
        type: "POST",
        url: "./controle_mapa/carrega_logradouro_maps.php?p=edit",
        data: 'id=' + id,
        beforeSend: function () {
            $('#modal-geral').find('.modal-body').html('Carregando ....');
            $('#modal-geral').modal('show');
        },
        success: function (html) {
            $('#modal-geral').find('.resultado').html(html);
            $('#modal-geral').find('.resultado').find('.modal-body').find('form').on('submit', salvar_logradouro);

        }
    });
}

function modal_inserir() {

    $('#modal-inserir').modal('show');
}

function inserir_logradouro() {

    var logradouro = $('.logradouro').val();
    var bairro = $('.bairro').val();
    var cidade = $('.cidade').val();
    var lat = $('.latitude').val();
    var lng = $('.longitude').val();

    $.ajax({

        type: 'POST',
        url: './controle_mapa/inserir_logradouro.php',
        data: {'logradouro': logradouro, 'latitude': lat, 'bairro': bairro, 'cidade': cidade, 'lng': lng},
        success: function () {

            $('#modal-inserir').modal('hide');
            toastr.success('Atualizado com Sucesso');
        }
    });
    carrega_logradouro();
}

function deletar_logradouro(id) {

    $('#modal-delete').modal('show');
    $.ajax({
        type: "POST",
        url: "./controle_mapa/carrega_logradouro_maps.php?p=delete",
        data: 'id=' + id,
        success: function (html) {
            $('#modal-delete').find('.deletar').html(html);
            $('#modal-delete').find('.deletar').find('.modal-body').find('form').on('submit', excluir_logradouro);

        }
    });
}

function salvar_logradouro(e) {

    e.preventDefault();

    var data = $(this).serialize();

    $.ajax({

        type: 'POST',
        url: './controle_mapa/carrega_logradouro_maps.php?p=salve',
        data: data,
        success: function () {

            $('#modal-geral').modal('hide');
            toastr.success('Atualizado com Sucesso');


        }
    });
    carrega_logradouro();
}

function excluir_logradouro(e) {

    e.preventDefault();

    var data = $(this).serialize();

    $.ajax({

        type: 'POST',
        url: './controle_mapa/carrega_logradouro_maps.php?p=excluir',
        data: data,
        success: function () {

            $('#modal-delete').modal('hide');
            toastr.success('Excluído');


        }
    });
    carrega_logradouro();
}
