<?php
header("Content-Type: text/html; charset=ISO-8859-1",true);
session_start();
include_once("sql/controle_usuarios.php");

$id = isset($_GET['id']) ? (int) $_GET['id'] : null;

$user = new Usuario($id);


?>
<!DOCTYPE html>
<html lang="pt-br" xmlns="http://www.w3.org/1999/html" xmlns="http://www.w3.org/1999/html"
      xmlns="http://www.w3.org/1999/html">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- Meta, title, CSS, favicons, etc. -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Administrativo Redenilf</title>

    <link rel="icon" href="images/favicon2.png">
    <!-- Bootstrap -->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/fonts/css/font-awesome.min.css" rel="stylesheet">

    <!-- Custom Theme Style -->
    <link href="assets/css/custom.min.css" rel="stylesheet">

</head>
<body>

<div class="modal fade" id="myModalNorm" tabindex="-1" role="dialog"
     aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <button type="button" class="close"
                        data-dismiss="modal">
                    <span aria-hidden="true">&times;</span>
                    <span class="sr-only">Close</span>
                </button>
                <h4 class="modal-title" id="myModalLabel">
                    Editar Usurio
                </h4>
            </div>

            <!-- Modal Body -->
            <div class="modal-body">

                <form method="post" data-toggle="validator" enctype="multipart/form-data" role="form" action="sql/query_edituser.php">
                    <div class="form-group">
                        <label for="input_id">ID:</label>
                        <input type="text" class="form-control" readonly="readonly"
                               name="input_id" value="<?php echo $user->getId() ?>"/>
                    </div>
                    <div class="form-group">
                        <label for="input_nome">Nome:</label>
                        <input type="text" required class="form-control" data-minlength="6" data-error="Informe o nome e sobrenome"
                               name="input_nome" value="<?php echo utf8_decode($user->getNome())?>"/>
                        <div class="help-block with-errors"></div>
                    </div>
                    <div class="form-group">
                        <label for="input_email">Email:</label>
                        <input type="email" class="form-control"
                               name="input_email" data-error="Por favor, informe um email correto." value="<?php echo $user->getEmail()?>" required/>
                        <div class="help-block with-errors"></div>
                    </div>
                    <div class="form-group">
                        <label for="input_login">Login:</label>
                        <input type="text" class="form-control" readonly="readonly"
                               name="input_login" value="<?php echo $user->getLogin()?>"/>
                    </div>
                    <div class="form-group">
                        Alterar Foto: <input type="file" name="foto" />
                    </div>
                    <div class="form-group">
                        <label for="input_cargo">Cargo:</label>
                        <input type="text" class="form-control"
                               name="input_cargo" value="<?php echo utf8_decode($user->getCargo())?>" data-error="Este campo no pode ficar em branco" required/>
                        <div class="help-block with-errors"></div>
                    </div>
                    <div class="form-group">
                        <label for="input_departamento">Grupo de Acesso:</label>
                        <input type="text" class="form-control" name="input_departamento" readonly="readonly" value="<?php echo $user->getAcesso()?>"/>
                        </input>
                    </div>

                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">
                                Editar
                            </button></a>
                        </button>
                    </div>
                </form>


            </div>

            <!-- Modal Footer -->

        </div>
    </div>
</div>
<div class="modal fade" id="confirm-edicao" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                Editar Usuario
            </div>
            <div class="modal-body">
                Deseja Alterar os dados do Usurio: <?php echo "<a class='red' style='font-weight: bold'>".$user->getNome()?> ?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <a class="btn btn-primary btn-ok">Confirmar</a>
            </div>
        </div>
    </div>
</div>





<!-- jQuery -->
<script src="assets/jquery/dist/jquery.min.js"></script>
<script src="assets/validator/dist/validator.min.js"></script>
<!-- Bootstrap -->
<script src="assets/js/bootstrap.min.js"></script>

<script>

    $('#myModalNorm').modal('show');
    $('#myModalNorm').on('hidden.bs.modal', function(e){

        window.location = "home.php";

    });

</script>
<script>

    $('#confirm-delete').on('show.bs.modal', function(e) {
        $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
    });
</script>

</body>
</html>