<?php


class Clientes {


    private $id;
    private $codigo_mk;
    private $nome;
    private $number_card;
    private $somaparcela;
    private $valor;
    private $cod_bandeira;
    private $nome_bandeira;
    private $pdo;
    private $data_liquidacao;
    private $data_transacao;
    private $data_vencimento;
    private $numRows;
    private $array;


    //Construtor


    public function __construct($i){

        try {
            $this->pdo = new PDO("mysql:dbname=redenilf_reports;host=177.107.64.7", "redenilf_reports", "187982774");

        } catch (PDOException $e) {

            echo "Conexao com o BD Falhou: " . $e->getMessage();
        }

        if(!empty($i)) {

            $sql = "SELECT cod_cli, nome_cliente, cod_mk, number_card, nome, cod_bandeira from clientes INNER JOIN machine_card m on cod_bandeira = m.cod_b  WHERE cod_cli = ?";
            $sql = $this->pdo->prepare($sql);
            $sql->execute(array($i));


            if($sql->rowCount() > 0){

                $data = $sql->fetch();
                $this->id = $data['cod_cli'];
                $this->nome = $data['nome_cliente'];
                $this->codigo_mk = $data['cod_mk'];
                $this->number_card = $data['number_card'];
                $this->somaparcela = $data['parcela'];
                $this->cod_bandeira = $data['cod_bandeira'];
                $this->nome_bandeira = $data['nome'];
                $this->valor = $data['valor'];

            }
        }
    }


    //Mtodos GET

    public function getId(){

        return $this->id;
    }

    public function getNome(){

        return $this->nome;
    }

    public function getCodigo(){

        return $this->codigo_mk;
    }

    public function getCartao(){

        return $this->number_card;
    }

    public function getBandeira(){

        return $this->cod_bandeira;
    }

    public function getNomeBandeira(){

        return $this->nome_bandeira;
    }

    public function getParcela(){

        return $this->parcela;
    }
    public function getValor(){

        return $this->valor;
    }



    // Mtodos SET

    public  function setNome($n){

        $this->nome = $n;
    }
    public function setCodmk($cod){

        $this->codigo_mk = $cod;
    }
  public function setCartao($card){

        $this->number_card = $card;
    }
  public function setBandeira($b){

        $this->cod_bandeira = $b;
    }
  public function setParcela($p){

        $this->somaparcela = $p;
    }
  public function setvalor($v){

        $this->valor = $v;
    }

  public function setDataliqui($dt){

        $this->data_liquidacao = $dt;
    }

   public function setDataTransacao($dt_t){

        $this->data_transacao = $dt_t;
    }




    //Metodo Salvar / Editar


    public function salvar()

    {

        if (!empty($this->id)) {

            $sql = "UPDATE clientes SET nome_cliente = ?, cod_mk = ?, number_card = ?, cod_bandeira = ?  WHERE cod_cli = ?";
            $sql = $this->pdo->prepare($sql);
            $sql->execute(array(
                $this->nome,
                $this->codigo_mk,
                $this->number_card,
                $this->cod_bandeira,
                $this->id));

            echo "<script>alert('Cliente Editado com Sucesso');window.location.href = '../cartao.php';</script>";

        } else {
            //SE NAO EXISTIR ID O SISTEMA IRA INCLUIR O USUARIO
            $sql = "SELECT * FROM clientes WHERE (nome_cliente = ? OR cod_mk = ?) and number_card = ?";
            $sql = $this->pdo->prepare($sql);
            $sql->execute(array(
                $this->nome,
                $this->codigo_mk,
                $this->number_card));
            $line = $sql->rowCount();
            if ($line >= 1) {

               echo "<script>alert('Cliente ou Cdigo MK j inserido na Base de Dados');window.location.href = '../cartao.php';</script>";

            } else {
                $sql = "INSERT INTO clientes SET nome_cliente = ?, cod_mk = ?, number_card = ?, cod_bandeira = ?, parcelas = ?, valor = ?";
                $sql = $this->pdo->prepare($sql);
                $sql->execute(array(
                    $this->nome,
                    $this->codigo_mk,
                    $this->number_card,
                    $this->cod_bandeira,
                    $this->somaparcela,
                    $this->valor
                ));
                $id = $this->pdo->lastInsertId();
                $count = $this->somaparcela;
                $valor = ($this->valor / $count);
                $data = $this->data_transacao;
                $vencimento = $this->data_transacao;
               include_once"../funcoes/funcoes.php";

                for ($i = 1; $i <= $count; $i++) {

                 $vcto = addMonthIntoDate($vencimento,$i);

                    $sql2 = "INSERT INTO contas set cliente_conta = $id, parcela = $i, valor_lancamento = $valor, data_lancamento = '$data', data_vencimento = '$vcto', liquidado = 'N'";
                    $this->pdo->query($sql2);

                }

                echo "<script>alert('Cliente Inserido com Sucesso');window.location.href = '../cartao.php';</script>";
            }
        }
    }


    //Metodo Deletar

    public function deletar()
    {

        $sql = "DELETE FROM clientes WHERE cod_cli = ? LIMIT 1";
        $sql = $this->pdo->prepare($sql);
        $sql->execute(array($this->id));
        $sql2 = "DELETE FROM contas WHERE cliente_conta = ?";
        $sql2 = $this->pdo->prepare($sql2);
        $sql2->execute(array($this->id));
    }


    public function query($sql){

        $query = $this->pdo->query($sql);
        $this->numRows = $query->rowCount();
        $this->array = $query->fetchAll();
    }


    public function listar(){

        return $this->array;

    }

     public function numRows(){

         return $this->numRows;

     }

    public function liquidaContas($id,$parcela,$data,$valor,$status)
    {

            $sql = "UPDATE contas SET valor_liquidacao = '$valor', liquidado = '$status', data_liquidacao = '$data' where codconta = $id and parcela = $parcela ";
            $sql = $this->pdo->query($sql);
            $this->numRows = $sql->rowCount();

    }
    public function updateContas($id,$parcela,$data,$valor,$status)
    {

        $sql = "UPDATE contas SET valor_lancamento = '$valor', liquidado = '$status', data_vencimento = '$data' where codconta = $id and parcela = $parcela ";
        $sql = $this->pdo->query($sql);
        $this->numRows = $sql->rowCount();

    }

    public function buscaConta($id){


           $sql = "select * from contas where cliente_conta = $id order by codconta";
           $query = $this->pdo->query($sql);
           $this->array = $query->fetchAll();

    }

    public function status($id){


        $sql = "select count(parcela) as parcelas from contas where cliente_conta = $id";
        $query = $this->pdo->query($sql);
        foreach($query->fetchAll() as $row){$soma_parcela = $row['parcelas'];};
        $sql = "select count(parcela) as parcelas from contas where cliente_conta = $id and liquidado = 'S'";
        $query = $this->pdo->query($sql);
        foreach($query->fetchAll() as $row){$liquidados = $row['parcelas'];};
        $status = (100 / $soma_parcela)* $liquidados;
        return $status;
    }

    }


?>