<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 05/10/2018
 * Time: 14:52
 */
require_once "sql/SqlAgenda.php";


class Agenda extends SqlAgenda
{


    private $result;
    private $tecnico;
    private $data;
    private $hora;
    private $servico;
    private $codigo;
    private $cidade;
    private $codcidade;
    private $novo;


    public function carregarAgenda($cidade)
    {


        $this->loadAgenda();
        $sql = $this->getPdomk()->prepare($this->getSql());
        //$sql->bindValue('tipo', "INSTALACAO");
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result = $sql->fetchAll();
            $array_novo = array();
            $array_hora = array();

            array_push($array_hora, '08:30:00', '09:15:00', '10:00:00', '10:45:00', '11:30:00', '13:15:00',
                '14:00:00', '14:45:00', '15:30:00', '16:15:00', '17:00:00');


            foreach ($this->getResult() as $row) {

                if ($row['tipo_servico'] == 'INSTALACAO') {

                    $sql_cidade = $row['filial'];

                    array_push($array_novo, ['cidade' => $sql_cidade]);

                    if (utf8_encode($row['filial']) == $cidade) {

                        $tecnico[] = $row['tecnico'];
                        $Data[] = $row['data'];
                        $tipo_servico[] = $row['tipo_servico'];
                        $codigo[] = $row['codcliente'];
                    }
                }
            }


        }

        //remove valore duplicados
        $this->cidade = array_unique($array_novo, SORT_REGULAR);
        $this->tecnico = array_unique($tecnico);
        $this->data = array_unique($Data);
        $this->hora = array_unique($array_hora);

        //reordena as chaves do array
        $this->cidade = array_values($this->cidade);
        $this->tecnico = array_values($this->tecnico);
        $this->data = array_values($this->data);
        $this->hora = array_values($this->hora);

        //Ordena o array de forma natural
        // natcasesort($this->cidade);
        natcasesort($this->data);
        natcasesort($this->hora);

    }

    function buscafilial_Tecnico($tecnico)
    {

        $this->buscatecnicoFilial();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue('tecnico', $tecnico);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $row) {

                $resultado = $row['cidade'];
            };

            return $resultado;

        }

    }


    function buscacliente($codigo)
    {

        $cliente = array();

        $codigo = strstr($codigo, '.', false);
        $codigo = substr($codigo, 1);

        $this->buscacliente_Agenda();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue('codigo', $codigo);
        $sql->execute();

        if ($sql->rowCount() > 0) {
            foreach ($sql->fetchAll() as $row) {

                $cliente = $row;

            }
            return $cliente;
        }

    }


    /**
     * @return mixed
     */
    public function getTecnico()
    {
        return $this->tecnico;
    }

    /**
     * @return mixed
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * @return mixed
     */
    public function getHora()
    {
        return $this->hora;
    }

    /**
     * @return mixed
     */
    public function getServico()
    {
        return $this->servico;
    }

    /**
     * @return mixed
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * @return mixed
     */
    public function getCidade()
    {
        return $this->cidade;
    }

    /**
     * @return mixed
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * @return mixed
     */
    public function getCodcidade()
    {
        return $this->codcidade;
    }

    /**
     * @return mixed
     */
    public function getNovo()
    {
        return $this->novo;
    }


}
