<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 04/12/2018
 * Time: 15:29
 */

require_once "sql/SqlCancelamento.php";

class Cancelamento extends SqlCancelamento
{

    private $result;
    private $motivos;
    private $total;
    private $cancelados_tipo;
    private $cancelados_seguimento;
    private $cancelados_empresa;
    private $resultcancelados;
    private $perdido_radio = [];
    private $perdido_fibra = [];
    private $mesesequipperdido;
    private $resultfluxo;
    private $inativos;
    private $mes;
    private $atraso;
    private $dates;
    private $totalDia;
    private $resultado;


    public function __construct()
    {

        parent::__construct();
        $this->diasdoMes();
    }


    function carragar_Cancelamento($dt_i, $dt_f)
    {

        $this->result = null;
        $this->loadCancelamento();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue('data_i', $dt_i);
        $sql->bindValue('data_f', $dt_f);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result = $sql->fetchAll();
            $this->loadMotivos();

        }

    }

    function carregarOS_Pendente_Cancelamento($dt_i, $dt_f)
    {
        // carrega OS pendente de cancelamento de contratos nao cancelados

        $this->result = null;
        $this->loadOSPendenteCancelamento();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue('data_i', $dt_i);
        $sql->bindValue('data_f', $dt_f);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result = $sql->fetchAll();

        }
    }

    function carregaCancelamentoOS($dt_i, $dt_f)
    {
        // CARREGA OS CANCELAMENTOS APARTIR DA DATA DE ABERTURA DA OS DE CANCELAMENTO

        $this->resultado = null;
        $this->loadCancelamentoOS();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue('data_i', $dt_i);
        $sql->bindValue('data_f', $dt_f);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->resultado = $sql->fetchAll();

        }
    }

    public function loadResultDia($type)
    {

        {
            $array = array();

            if (!empty($this->getDates())) {
                foreach ($this->getDates() as $date) {

                    array_push($array, $this->historicoDia($date, $type));

                }

                $this->totalDia = $array;
            }

        }
    }

    private function historicoDia($date, $type)
    {
        {

            $array = array();

            foreach ($this->getResult() as $row) {

                if ($date == date('j', strtotime($row[$type]))) {

                    array_push($array, $row['codcontrato']);

                }
            }

            if (!empty($array)) {

                return count($array);

            } else {

                return 0;
            }


        }

    }

    private function loadMotivos()
    {

        $array = array();

        foreach ($this->getResult() as $row) {

            array_push($array, $row['motivo']);

        }

        $this->motivos = $array;
        $this->motivos = array_unique($this->motivos);

    }

    function somaMotivos($motivo)
    {

        $array = array();


        foreach ($this->getResult() as $row) {

            if ($row['motivo'] == $motivo) {


                array_push($array, $row['motivo']);

            }
        }

        $this->total = count($array);

    }

    function somatecnologia($tipo)
    {

        $array = array();

        foreach ($this->getResult() as $item) {

            if (strpos(unidade_financeira($item['tipo']), $tipo) !== false) {


                array_push($array, $item['tipo']);

            }

        }

        $this->total = count($array);

    }

    function carregaCancelamentoAnual()
    {

        $this->loadAnualCancelamento();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $item) {

                // carrega o array somente com os valores especificados
                $array[] = array('mes' => exibe_mes($item['mes']), 'valor' => $item['valor']);

            }

            //converte o array em json
            $this->result = json_encode($array);

        } else {

            $this->result = null;
        }

    }

    // acumulado por dia dos cancelados e por tipo
    public function acumulado_cancelamento_diario($dias, $tipo)
    {

        $cancelados_tipo = array();

        for ($i = 0; $i < $dias; $i++) {

            $array = array();
            $data = date('Y-m-d', strtotime('-' . $i . 'day'));

            if (!(verificafinaldesemana($data))) {

                foreach ($this->getResult() as $item) {

                    if ($item['data'] == date('Y-m-d', strtotime('-' . $i . 'day')))

                        if (strpos(unidade_financeira($item['tipo']), $tipo) !== false) {

                            $array[] = $item['codcontrato'];

                        }
                }

                array_push($cancelados_tipo, '-' . count($array));
            }
        }
        $this->cancelados_tipo = $cancelados_tipo;

    }

    //CARREGA CANELADOS A PARTIR DA DATA DE ABERTURA DA OS DA ABA FINANCEIRO > CLIENTES
    public function carrega_cancelados($seguimento, $tecnoclogia)
    {
        $array = array();
        $this->cancelados_seguimento = null;


        foreach ($this->getResultado() as $row) {

            if (strstr(unidade_financeira($row['tipo']), $seguimento) &&
                unidade_financeira($row['tipo'])[0] == $tecnoclogia) {
                array_push($array, $row);
            }
        }
        $this->cancelados_seguimento = $array;
    }

    public function canceladosSeguimento($seguimento)
    {

        $array = array();
        $this->cancelados_seguimento = null;

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if (strstr(unidade_financeira($row['tipo']), $seguimento)) {

                    array_push($array, $row);
                }

            }

            $this->cancelados_seguimento = $array;
        } else {

            $this->cancelados_seguimento = null;
        }
    }

    public function acumulado_cancelamento_diario_empresa($dias, $empresa)
    {

        $cancelados_empresa = array();

        for ($i = 0; $i < $dias; $i++) {

            $array = array();
            $data = date('Y-m-d', strtotime('-' . $i . 'day'));

            if (!(verificafinaldesemana($data))) {

                foreach ($this->getResult() as $item) {

                    if ($item['data'] == date('Y-m-d', strtotime('-' . $i . 'day')))

                        if (empresa($item['tipo']) === $empresa) {

                            $array[] = $item['codcontrato'];

                        }
                }

                array_push($cancelados_empresa, '-' . count($array));
            }
        }
        $this->cancelados_empresa = $cancelados_empresa;

    }

    function carregaEquipamentoPerdido()
    {

        $this->result = null;
        $this->loadequipamentosperdidos();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result = $sql->fetchAll();
            $this->equipamentoPerdidoTecnologia();


        } else {

            $this->result = null;
        }

    }

    public function equipamentoPerdidoTecnologia()

    {

        $newarray = array();

        foreach ($this->getResult() as $item) {


            $meses[] = exibe_mes($item['data_fechamento']);

            if (strpos(unidade_financeira($item['unidade_financeira']), "Fibra") !== false) {

                array_push($this->perdido_fibra, ['nome' => $item['nome_razaosocial'],
                    'codigo' => $item['codpessoa'], 'email' => $item['email'], 'telefone' => $item['telefone'], 'bairro' => $item['bairro'], 'cidade' =>
                        $item['cidade'], 'mes' => exibe_mes($item['data_fechamento'])]);

            } elseif (strpos(unidade_financeira($item['unidade_financeira']), "Rádio") !== false) {

                array_push($this->perdido_radio, ['nome' => $item['nome_razaosocial'],
                    'codigo' => $item['codpessoa'], 'email' => $item['email'], 'telefone' => $item['telefone'], 'bairro' => $item['bairro'], 'cidade' =>
                        $item['cidade'], 'mes' => exibe_mes($item['data_fechamento'])]);

            }

        }

        $this->mesesequipperdido = array_unique($meses, SORT_REGULAR);
        $this->mesesequipperdido = array_values($this->mesesequipperdido);


        foreach ($this->getMesesequipperdido() as $item) {

            array_push($newarray, ['Mes' => $item, 'Fibra' => count($this->getPerdidoFibra($item)),
                'Radio' => count($this->getPerdidoRadio($item))]);


        }

        //$this->result = json_encode($newarray);
        $this->result = $newarray;

    }

    public function carregarFluxo()
    {

        $this->loadfluxo();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->resultfluxo = $sql->fetchAll();

        } else {

            $this->resultfluxo = null;
        }

    }

    public function carregarInativos($data)
    {

        $this->loadInativos();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue(':data', $data);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->inativos = $sql->fetchAll();
        } else {
            $this->inativos = null;
        }

    }

    public function canceladosMes_Atraso()
    {

        $array_mes = array();
        $array_atraso = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $item) {

                if (empty($item['data_abertura']) || $item['data_abertura'] >= date('Y-m-d',
                        mktime(0, 0, 0, date('m'), 1, date('Y')))) {

                    array_push($array_mes, $item);
                } else {

                    array_push($array_atraso, $item);
                }
            }

            $this->mes = $array_mes;
            $this->atraso = $array_atraso;

        } else {

            $this->mes = null;
            $this->atraso = null;
        }
    }

    private function diasdoMes()
    {


        $dt_i = date('d-m-Y', mktime(0, 0, 0, date('m'), 1, date('Y')));
        $dt_f = date('d-m-Y', mktime(23, 59, 59, date('m'), date("t"), date('Y')));

        $dias = array();

        $inicio = strtotime($dt_i);

        $fim = strtotime($dt_f);

        while ($inicio <= $fim) {

            $dias[] = date('j', $inicio);

            $inicio += 86400; // +1 day


        }

        $this->dates = $dias;
    }

    /**
     * @return mixed
     */
    public function getDates()
    {
        return $this->dates;
    }


    /**
     * @return mixed
     */
    public function getMesesequipperdido()
    {
        return $this->mesesequipperdido;
    }

    /**
     * @return array
     */
    public function getPerdidoRadio($mes)
    {
        $array = array();

        foreach ($this->perdido_radio as $item) {

            if ($item['mes'] == $mes) {


                array_push($array, $item);
            }


        }

        return $array;
    }

    /**
     * @return array
     */
    public function getPerdidoFibra($mes)
    {
        $array = array();

        foreach ($this->perdido_fibra as $item) {

            if ($item['mes'] == $mes) {


                array_push($array, $item);
            }


        }

        return $array;
    }

    /**
     * @return mixed
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * @return mixed
     */
    public function getMotivos()
    {
        return $this->motivos;
    }

    /**
     * @return mixed
     */
    public function getTotal()
    {
        return $this->total;
    }

    /**
     * @return mixed
     */
    public function getCanceladosTipo()
    {
        return $this->cancelados_tipo;
    }

    /**
     * @return mixed
     */
    public function getCanceladosEmpresa()
    {
        return $this->cancelados_empresa;
    }


    /**
     * @return mixed
     */
    public function getResultcancelados()
    {
        return $this->resultcancelados;
    }

    /**
     * @return mixed
     */
    public function getResultfluxo()
    {
        return $this->resultfluxo;
    }

    /**
     * @return mixed
     */
    public function getInativos()
    {
        return $this->inativos;
    }

    /**
     * @return mixed
     */
    public function getMes()
    {
        return $this->mes;
    }

    /**
     * @return mixed
     */
    public function getCanceladosSeguimento()
    {
        return $this->cancelados_seguimento;
    }

    /**
     * @return mixed
     */
    public function getAtraso()
    {
        return $this->atraso;
    }

    /**
     * @return mixed
     */
    public function getTotalDia()
    {
        return $this->totalDia;
    }

    /**
     * @return mixed
     */
    public function getResultado()
    {
        return $this->resultado;
    }


}
