<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 26/02/2019
 * Time: 15:40
 */

require_once "sql/SqlClientes.php";
setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
date_default_timezone_set('America/Sao_Paulo');

class Clientes extends SqlClientes
{

    private $carteira;
    private $carteira_tipo;
    private $adesao;
    private $adesao_tipo;
    private $vendidos_dia;
    private $totalclientes;
    private $result;


    function loadCarteira($nomenclatura, $seguimento)
    {

        $nomenclatura = implode("','", $nomenclatura);
        $this->carteira = null;
        $array = array();
        $total = array();
        $this->loadCarteiraClientes_Ativos($nomenclatura);
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();


        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $item) {

                array_push($array, $item);
                array_push($total, $item['codcontrato']);
            }

            $this->carteira = $array;
            $this->insereBase(count($total), $seguimento, date('Y'));

        } else {

            $this->carteira = null;
        }

    }

    function loadCarteira_Tipo($tipo)
    {

        $array = array();

        if (!empty($this->getCarteira())) {

            foreach ($this->getCarteira() as $item) {

                if (strstr(unidade_financeira($item['tipo']), $tipo)) {

                    array_push($array, $item);

                }
            }
            $this->carteira_tipo = $array;


        } else {

            $this->carteira_tipo = null;
        }


    }

    function loadAdesao()
    {

        $array = array();

        if (!empty($this->getCarteira())) {


            foreach ($this->getCarteira() as $item) {

                if (date('m-Y', strtotime($item['adesao'])) == date('m-Y')) {

                    array_push($array, $item);

                }
            }

            $this->adesao = $array;
        }


    }

    function loadAdesao_tipo($tipo)
    {

        $array = array();

        if (!empty($this->getCarteira())) {


            foreach ($this->getCarteira() as $item) {

                if (date('m-Y', strtotime($item['adesao'])) == date('m-Y') &&
                    strstr(unidade_financeira($item['tipo']), $tipo)) {

                    array_push($array, $item);

                }
            }

            $this->adesao_tipo = $array;
        }


    }

    function loadVendas_dia($codigogrupo_mk, $segmento)
    {

        $array = array();
        $this->loadVendidos();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue(':codigo', $codigogrupo_mk);
        $sql->bindValue(':segmento', $segmento);
        $sql->execute();

        if ($sql->rowCount() > 0) {


            foreach ($sql->fetchAll() as $item) {

                array_push($array, $item);
            }

            $this->vendidos_dia = $array;

        } else {

            $this->vendidos_dia = null;
        }


    }

    private function insereBase($total, $seguimento, $ano)
    {

        $this->loadtotalCarteira();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('mes', mb_strtoupper(exibe_mes(date('m')), 'UTF-8'));
        $sql->bindValue('seguimento', $seguimento);
        $sql->bindValue('ano', $ano);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $item) {

                if ($total == $item['total']) {

                    $this->totalclientes = $total;

                } else {

                    $data_alteracao = strftime('%Y-%m-%d %H:%M:%S');

                    $this->updatecarteiraCliente();
                    $sql = $this->getPdo()->prepare($this->getSql());
                    $sql->bindValue('total', $total);
                    $sql->bindValue('id', $item['id']);
                    $sql->bindValue('dt_alteracao', $data_alteracao);
                    $sql->execute();

                    if ($sql->rowCount() > 0) {

                        $this->totalclientes = $total;

                    } else {
                        $this->totalclientes = $sql->errorInfo();
                    }
                }

            }

        } else {

            $this->insereClientes();
            $sql = $this->getPdo()->prepare($this->getSql());
            $sql->bindValue('mes', date('n'));
            $sql->bindValue('ano', date('Y'));
            $sql->bindValue('total', $total);
            $sql->bindValue('seguimento', $seguimento);
            $sql->execute();

            if ($sql->rowCount() > 0) {

                $this->totalclientes = $total;

            } else {
                $this->totalclientes = 0;
            }
        }

    }

    function loadcarteiraAno($seguimento)
    {

        $array = array();
        $this->loadAllCarteira();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('seguimento', $seguimento);
        $sql->bindValue('ano', date('Y'));
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $item) {

                array_push($array, ['mes' => substr($item['mes'], 0, 3), 'total' =>
                    $item['total']]);
            }

            $this->totalclientes = json_encode($array);

        } else {

            $this->totalclientes = null;
        }

    }

    function loadCarteiraTotal($seguimento, $mes)
    {

        $this->loadtotalCarteira();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('mes', $mes);
        $sql->bindValue('seguimento', $seguimento);
        $sql->bindValue('ano', date('Y'));
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->totalclientes = $sql->fetchAll();

        } else {

            $this->totalclientes = null;
        }

    }




    public function carregarLista($dt_i, $dt_f)
    {

        $this->load_newAccession();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue('inicio', $dt_i);
        $sql->bindValue('fim', $dt_f);
        $sql->execute();

        if ($sql->rowCount() > 0) {

        $this->result = $sql->fetchAll();

    } else {

        $this->result = null;

    }

    }

    /**
     * @return mixed
     */
    public function getTotalclientes()
    {
        return $this->totalclientes;
    }


    /**
     * @return mixed
     */
    public function getCarteira()
    {
        return $this->carteira;
    }

    /**
     * @return mixed
     */
    public function getCarteiraTipo()
    {
        return $this->carteira_tipo;
    }

    /**
     * @return mixed
     */
    public function getAdesao()
    {
        return $this->adesao;
    }

    /**
     * @return mixed
     */
    public function getAdesaoTipo()
    {
        return $this->adesao_tipo;
    }

    /**
     * @return mixed
     */
    public function getVendidosDia()
    {
        return $this->vendidos_dia;
    }

    /**
     * @return mixed
     */
    public function getResult()
    {
        return $this->result;
    }

}
