<?php

require_once "sql/SqlCobranca.php";

class Cobranca extends SqlCobranca
{

    private $semCobranca;
    private $comCobranca;
    private $liquidados;
    private $totalMes;
    private $naoLiquidados;
    private $aguardandoLiquidados;
    private $total;
    private $anualLiquidados;
    private $equipamentoRetirado;
    private $equipamentoPerdido;
    private $totalEquipameentos;
    private $resultadoRetirados;
    private $resultadoPerdidos;
    private $loadSPC;

    public function __construct()
    {

        parent::__construct();
        $this->loadSemCobranca();
        $this->loadComCobranca();
    }

    private function loadSemCobranca()
    {

        $this->loadQuerySemCobranca();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();


        if ($sql->rowCount() > 0) {

            $this->semCobranca = $sql->fetchAll();

        } else {

            $this->semCobranca = null;


        }


    }

    private function loadComCobranca()
    {

        $this->loadQueryCobrancaSPC();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->comCobranca = $sql->fetchAll();
            $this->loadCobradosMes();
            $this->loadEquipamentos();
        } else {

            $this->comCobranca = null;

        }

    }

    private function loadCobradosMes()
    {

        $data_inicio = date('Y-m-d', mktime(0, 0, 0, date('m'), 1, date('Y')));
        $data_fim = date('Y-m-d', mktime(23, 59, 59, date('m'), date("t"), date('Y')));

        $arrayTotalMes = array();
        $arrayLiquidados = array();
        $arrayNaoLiquidados = array();
        $arrayAguardandoLiquidados = array();

        foreach ($this->getComCobranca() as $row) {
            if ($row['data_inicio'] >= $data_inicio && $row['data_inicio'] <= $data_fim) {
                array_push($arrayTotalMes, $row);
                if ($row['acordo'] === 'LIQUIDADO') {
                    array_push($arrayLiquidados, $row);
                }
                if ($row['acordo'] === 'AGUARDANDO PAGAMENTO' || $row['acordo'] === 'AGUARDANDO RETIRADA'
                || $row['acordo'] === 'ACORDO VENCIDO') {
                    array_push($arrayAguardandoLiquidados, $row);
                }
                if ($row['acordo'] === 'SPC OK') {
                    array_push($arrayNaoLiquidados, $row);
                }
            }

        }
        $this->totalMes = $arrayTotalMes;
        $this->liquidados = $arrayLiquidados;
        $this->naoLiquidados = $arrayNaoLiquidados;
        $this->aguardandoLiquidados = $arrayAguardandoLiquidados;

        $this->total = array_sum(array_column($arrayNaoLiquidados, 'valor')) + array_sum(array_column($arrayAguardandoLiquidados, 'valor'))
            + array_sum(array_column($arrayLiquidados, 'valor'));

    }

    public function chartSemana()
    {

        $label_chart_cobranca =  diasdaSemanaEmUmMes()['format_1'];
        $array = diasdaSemanaEmUmMes()['format_2'];
        $array_liquidados = array();
        $array_aguardando = array();
        $array_naoLiquidados = array();
        foreach ($array as $dias) {

            $array_temp = array();
            $data_inicio = substr($dias, 0, 10);
            $data_fim = substr($dias, 13, 23);

            foreach ($this->getLiquidados() as $row) {

                if ($row['data_inicio'] >= $data_inicio && $row['data_inicio'] <= $data_fim) {

                    array_push($array_temp, $row);
                }
            }

            array_push($array_liquidados, count($array_temp));
            $array_temp = [];

            foreach ($this->getAguardandoLiquidados() as $row) {

                if ($row['data_inicio'] >= $data_inicio && $row['data_inicio'] <= $data_fim) {

                    array_push($array_temp, $row);
                }
            }

            array_push($array_aguardando, count($array_temp));
            $array_temp = [];

            foreach ($this->getNaoLiquidados() as $row) {

                if ($row['data_inicio'] >= $data_inicio && $row['data_inicio'] <= $data_fim) {

                    array_push($array_temp, $row);
                }
            }

            array_push($array_naoLiquidados, count($array_temp));
            $array_temp = [];

        }
        return ['label' => $label_chart_cobranca, 'liquidados' => $array_liquidados,
            'negociacao' => $array_aguardando,
            'spc' => $array_naoLiquidados];
    }

    public function chartCobrancaAnualLiquidados()
    {

        $label = array();
        $label2 = array();
        $total = array();
        $total2 = array();
        $valorliquidado = array();
        $valorspc = array();
        $this->loadQueryCobrancaLiquidadosAnual();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

           foreach ($sql->fetchAll() as $row){


                   array_push($label, strtoupper(substr(exibe_mes($row['mes']), 0, 3)));
                   $label = array_unique($label);

                   array_push($label2, exibe_mes($row['mes']));
                   $label2 = array_unique($label2);

               if ($row['acordo'] == 'LIQUIDADO') {
                   array_push($total, $row['total']);
               }
               if ($row['acordo'] == 'SPC OK') {
                   array_push($total2, $row['total']);
               }
               if ($row['acordo'] == 'LIQUIDADO') {
                   array_push($valorliquidado, $row['valor']);
               }
               if ($row['acordo'] == 'SPC OK') {
                   array_push($valorspc, $row['valor']);
               }
           }


           $this->anualLiquidados = ['label' => $label, 'label_2' => $label2, 'total'=> $total, 'total2'=> $total2, 'valorliquidado' => $valorliquidado, 'valorspc' => $valorspc];

        } else {

            $this->anualLiquidados = null;

        }

    }


    private function loadEquipamentos()
    {
        $equipamentoRetirado = array();
        $equipamentoPerdido = array();

        $data_inicio = date('Y-m-d', mktime(0, 0, 0, date('m'), 1, date('Y')));
        $data_fim = date('Y-m-d', mktime(23, 59, 59, date('m'), date("t"), date('Y')));

        foreach ($this->getComCobranca() as $row) {
            if ($row['data_inicio'] >= $data_inicio && $row['data_inicio'] <= $data_fim) {
                if ($row['encerrado'] == 'FINALIZADA COM SUCESSO') {
                    array_push($equipamentoRetirado,$row);
                }
                if ($row['encerrado'] == 'EQUIPAMENTO PERDIDO') {
                    array_push($equipamentoPerdido, $row);
                }
            }
        }

        $this->equipamentoPerdido = $equipamentoPerdido;
        $this->equipamentoRetirado = $equipamentoRetirado;

        $this->totalEquipameentos = count($equipamentoRetirado) + count($this->equipamentoPerdido);
        $this->resultadoRetirados = (count($equipamentoRetirado) / $this->totalEquipameentos) * 100;
        $this->resultadoPerdidos = (count($equipamentoPerdido) / $this->totalEquipameentos) * 100;

    }

    public function loadSPC()
    {

        $this->loadQueryAbaSPC();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->loadSPC = $sql->fetchAll();

        } else {

            $this->loadSPC = null;

        }

    }

    /**
     * @return mixed
     */
    public function getSemCobranca()
    {
        return $this->semCobranca;
    }

    /**
     * @return mixed
     */
    public function getComCobranca()
    {
        return $this->comCobranca;
    }


    /**
     * @return mixed
     */
    public function getLiquidados()
    {
        return $this->liquidados;
    }

    /**
     * @return mixed
     */
    public function getTotalMes()
    {
        return $this->totalMes;
    }

    /**
     * @return mixed
     */
    public function getNaoLiquidados()
    {
        return $this->naoLiquidados;
    }

    /**
     * @return mixed
     */
    public function getAguardandoLiquidados()
    {
        return $this->aguardandoLiquidados;
    }

    /**
     * @return mixed
     */
    public function getTotal()
    {
        return $this->total;
    }

    /**
     * @return mixed
     */
    public function getAnualLiquidados()
    {
        return $this->anualLiquidados;
    }



    /**
     * @return mixed
     */
    public function getEquipamentoRetirado()
    {
        return $this->equipamentoRetirado;
    }

    /**
     * @return mixed
     */
    public function getEquipamentoPerdido()
    {
        return $this->equipamentoPerdido;
    }

    /**
     * @return mixed
     */
    public function getTotalEquipameentos()
    {
        return $this->totalEquipameentos;
    }

    /**
     * @return mixed
     */
    public function getResultadoRetirados()
    {
        return $this->resultadoRetirados;
    }

    /**
     * @return mixed
     */
    public function getResultadoPerdidos()
    {
        return $this->resultadoPerdidos;
    }

    /**
     * @return mixed
     */
    public function getLoadSPC()
    {
        return $this->loadSPC;
    }


}
