<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 01/11/2018
 * Time: 09:56
 */


require_once "sql/SQlComissoes.php";
require_once "../funcoes/funcoes.php";


class Comissoes extends SQlComissoes
{

    private $result;
    private $result_vendasexterno;
    private $resultGrupo;
    private $operadoresdogrupo;
    private $operadoresdogrupo_pago;


    //CARREGA A QUERY DE COMISSOES DE UMA DETERMINADA DATA
    function carregarComissoes($dt_i, $dt_f)
    {

        $this->loadComissoes();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue('datai', $dt_i);
        $sql->bindValue('dataf', $dt_f);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result = $sql->fetchAll();


        } else {
            $this->result = null;
        }

        $this->loadComissoes_externo();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue('datai', $dt_i);
        $sql->bindValue('dataf', $dt_f);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result_vendasexterno = $sql->fetchAll();


        } else {
            $this->result_vendasexterno = null;
        }


    }

    // CARREGA OPERADORES DE ACORDO COM O GRUPO
    public function carregarOperadoresGrupo($grupo)
    {

        $operadoresdogrupo = array();
        $operadoresdogrupo_pago = array();

        if ($grupo != 'ALL') {

            if ($grupo == 'CAC - Vendas') {

                foreach ($this->getResult() as $item) {

                    if ($item['grupo'] == $grupo) {
                        array_push($operadoresdogrupo,
                            ['operador' => $item['operador'], 'grupo' => $item['grupo']]);
                    }
                }


            } elseif ($grupo == 'Filiais') {

                foreach ($this->getResult() as $item) {

                    if ($item['grupo'] == $grupo) {
                        array_push($operadoresdogrupo,
                            ['operador' => $item['operador'], 'grupo' => $item['grupo']]);
                    }
                }

            } else {

                foreach ($this->getResult() as $item) {

                    if ($item['grupo'] == $grupo) {
                        array_push($operadoresdogrupo,
                            ['operador' => $item['operador'], 'grupo' => $item['grupo']]);
                    }


                }
            }

        } else {

            foreach ($this->getResult() as $item) {


                array_push($operadoresdogrupo,
                    ['operador' => strtolower($item['operador']), 'grupo' => $item['grupo']]);


            }


        }

        $this->operadoresdogrupo = array_unique($operadoresdogrupo, SORT_REGULAR);
        $this->operadoresdogrupo_pago = array_unique($operadoresdogrupo_pago, SORT_REGULAR);
        $this->operadoresdogrupo = array_merge($this->operadoresdogrupo, $this->operadoresdogrupo_pago);
        $this->operadoresdogrupo = array_values($this->operadoresdogrupo);
        array_multisort($this->operadoresdogrupo);
    }


    //carrega quantidade de vendas de acordo com o grupo e o operador
    public function carregarvendasOperadores($grupo, $operador, $tipo)
    {

        $total = array();

        foreach ($this->getResult() as $item) {

            if ($grupo == 'CAC - Vendas') {

                if ($item['grupo'] == $grupo && $item['operador'] == $operador &&
                    strstr(unidade_financeira($item['unidade_financeira']), $tipo)) {


                    $total[] = $item['codigo'];

                }

            } elseif ($grupo == 'Filiais') {

                if ($item['grupo'] == $grupo && $item['operador'] == $operador &&
                    strstr(unidade_financeira($item['unidade_financeira']), $tipo)) {


                    $total[] = $item['codigo'];

                }

            } else {

                if ($item['grupo'] == $grupo && $item['operador'] == strtoupper($operador) &&
                    strstr(unidade_financeira($item['unidade_financeira']), $tipo)) {


                    $total[] = $item['codigo'];


                }
            }


        }
        $this->resultGrupo = count($total);

    }


    /**
     * @return mixed
     */
    public function getOperadoresdogrupo()
    {
        return $this->operadoresdogrupo;
    }


    /**
     * @return mixed
     */
    public function getResultGrupo()
    {
        return $this->resultGrupo;
    }


    /**
     * @return mixed
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * @return mixed
     */
    public function getResultVendasexterno()
    {
        return $this->result_vendasexterno;
    }



}