<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 26/02/2019
 * Time: 15:40
 */

require_once "sql/sqlConexoes.php";
setlocale(LC_TIME, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
date_default_timezone_set('America/Sao_Paulo');

class Conexoes extends sqlConexoes
{

    private $result;
    private $dates;
    private $historico_dias;
    private $label_meses_acumulado;
    private $bloqueado_acumulado;
    private $bloqueado_seguimento;
    private $desbloqueado_seguimento;
    private $desbloqueado_acumulado;
    private $result_history;

    public function __construct()
    {

        parent::__construct();
        $this->diasdoMes();
    }

    // DESBLOQUEADOS AUTOMATICAMENTE POR INADIMPLENCIA ESTE MÊS
    function loadDesbloqueadosMes()
    {

        $this->sqlDesbloqueadosMes();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result = $sql->fetchAll();
            $this->totalDiaDesbloqueados('ult_desbloqueio');

        } else {

            $this->result = null;
        }

    }

    // DESBLOQUEADOS MANUALMENTE ESTE MES

    function loadDesbloqueadosManulMes()
    {

        $this->sqlDesbloqueadosManualMes();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result = $sql->fetchAll();

        } else {

            $this->result = null;
        }

    }


    private function totalDiaDesbloqueados($tipo)
    {

        $array = array();

        if (!empty($this->getDates())) {
            foreach ($this->getDates() as $date) {

                array_push($array, $this->historicoDia($date, $tipo));

            }

            $this->historico_dias = $array;
        }

    }


    // BLOQUEADOS AUTOMATICAMENTE POR INADIMPLENCIA ESTE MÊS
    function loadBloqueadosMes()
    {


        $this->sqlBloqueadosMes();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result = $sql->fetchAll();
            $this->totalDiaDesbloqueados('ult_bloqueio');

        } else {

            $this->result = null;
        }

    }

    function loadBloqueadosMesSeguimento($tipo)
    {

        $array = array();
        $this->bloqueado_seguimento = null;

        foreach ($this->getResult() as $row) {

            if (strstr(unidade_financeira($row['plano_contas']), $tipo)) {

                array_push($array, $row);
            }

        }

        $this->bloqueado_seguimento = $array;

    }

    function loadDesBloqueadosMesSeguimento($tipo)
    {

        $array = array();
        $this->desbloqueado_seguimento = null;

        foreach ($this->getResult() as $row) {

            if (strstr(unidade_financeira($row['plano_contas']), $tipo)) {

                array_push($array, $row);
            }

        }

        $this->desbloqueado_seguimento = $array;

    }

    function historicoDia($dia, $tipo)
    {

        $desbloqueados_dia = array();

        foreach ($this->getResult() as $row) {

            if ($dia == date('j', strtotime($row[$tipo]))) {

                array_push($desbloqueados_dia, $row['codconexao']);

            }
        }

        if (!empty($desbloqueados_dia)) {

            return count($desbloqueados_dia);

        } else {

            return 0;
        }


    }

    // REDUZIDOS  AUTOMATICAMENTE POR INADIMPLENCIA ESTE MÊS
    function loadReduzidosMes()
    {


        $this->sqlReduzidosMes();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result = $sql->fetchAll();
            $this->totalDiaDesbloqueados('ult_reducao');

        } else {

            $this->result = null;
        }

    }

    private function diasdoMes()
    {

        $dias = array();

        $inicio = strtotime(date('d-m-Y', mktime(0, 0, 0, date('m'), 1, date('Y'))));

        $fim = strtotime(date('d-m-Y'));

        while ($inicio <= $fim) {

            $dias[] = date('j', $inicio);

            $inicio += 86400; // +1 day


        }

        $this->dates = $dias;
    }

    // SALVA NO BANCO DE DADOS O HISTORICO
    function saveHistory(
        $arraybloqueados,
        $totalbloqueados,
        $arraydesbloqueados,
        $totaldesbloqueados)
    {

        $mes = date('n');
        $ano = date('Y');
        $data_registro = strftime('%c');
        $data_alteracao = strftime('%Y-%m-%d %I:%M:%S');

        if ($this->loadHistory($mes, $ano)) {

            $sql = "UPDATE acumulado_historico_conexao set array_bloqueados = ?, total_bloqueados_mes = ?, array_desbloqueados = ?, total_desbloqueados_mes = ?, ultima_alteracao = ? WHERE cod_mes = ? and ano = ?";
            $sql = $this->getPdo()->prepare($sql);
            $sql->execute(array(
                $arraybloqueados,
                $totalbloqueados,
                $arraydesbloqueados,
                $totaldesbloqueados,
                $data_alteracao,
                $mes,
                $ano,
            ));

            if ($sql->rowCount() > 0) {
                return "CRON - FINANCEIRO - Informações Atualizadas com Sucesso na base de dados em: $data_alteracao.";
            } else {
                return "Ocorreu um erro no CRON - FINANCEIRO: $sql->errorInfo(), data: $data_alteracao";
            }
        } else {

            $sql = "INSERT INTO acumulado_historico_conexao set cod_mes = ?, ano = ?, array_bloqueados = ?, total_bloqueados_mes = ?, array_desbloqueados = ?, total_desbloqueados_mes = ?";
            $sql = $this->getPdo()->prepare($sql);
            $sql->execute(array(
                $mes,
                $ano,
                $arraybloqueados,
                $totalbloqueados,
                $arraydesbloqueados,
                $totaldesbloqueados,
            ));

            if ($sql->rowCount() > 0) {
                return "CRON - FINANCEIRO - Informações Inseridas com Sucesso na base de dados em: $data_registro.";
            } else {
                return "Ocorreu um erro no CRON - FINANCEIRO: $sql->errorInfo(), data: $data_registro";
            }

        }

    }

    // CARREGA O HISTORICO NO BANCO DE DADOS
    private function loadHistory($mes, $ano)
    {

        $this->sqlHistoricoConexao();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('mes', $mes);
        $sql->bindValue('ano', $ano);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            return $sql->fetchAll();
        } else {
            return null;
        }

    }

    function carregaHistoricoBloqueioDesbloqueio($dt_i, $dt_f)
    {
        // CARREGA INFORMAÇÕES DA ABA FINANCEIRO > CLIENTES

        $this->result = null;
        $this->loadHistoricoBloqueioDesbloqueio();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue('data_i', $dt_i);
        $sql->bindValue('data_f', $dt_f);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result = $sql->fetchAll();

        }
    }

    //CARREGA BLOQUEADOS E DESBLOQUEADOS DA ABA FINANCEIRO > CLIENTES
    public function carrega_bloq_desb($seguimento, $tecnologia)
    {
        $array = array();
        $arrayDesb = array();
        $this->bloqueado_seguimento = null;
        $this->desbloqueado_seguimento = null;

        foreach ($this->getResult() as $row) {
            if (strstr(unidade_financeira($row['tipo']), $seguimento) &&
                unidade_financeira($row['tipo'])[0] == $tecnologia &&
                $row['descricao'] == 'Bloqueio') {
                array_push($array, $row);
            }if (strstr(unidade_financeira($row['tipo']), $seguimento) &&
                unidade_financeira($row['tipo'])[0] == $tecnologia &&
                $row['descricao'] != 'Bloqueio') {
                array_push($arrayDesb, $row);
            }
        }
        $this->bloqueado_seguimento = $array;
        $this->desbloqueado_seguimento = $arrayDesb;
    }

    function loadAllHistory()
    {

        $this->sqlAllHistoricoConexao();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->execute();
        if ($sql->rowCount() > 0) {

            $this->result_history = $sql->fetchAll();
            // MONTA OS DADOS PARA O CHART DE ACUMULADO
            $this->loadAcumulados();

        } else {

            $this->label_meses_acumulado = null;
        }

    }

    private function loadAcumulados()
    {


        $this->label_meses_acumulado = array_map(function ($var) {
            if ($var['cod_mes'] < date('n')) {
                return $array[] = strtoupper(substr(exibe_mes($var['cod_mes']), 0, 3));
            }
        }, $this->result_history);

        $this->bloqueado_acumulado = array_map(function ($var) {
            if ($var['cod_mes'] < date('n')) {
                return $array[] = $var['total_bloqueados_mes'];
            }
        }, $this->result_history);

        $this->desbloqueado_acumulado = array_map(function ($var) {
            if ($var['cod_mes'] < date('n')) {
                return $array[] = $var['total_desbloqueados_mes'];
            }
        }, $this->result_history);


    }

    /**
     * @return mixed
     */
    public function getHistoricoDias()
    {
        return $this->historico_dias;
    }

    /**
     * @return mixed
     */
    public function getBloqueadoSeguimento()
    {
        return $this->bloqueado_seguimento;
    }


    /**
     * @return mixed
     */
    public function getDates()
    {
        return $this->dates;
    }

    /**
     * @return mixed
     */
    public function getLabelMesesAcumulado()
    {
        return $this->label_meses_acumulado;
    }

    /**
     * @return mixed
     */
    public function getBloqueadoAcumulado()
    {
        return $this->bloqueado_acumulado;
    }

    /**
     * @return mixed
     */
    public function getDesbloqueadoAcumulado()
    {
        return $this->desbloqueado_acumulado;
    }

    /**
     * @return mixed
     */
    public function getDesbloqueadoSeguimento()
    {
        return $this->desbloqueado_seguimento;
    }


    /**
     * @return mixed
     */
    public function getResult()
    {
        return $this->result;
    }


}
