<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 28/09/2018
 * Time: 10:33
 */
require_once "sql/SQLDashAdm.php";

class Dashboard_Adm extends SQLDashAdm
{
    private $result;
    private $instalados;
    private $acumudalo_semana;
    private $acumudalo_mes;
    private $acumudalo_anual_instalados;
    private $acumulado_tecnologia;
    private $acumulado_empresa;
    private $acumulado_tecnologia_naoconcluidas;
    private $pendentes;
    private $pendentes_semana;
    private $pendentes_tipo;
    private $semana;
    private $cidades;
    private $acumulado_all;


    public function carregarOS($dt_i, $dt_f)
    {

        $this->load_newOS();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue('inicio', $dt_i);
        $sql->bindValue('fim', $dt_f);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result = $sql->fetchAll();

        } else {

            $this->result = null;

        }

    }

    public function instalados($dt_i, $dt_f)
    {

        $total = array();

        foreach ($this->getResult() as $row) {


            if ($row['data_fechamento'] >= $dt_i && $row['data_fechamento'] <= $dt_f) {

                if ($row['encerrado'] == 'S' && $row['os'] == 'INSTALAÇÃO' && $row['status'] == 'SUCESSO'
                    && unidade_financeira($row['tipo']) != 'Cortesia' && $row['metodo_faturamento'] != 3 &&
                    unidade_financeira($row['tipo']) != 'Interfone') {

                    $total[] = $row['codos'];

                }
            } else {

                $this->instalados = null;
            }
        }

        $this->instalados = count($total);

    }

    //CARREGA INSTALAÇÕES DOS CLIENTES DA ABA FINANCEIRO > CLIENTES
    public function instalacoes_tecnologia($tipo, $dt_i, $dt_f, $tecnologia)
    {
        $testeall = array();
        foreach ($this->getResult() as $row) {
            if ($row['data_fechamento'] >= $dt_i && $row['data_fechamento'] <= $dt_f) {
                if ($row['encerrado'] == 'S' && $row['os'] == 'INSTALAÇÃO' && $row['status'] == 'SUCESSO'
                    && unidade_financeira($row['tipo']) != 'Cortesia' &&
                    strstr(unidade_financeira($row['tipo']), $tipo) &&
                    $row['metodo_faturamento'] != 3 &&
                    unidade_financeira($row['tipo']) != 'Interfone' &&
                    unidade_financeira($row['tipo']) != 'Sem Contrato' &&
                    unidade_financeira($row['tipo'])[0] == $tecnologia) {

                    array_push($testeall, $row);

                } else {
                    $this->acumulado_all = null;

                }
            }
        }
        $this->acumulado_all = $testeall;

    }

    public function pendentes($dt_i, $dt_f)
    {


        $pendentes = array();

        foreach ($this->getResult() as $row) {


            if ($row['encerrado'] == 'N' && $row['os'] == 'INSTALAÇÃO' && $row['status'] == 'PENDENTE' &&
                unidade_financeira($row['tipo']) != 'Sem Contrato'
                && $row['data'] >= $dt_i && $row['data'] <= $dt_f) {

                $pendentes[] = $row['codos'];

            }

        }

        $this->pendentes = count($pendentes);
    }

    public function pendente_semana()
    {

        $pendentes_sem = array();
        $date = gmdate('w');
        $date = 5 - $date;

        for ($i = 0; $i <= $date; $i++) {

            $inicio = date('Y-m-d', strtotime('+' . $i . ' days'));

            foreach ($this->getResult() as $row) {

                if ($row['data'] == $inicio) {

                    if ($row['encerrado'] == 'N' && $row['os'] == 'INSTALAÇÃO' && $row['status'] == 'PENDENTE' &&
                        unidade_financeira($row['tipo']) != 'Sem Contrato') {

                        $pendentes_sem[] = $row['codos'];

                    }

                }
            }

            $this->pendentes_semana = count($pendentes_sem);
        }

    }

    public function pendente_tipo($tipo, $dt_i, $dt_f)
    {

        $pendentes_mes = array();


        foreach ($this->getResult() as $row) {


            if ($row['encerrado'] == 'N' && $row['os'] == 'INSTALAÇÃO' && $row['status'] == 'PENDENTE' &&
                $row['data'] >= $dt_i && $row['data'] <= $dt_f && unidade_financeira($row['tipo']) != 'Sem Contrato' &&
                strstr(unidade_financeira($row['tipo']), $tipo)) {

                $pendentes_mes[] = $row['codos'];

            }


        }

        $this->pendentes_tipo = count($pendentes_mes);
    }

    public function acumulados_semana($tipo)
    {

        $total_semana = array();
        $naoconcluidas = array();
        $sucesso = array();
        $date = gmdate('w');
        $date = $date - 1;


        //ACUMULADO SEMANA
        for ($i = 0; $i <= $date; $i++) {

            $inicio = date('Y-m-d', strtotime('-' . $i . ' days'));

            foreach ($this->getResult() as $row) {


                if ($row['data_fechamento'] == $inicio) {

                    if ($row['encerrado'] == 'S' && $row['os'] == 'INSTALAÇÃO' && $row['status'] == 'SUCESSO'
                        && unidade_financeira($row['tipo']) != 'Cortesia' && $row['metodo_faturamento'] != 3 &&
                        unidade_financeira($row['tipo']) != 'Interfone' &&
                        unidade_financeira($row['tipo']) != 'Sem Contrato') {

                        $total_semana[] = $row['codos'];

                    }

                    if ($row['encerrado'] == 'S' && $row['os'] == 'INSTALAÇÃO' && $row['status'] == 'SUCESSO'
                        && strstr(unidade_financeira($row['tipo']), $tipo)) {

                        $sucesso[] = $row['codos'];

                    }

                    if ($row['encerrado'] == 'S' && $row['os'] == 'INSTALAÇÃO' && $row['status'] != 'SUCESSO'
                        && strstr(unidade_financeira($row['tipo']), $tipo)) {

                        $naoconcluidas[] = $row['codos'];

                    }


                }
            }

            $this->acumulado_tecnologia = count($sucesso);
            $this->acumulado_tecnologia_naoconcluidas = count($naoconcluidas);
            $this->acumudalo_semana = count($total_semana);

        }


    }

    public function acumulados_semana_empresa($empresa)
    {

        $total_semana = array();
        $sucesso = array();
        $date = gmdate('w');
        $date = $date - 1;


        //ACUMULADO SEMANA
        for ($i = 0; $i <= $date; $i++) {

            $inicio = date('Y-m-d', strtotime('-' . $i . ' days'));

            foreach ($this->getResult() as $row) {


                if ($row['data_fechamento'] == $inicio) {

                    if ($row['encerrado'] == 'S' && $row['os'] == 'INSTALAÇÃO' && $row['status'] == 'SUCESSO'
                        && unidade_financeira($row['tipo']) != 'Cortesia' && $row['metodo_faturamento'] != 3 &&
                        unidade_financeira($row['tipo']) != 'Interfone' &&
                        unidade_financeira($row['tipo']) != 'Sem Contrato') {

                        $total_semana[] = $row['codos'];

                    }

                    if ($row['encerrado'] == 'S' && $row['os'] == 'INSTALAÇÃO' && $row['status'] == 'SUCESSO'
                        && empresa($row['tipo']) == $empresa) {

                        $sucesso[] = $row['codos'];

                    }

                }
            }

            $this->acumulado_tecnologia = count($sucesso);
            $this->acumudalo_semana = count($total_semana);

        }


    }

    //carrega o acumulado do mes de instalados
    public function acumulados_mes($tipo, $dt_i, $dt_f)
    {
        $total_mes = array();
        $naoconcluidas = array();
        $sucesso = array();
        $sucessoall = array();

        //ACUMULADO MES
        foreach ($this->getResult() as $row) {

            if ($row['data_fechamento'] >= $dt_i && $row['data_fechamento'] <= $dt_f) {

                if ($row['encerrado'] == 'S' && $row['os'] == 'INSTALAÇÃO' && $row['status'] == 'SUCESSO'
                    && unidade_financeira($row['tipo']) != 'Cortesia' && $row['metodo_faturamento'] != 3 &&
                    unidade_financeira($row['tipo']) != 'Interfone' &&
                    unidade_financeira($row['tipo']) != 'Sem Contrato') {

                    $total_mes[] = $row['codos'];


                }
                if ($row['encerrado'] == 'S' && $row['os'] == 'INSTALAÇÃO' && $row['status'] == 'SUCESSO'
                    && unidade_financeira($row['tipo']) != 'Cortesia' &&
                    strstr(unidade_financeira($row['tipo']), $tipo) &&
                    $row['metodo_faturamento'] != 3 &&
                    unidade_financeira($row['tipo']) != 'Interfone' &&
                    unidade_financeira($row['tipo']) != 'Sem Contrato') {

                    $sucesso[] = $row['codos'];
                    array_push($sucessoall, $row);

                }

                if ($row['encerrado'] == 'S' && $row['os'] == 'INSTALAÇÃO' && $row['status'] != 'SUCESSO'
                    && strstr(unidade_financeira($row['tipo']), $tipo) && $row['metodo_faturamento'] != 3) {

                    $naoconcluidas[] = $row['codos'];

                }
            } else {
                $this->acumudalo_mes = null;
                $this->acumulado_tecnologia = null;
                $this->acumulado_tecnologia_naoconcluidas = null;
                $this->acumulado_all = null;
            }


        }

        $this->acumulado_tecnologia = count($sucesso);
        $this->acumulado_tecnologia_naoconcluidas = count($naoconcluidas);
        $this->acumudalo_mes = count($total_mes);
        $this->acumulado_all = $sucessoall;


    }

    public function acumulados_mes_empresa($empresa, $dt_i, $dt_f)
    {

        $total_mes = array();
        $sucesso = array();
        $sucessoall = array();


        //ACUMULADO MES
        foreach ($this->getResult() as $row) {

            if ($row['data_fechamento'] >= $dt_i && $row['data_fechamento'] <= $dt_f) {

                if ($row['encerrado'] == 'S' && $row['os'] == 'INSTALAÇÃO' && $row['status'] == 'SUCESSO'
                    && unidade_financeira($row['tipo']) != 'Cortesia' && $row['metodo_faturamento'] != 3 &&
                    unidade_financeira($row['tipo']) != 'Interfone' &&
                    unidade_financeira($row['tipo']) != 'Sem Contrato') {

                    $total_mes[] = $row['codos'];


                }
                if ($row['encerrado'] == 'S' && $row['os'] == 'INSTALAÇÃO' && $row['status'] == 'SUCESSO'
                    && empresa($row['tipo']) == $empresa && $row['metodo_faturamento'] != 3) {

                    $sucesso[] = $row['codos'];
                    array_push($sucessoall, $row);

                }

            } else {
                $this->acumudalo_mes = null;
                $this->acumulado_tecnologia = null;
                $this->acumulado_all = null;
            }


        }

        $this->acumulado_tecnologia = count($sucesso);
        $this->acumudalo_mes = count($total_mes);
        $this->acumulado_all = $sucessoall;


    }

    //carrega os instalados por tipo de uma data especifica
    public function instalados_tipo($dt, $tipo)
    {

        $total = array();
        $naoconcluidas = array();

        foreach ($this->getResult() as $row) {


            if ($row['encerrado'] == 'S' && $row['os'] == 'INSTALAÇÃO' && $row['status'] == 'SUCESSO' &&
                $row['data_fechamento'] == $dt && unidade_financeira($row['tipo']) != 'Cortesia' &&
                strstr(unidade_financeira($row['tipo']), $tipo)) {


                $total[] = $row['codos'];

            }
            if ($row['encerrado'] == 'S' && $row['os'] == 'INSTALAÇÃO' && $row['status'] != 'SUCESSO' &&
                unidade_financeira($row['tipo']) != 'Cortesia' && $row['data_fechamento'] == $dt &&
                strstr(unidade_financeira($row['tipo']), $tipo)) {


                $naoconcluidas[] = $row['codos'];

            }


        }

        $this->acumulado_tecnologia = count($total);
        $this->acumulado_tecnologia_naoconcluidas = count($naoconcluidas);
    }


    public function instalados_empresa($dt, $empresa)
    {

        $total = array();

        foreach ($this->getResult() as $row) {


            if ($row['encerrado'] == 'S' && $row['os'] == 'INSTALAÇÃO' && $row['status'] == 'SUCESSO' &&
                $row['data_fechamento'] == $dt && $row['metodo_faturamento'] != 3 &&
                empresa($row['tipo']) == $empresa) {


                $total[] = $row['codos'];

            }

        }

        $this->acumulado_tecnologia = count($total);
    }


    // acumulado por dia dos instalados
    public function acumulado_instalacao_diario($dias, $tipo)
    {

        $instalados_tipo = array();
        $semana = array();


        for ($i = 0; $i < $dias; $i++) {


            $array = array();
            $data = date('Y-m-d', strtotime('-' . $i . 'day'));


            if (!(verificafinaldesemana($data))) {

                array_push($semana, exibediadasemana($data));

                foreach ($this->getResult() as $item) {

                    if ($item['data'] == date('Y-m-d', strtotime('-' . $i . 'day')))

                        if (strpos(unidade_financeira($item['tipo']), $tipo) !== false && $item['encerrado'] == 'S' && $item['os'] == 'INSTALAÇÃO' && $item['status'] == 'SUCESSO') {

                            $array[] = $item['codos'];
                            //array_push($cancelados_tipo, ['data' => $item['data'], 'contrato' => $item['codcontrato'], 'tipo' => unidade_financeira($item['tipo'])]);

                        }
                }

                array_push($instalados_tipo, count($array));
            }
        }

        $this->acumulado_tecnologia = $instalados_tipo;
        $this->semana = $semana;

    }

    public function acumulado_instalacao_diario_empresa($dias, $empresa)
    {

        $instalados_empresa = array();
        $semana = array();


        for ($i = 0; $i < $dias; $i++) {


            $array = array();
            $data = date('Y-m-d', strtotime('-' . $i . 'day'));


            if (!(verificafinaldesemana($data))) {

                array_push($semana, exibediadasemana($data));

                foreach ($this->getResult() as $item) {

                    if ($item['data'] == date('Y-m-d', strtotime('-' . $i . 'day')))

                        if (empresa($item['tipo']) === $empresa && $item['encerrado'] == 'S'
                            && $item['os'] == 'INSTALAÇÃO' && $item['status'] == 'SUCESSO' &&
                            $item['metodo_faturamento'] != 3) {

                            $array[] = $item['codos'];

                        }
                }

                array_push($instalados_empresa, count($array));
            }
        }

        $this->acumulado_empresa = $instalados_empresa;
        $this->semana = $semana;

    }

    function carregaVendasAnual()
    {

        $this->load_anualVendas();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $item) {

                // carrega o array somente com os valores especificados
                $array[] = array('mes' => exibe_mes($item['mes']), 'valor' => $item['valor']);

            }

            //converte o array em json
            $this->acumudalo_anual_instalados = json_encode($array);

        } else {

            $this->acumudalo_anual_instalados = null;
        }

    }

    public function top_cidades($dt_i, $dt_f)
    {

        $cidades = array();

        foreach ($this->getResult() as $row) {


            if ($row['data_fechamento'] >= $dt_i && $row['data_fechamento'] <= $dt_f) {

                if ($row['encerrado'] == 'S' && $row['os'] == 'INSTALAÇÃO' && $row['status'] == 'SUCESSO' &&
                    $row['metodo_faturamento'] != 3) {

                    array_push($cidades, $row['cidade']);

                }
            } else {

                $this->cidades = null;
            }
        }

        $this->cidades = array_count_values($cidades);
    }

    /**
     * @return mixed
     */
    public function getAcumuladoAll()
    {
        return $this->acumulado_all;
    }


    /**
     * @return mixed
     */
    public function getAcumudaloAnualInstalados()
    {
        return $this->acumudalo_anual_instalados;
    }


    /**
     * @return mixed
     */
    public function getSemana()
    {
        return $this->semana;
    }

    /**
     * @return mixed
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * @return mixed
     */
    public function getInstalados()
    {
        return $this->instalados;
    }

    /**
     * @return mixed
     */
    public function getAcumudaloSemana()
    {
        return $this->acumudalo_semana;
    }

    /**
     * @return mixed
     */
    public function getAcumudaloMes()
    {
        return $this->acumudalo_mes;
    }

    /**
     * @return mixed
     */
    public function getAcumuladoTecnologia()
    {
        return $this->acumulado_tecnologia;
    }

    /**
     * @return mixed
     */
    public function getAcumuladoTecnologiaNaoconcluidas()
    {
        return $this->acumulado_tecnologia_naoconcluidas;
    }

    /**
     * @return mixed
     */
    public function getAcumuladoEmpresa()
    {
        return $this->acumulado_empresa;
    }

    /**
     * @return mixed
     */
    public function getPendentes()
    {
        return $this->pendentes;
    }

    /**
     * @return mixed
     */
    public function getPendentesSemana()
    {
        return $this->pendentes_semana;
    }


    /**
     * @return mixed
     */
    public function getPendenteTipo()
    {
        return $this->pendentes_tipo;
    }

    /**
     * @return mixed
     */
    public function getCidades()
    {
        return $this->cidades;
    }


}
