<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 26/11/2018
 * Time: 12:26
 */

require_once "sql/SqlDashCac.php";

class Dashboard_Cac extends SqlDashCac
{

    private $result;
    private $valores;
    private $total;


    function carregarFluxo()
    {

        $this->result = null;
        $this->loadFluxo();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result = $sql->fetchAll();

        }

    }

    function carregarFluxo2()
    {

        $this->result = null;
        $this->loadFluxo2();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result = $sql->fetchAll();

        }

    }

    public function carregaVendas()
    {

        $this->loadVendas();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result = $sql->fetchAll();

        } else {

            $this->result = null;
        }
    }

    function LoadMesPassado($operador)
    {

        $this->valores = null;

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if ($row['mes'] == 'Mes Passado' && $row['operador'] == $operador) {

                    $this->valores = $row['quantidade'];

                }
            }
        }


    }

    function LoadMesAtual($operador)
    {

        $this->valores = null;

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if ($row['mes'] == 'Mes Atual' && $row['operador'] == $operador) {

                    $this->valores = $row['quantidade'];

                }
            }
        }

    }

    function LoadOperador()
    {

        $this->valores = null;

        $array = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if (!($row['operador'] == 'fernandosantos')) {
                    $array[] = $row['operador'];
                }
            }
        }

        $this->valores = $array;
        $this->valores = array_unique($this->valores);

    }


    function LoadComissao()
    {

        $total = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if ($row['mes'] == 'Mes Atual') {

                    $total[] = $row['quantidade'];

                }
            }
        }
        $this->total = array_sum($total);

    }

    /**
     * @return mixed
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * @return mixed
     */
    public function getValores()
    {
        return $this->valores;
    }

    /**
     * @return mixed
     */
    public function getTotal()
    {
        return $this->total;
    }


}
