<?php

require_once "sql/SqlDashCRM.php";

class Dashboard_Crm extends SqlDashCRM
{

    private $reunioes;
    private $reunioesFinalizadas;
    private $reunioesAgendadas;
    private $vendedores;
    private $oportunidades;
    private $somaOportunidades;
    private $totalOportunidade;


    public function __construct()
    {
        parent::__construct();
        $this->loadVendedores();
    }

    function loadReunioes($dt_i, $dt_f)
    {
        $this->reunioes = null;
        $this->loadSqlReunioes();
        $sql = $this->getPdoCRM()->prepare($this->getSql());
        $sql->bindValue('inicio', $dt_i);
        $sql->bindValue('fim', $dt_f);
        $sql->execute();

        if($sql->rowCount() > 0){
            $this->reunioes = $sql->fetchAll();
            $this->filterMeeting();

        }

    }

    function loadOportunidades($dt_i, $dt_f)
    {
        $this->oportunidades = null;
        $this->loadSqlOportunidade();
        $sql = $this->getPdoCRM()->prepare($this->getSql());
        $sql->bindValue('inicio', $dt_i);
        $sql->bindValue('fim', $dt_f);
        $sql->execute();

        if($sql->rowCount() > 0){
            $this->oportunidades = $sql->fetchAll();
            $this->filterOportunidade();

        }

    }

    function loadSomaOportunidades($dt_i, $dt_f)
    {
        $this->somaOportunidades = null;
        $this->totalOportunidade = array();
        $this->loadSqlSomaOportunidades();
        $sql = $this->getPdoCRM()->prepare($this->getSql());
        $sql->bindValue('inicio', $dt_i);
        $sql->bindValue('fim', $dt_f);
        $sql->execute();

        if($sql->rowCount() > 0){
            $this->somaOportunidades = $sql->fetchAll();

        }

        if(!empty($this->somaOportunidades)) {
            foreach ($this->somaOportunidades as $row) {

                array_push($this->totalOportunidade, $row['valor']);

            }
        }

    }

    private function loadVendedores(){

        //array de cores para criaçao do avatar do nome
        $vendedores = array();
        $color = ['btn-pink', 'btn-warning', 'btn-danger', 'btn-info', 'btn-dark'];

        $this->vendedores = null;
        $this->loadSqlVendedores();
        $sql = $this->getPdoCRM()->prepare($this->getSql());
        $sql->execute();

        if($sql->rowCount() > 0) {

            $this->vendedores = $sql->fetchAll();

            foreach ($this->vendedores as $key => $row) {

                array_push($vendedores, ['vendedores' =>
                    $row['first_name'] . ' ' . $row['last_name']]);
            }

            $vendedores = array_unique($vendedores, SORT_REGULAR);

            sort($vendedores);

            $newVendedores = array();

            foreach ($vendedores as $key => $value) {

                array_push($newVendedores, ['vendedores' => $value['vendedores'],
                    'color' => $color[$key++]]);

            }

            $this->vendedores = $newVendedores;
        }

    }

    public function loadCorVendedor($vendedor){

        $cor = null;

        foreach ($this->getVendedores() as $row){

            if($row['vendedores'] === $vendedor){

                $cor = $row['color'];
            }

        }

        return $cor;

    }

    private function filterOportunidade(){

        $newOportunidade = array();

        foreach ($this->oportunidades as $key  => $row){



        }
    }

    private function filterMeeting(){


        // total finalizadas
        $arrayFinalizadas = array();

        // total agendadas
        $arrayAgendadas = array();

        foreach ($this->getReunioes() as $row){

            if ($row['status'] === 'Held'){

                array_push($arrayFinalizadas, $row);

            }
            if ($row['status'] === 'Planned'){

                array_push($arrayAgendadas, $row);

            }

        }

        $this->reunioesFinalizadas = $arrayFinalizadas;
        $this->reunioesAgendadas = $arrayAgendadas;
    }

    /**
     * @return mixed
     */
    public function getReunioes()
    {
        return $this->reunioes;
    }

    /**
     * @return mixed
     */
    public function getReunioesFinalizadas()
    {
        return $this->reunioesFinalizadas ;
    }

    /**
     * @return mixed
     */
    public function getReunioesAgendadas()
    {
        return $this->reunioesAgendadas;
    }

    /**
     * @return mixed
     */
    public function getVendedores()
    {
        return $this->vendedores;
    }

    /**
     * @return mixed
     */
    public function getOportunidades()
    {
        return $this->oportunidades;
    }

    /**
     * @return mixed
     */
    public function getSomaOportunidades()
    {
        return $this->somaOportunidades;
    }

    /**
     * @return mixed
     */
    public function getTotalOportunidade()
    {
        return array_sum($this->totalOportunidade);
    }



}

