<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 28/09/2018
 * Time: 10:33
 */
require_once "sql/sqlDashOS.php";

class Dashboard_OS extends sqlDashOS
{
    private $result;
    private $tecnicos;
    private $concluidas;
    private $os_pendente;
    private $os_seguimento;
    private $seguimentos;
    private $tipo_os;
    private $total_tipo_os;
    private $os_tecnicos;
    private $os_tecnicos_tipo;


    /**
     * Dashboard_OS constructor.
     * @param $result
     */
    public function __construct($dt_i, $dt_f)
    {

        parent::__construct();
        $this->carregarOS($dt_i, $dt_f);
    }


    //CARREGA TODAS AS OS DE UMA DATA ESPECIFICA
    private function carregarOS($dt_i, $dt_f)
    {

        $this->load_OS();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue('inicio', $dt_i);
        $sql->bindValue('fim', $dt_f);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result = $sql->fetchAll(PDO::FETCH_ASSOC);
            $this->tipo_os = $this->carrega_tipo_OS();
            $this->tecnicos = $this->carrega_tecnicos();

        } else {

            $this->result = null;

        }

    }

    private function carrega_tipo_OS()
    {


        $this->tipo_os = null;
        $array = array();

        foreach ($this->getResult() as $item) {

            array_push($array, tipo_os($item['tipo_os']));

        }

        $tipo_os = array_unique($array);
        $tipo_os = array_values($tipo_os);
        sort($tipo_os);
        return $tipo_os;

    }

    private function carrega_tecnicos()
    {

        $tecnicos = array();


        foreach ($this->getResult() as $row) {

            //27 codigo operador dgddias para ajuste de base de sistema
            if ($row['codtecnico'] !== 27)
                array_push($tecnicos, ['codigo' => $row['codtecnico'], 'nome' => $row['tecnicos']]);

        }
        $tecnicos = array_unique($tecnicos, SORT_REGULAR);


        $tecnicos = array_values($tecnicos);

        return $tecnicos;
    }


    // OS ACUMULADAS EM UM PERIODO DE DATA
    public function os_concluidas($dt_i, $dt_f)
    {
        $this->concluidas = $this->filtra_OS($dt_i, $dt_f);
    }


    //CARREGA OS CONCLUIDA POR SEGMENTO EM UM PERIODO
    public
    function os_concluidas_seguimento($seguimento, $dt_i, $dt_f)
    {

        $this->os_seguimento = $this->filtra_OS_seguimento_concluidas($dt_i, $dt_f, $seguimento);

    }

    public
    function os_Tecnico($tecnico, $dt_i, $dt_f)
    {


        $this->os_tecnicos = $this->filtra_OS_tecnico($tecnico, $dt_i, $dt_f);

    }

    public function os_tecnico_tipo_os($tecnico, $tipo_os, $dt_i, $dt_f)
    {

        $this->os_tecnicos_tipo = $this->filtra_OS_tecnico_tipo($tecnico, $dt_i, $dt_f, $tipo_os);

    }

    public function os_tipo_os($tipo_os, $dt_i, $dt_f)
    {

        $this->total_tipo_os = $this->filtra_OS_tipo($dt_i, $dt_f, $tipo_os);

    }

    // CARREGA OS PENDENTES DE UMA DATA ESPECIFICA
    public
    function os_pendentes($dt_i, $dt_f)
    {

        $this->os_pendente = $this->filtra_OS_pendente($dt_i, $dt_f);

    }

    private
    function filtra_OS($dt_i, $dt_f)
    {

        $this->seguimentos = null;
        $array = array();
        $seguimento = array();

        foreach ($this->getResult() as $row) {

            if ($row['data_fechamento'] >= $dt_i &&
                $row['data_fechamento'] <= $dt_f) {

                if ($row['encerrado'] == 'S' &&
                    verifica_ecerramento_os($row['encerramento']) == 'FINALIZADO COM SUCESSO') {

                    array_push($array, $row);
                    array_push($seguimento, ultima_string(unidade_financeira($row['tipo'])));

                }
            }
        }

        $this->seguimentos = array_unique($seguimento);
        $this->seguimentos = array_values($this->seguimentos);
        return $array;

    }

    private
    function filtra_OS_tipo($dt_i, $dt_f, $tipo_os)
    {

        $array = array();

        foreach ($this->getResult() as $row) {

            if ($row['data_fechamento'] >= $dt_i &&
                $row['data_fechamento'] <= $dt_f) {

                if ($row['encerrado'] == 'S' &&
                    verifica_ecerramento_os($row['encerramento']) == 'FINALIZADO COM SUCESSO' &&
                    tipo_os($row['tipo_os']) == $tipo_os) {

                    array_push($array, $row);

                }
            }
        }

        return $array;

    }

    private
    function filtra_OS_pendente($dt_i, $dt_f)
    {

        $array = array();

        foreach ($this->getResult() as $row) {

            if ($row['data'] >= $dt_i &&
                $row['data'] <= $dt_f) {

                if ($row['encerrado'] == 'N') {

                    array_push($array, $row);

                }
            }
        }

        return $array;

    }

    private
    function filtra_OS_tecnico_tipo($tecnico, $dt_i, $dt_f, $tipo_os)
    {

        $array = array();

        foreach ($this->getResult() as $row) {

            if ($row['data'] >= $dt_i && $row['data'] <= $dt_f
                && $row['codtecnico'] == $tecnico && tipo_os($row['tipo_os']) == $tipo_os) {

                array_push($array, $row);

            }

        }

        return $array;

    }

    private
    function filtra_OS_tecnico($tecnico, $dt_i, $dt_f)
    {

        $array = array();

        foreach ($this->getResult() as $row) {

            if ($row['data'] >= $dt_i && $row['data'] <= $dt_f && $row['codtecnico'] == $tecnico) {

                array_push($array, $row);

            }

        }

        return $array;
    }

    private
    function filtra_OS_seguimento_concluidas($dt_i, $dt_f, $seguimento)
    {

        $array = array();

        foreach ($this->getResult() as $row) {

            if ($row['data_fechamento'] >= $dt_i && $row['data_fechamento'] <= $dt_f
                && strstr(unidade_financeira($row['tipo']), $seguimento) &&
                verifica_ecerramento_os($row['encerramento']) == 'FINALIZADO COM SUCESSO') {

                array_push($array, $row);

            }

        }
        return $array;
    }

    /**
     * @return mixed
     */
    public function getTecnicos()
    {
        return $this->tecnicos;
    }


    /**
     * @return mixed
     */
    public
    function getOsPendentes()
    {
        return $this->os_pendente;
    }


    /**
     * @return mixed
     */
    public
    function getSeguimentos()
    {
        return $this->seguimentos;
    }

    /**
     * @return mixed
     */
    public
    function getOsConcluidaSeguimento()
    {
        return $this->os_seguimento;
    }


    /**
     * @return mixed
     */
    public
    function getConcluidas()
    {
        return $this->concluidas;
    }


    /**
     * @return mixed
     */
    public
    function getResult()
    {
        return $this->result;
    }

    /**
     * @return mixed
     */
    public function getTipoOs()
    {
        return $this->tipo_os;
    }

    /**
     * @return mixed
     */
    public function getOsTecnicos()
    {
        return $this->os_tecnicos;
    }

    /**
     * @return mixed
     */
    public function getOsTecnicosTipo()
    {
        return $this->os_tecnicos_tipo;
    }

    /**
     * @return mixed
     */
    public function getTotalTipoOs()
    {
        return $this->total_tipo_os;
    }


}

