<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 14/12/2018
 * Time: 10:22
 */

require_once "sql/SqlFinanceiro.php";

class Financeiro extends SqlFinanceiro
{

    private $result;
    private $pagseguro;


    //CARREGA CR
    function carregarCR($dt_i, $dt_f)
    {

        //CR NOVO NAO TRAZ NA QUERY O ACUMULADO COMO CR, PRECISA SOMAR COM OS OUTROS CR RECEBIDOS POIS A DATA DO CR DE RETORNO
        // PRECISA SER ALTERADA PARA UM DIA UTIL , ANTERIOR A SUA DATA DE ORIGEM, MAS A DATA DO CR CAIXA NAO PRECISA SER ALTERADA.
        $array = array();
        $array_cr = array();
        $this->loadCR(); //tabela parou de ser alimentada dia 15/03/2019
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $dia = '01-01-' . date('Y', strtotime('-1 year')); // primeiro dia de cada ano
            $days = getdiasuteisCR($dia, date('d-m-Y'));

            foreach ($sql->fetchAll() as $item) {

                //ALTERA A DATA DE PAGTO DOS CR DIFERENTE DE CR-OUTROS COM DATA SUPERIOR A 14/03 (DATA DA MIGRACAO K 3.0)
                if (date('Y-m-d', strtotime($item['data'])) > '2019-03-14') {

                    if ($item['ponto_recebimento'] == 'CR - CAIXA') {

                        //ARMAZENA O CR OUTROS COM A DATA DO MK
                        array_push($array, ['dia' => date('d-m-Y', strtotime($item['data'])), 'valor' =>
                            (float)$item['total'], 'ponto_recebimento' => utf8_encode($item['ponto_recebimento'])]);

                    } else {

                        //PEGA A DATA DO MK DE CONCILIACAO E VOLTA 1 DIA UTIL E ARMAZENA A DATA COM OS VALORES

                        $day_temp = array_search(date('d-m-Y', strtotime($item['data'])), $days);

                        if($day_temp) {

                            $data = $days[$day_temp - 1];
                            array_push($array, ['dia' => date('d-m-Y', strtotime($data)), 'valor' => (float)$item['total'],
                                'ponto_recebimento' => utf8_encode($item['ponto_recebimento'])]);
                        }

                    }

                } else {

                    //ARMAZENA OS DADOS DE CR ANTERIORES A 14/03/2019
                    array_push($array, ['dia' => date('d-m-Y', strtotime($item['data'])),
                        'valor' => (float)$item['total'], 'ponto_recebimento' => utf8_encode($item['ponto_recebimento'])]);

                }
            }

            // VARRE O ARRAY E FILTRA POR DATA
            foreach ($array as $item) {

                if (date('Y-m-d', strtotime($item['dia'])) >= date('Y-m-d', strtotime($dt_i)) &&
                    date('Y-m-d', strtotime($item['dia'])) <= date('Y-m-d', strtotime($dt_f))) {

                    array_push($array_cr, $item);

                }

            }

            asort($array_cr);

            //ARMAZENA O ARRAY
            $this->result = $array_cr;

        } else {

            $this->result = null;

        }

        //$this->Newcr($dt_f);

    }


// CR
    public
    function saldodia_CR($data)
    {

        if (!empty($this->getResult())) {


            foreach ($this->getResult() as $row) {

                if (($row['ponto_recebimento'] == 'CR') && date('d', strtotime($row['dia'])) == $data) {

                    return $row['valor'];

                }
            }

        }
    }

    // CR PIX
        public
        function saldodia_CR_Pix($data)
        {

            if (!empty($this->getResult())) {


                foreach ($this->getResult() as $row) {

                    if (($row['ponto_recebimento'] == 'CR - PIX') && date('d', strtotime($row['dia'])) == $data) {

                        return $row['valor'];

                    }
                }

            }
        }


    public
    function acumuladoCR()
    {

        $array = array();
        $array2 = array();


        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {


                if (date('Y-m-d', strtotime($row['dia'])) < '2019-03-14') {

                    if ($row['ponto_recebimento'] == 'CR' || $row['ponto_recebimento'] == 'CR - CAIXA') {

                        $array[] = $row['dia'];
                        $array2[] = $row['valor'];
                    }

                } else {

                    $array[] = $row['dia'];
                    $array2[] = $row['valor'];

                }


            }

            $array = array_unique($array);
            $array = [count($array), array_sum($array2)];

            return $array;

        }
    }

// CR CARTAO
    public
    function saldodia_Cartao($data)
    {

        if (!empty($this->getResult())) {

            foreach ($this->getResult() as $row) {

                if ($row['ponto_recebimento'] == 'CR - CARTAO' && date('d', strtotime($row['dia'])) == $data) {

                    return $row['valor'];

                }

            }
        }
    }

//CR PAGSEGURO
    public
    function saldodia_Pagseguro($data)
    {

        if (!empty($this->getResult())) {

            foreach ($this->getResult() as $row) {

                if ($row['ponto_recebimento'] == 'CR - PAGSEGURO' && date('d', strtotime($row['dia'])) == $data) {

                    return $row['valor'];
                }
            }
        }
    }

// CR OUTROS
    public
    function saldodia_NaoIdentificados($data)
    {


        if (!empty($this->getResult())) {

            foreach ($this->getResult() as $row) {

                if (($row['ponto_recebimento'] == 'CR - NAOIDENTIFICADO')
                    && date('d', strtotime($row['dia'])) == $data) {

                    return $row['valor'];
                }
            }
        }
    }

    // CR CAIXA
    public
    function saldodia_Caixa($data)
    {


        if (!empty($this->getResult())) {

            foreach ($this->getResult() as $row) {

                if (($row['ponto_recebimento'] == 'CR - CAIXA')
                    && date('d', strtotime($row['dia'])) == $data) {

                    return $row['valor'];
                }
            }
        }
    }

//AGRUPA AS DATAS E SOMA OS VALORES DO CR
    public
    function agrupaCR()
    {

        $array = array();
        $array_new = array();
        $array_value = array();
        $array_date = array();

        //varre o array de CR
        foreach ($this->getResult() as $item) {

            //procura por CR e soma com o CR CAIXA


            if (date('Y-m-d', strtotime($item['dia'])) < '2019-03-14') {

                if ($item['ponto_recebimento'] == 'CR' || $item['ponto_recebimento'] == 'CR - CAIXA') {

                    array_push($array, ['dia' => date('d', strtotime($item['dia'])),
                        'valor' => (float)$item['valor']]);
                }

            } else {

                array_push($array, ['dia' => date('d', strtotime($item['dia'])),
                    'valor' => (float)$item['valor']]);

            }


        }
        //agrupa as datas duplicadas e soma o valor
        foreach ($array as $key => $value) {


            $array_date[$value['dia']][] = $value['valor'];

            foreach ($array_date as $keyP => $valueP) {
                $array_value[$keyP] = array_sum($array_date[$keyP]);


            }
        }

        //monta um novo array
        foreach ($array_value as $item => $value) {

            array_push($array_new, ['dia' => $item, 'valor' => (float)$value]);

        }

        return $array_new;
    }


    public
    function agrupaCRmes()
    {

        $array = array();
        $array_new = array();
        $array_value = array();
        $array_date = array();
        $array_cr = array();

        //varre o array de CR
        foreach ($this->getResult() as $item) {

            //procura por CR e soma com o CR CAIXA


            if (date('Y-m-d', strtotime($item['dia'])) < '2019-03-14') {

                if ($item['ponto_recebimento'] == 'CR' || $item['ponto_recebimento'] == 'CR - CAIXA') {

                    array_push($array, ['mes' => date('Y-m', strtotime($item['dia'])),
                        'valor' => (float)$item['valor']]);
                }

            } else {

                array_push($array, ['mes' => date('Y-m', strtotime($item['dia'])),
                    'valor' => (float)$item['valor']]);

            }


        }

        //var_dump($array);
        // usort($array);
        //agrupa as datas duplicadas e soma o valor
        foreach ($array as $key => $value) {


            $array_date[$value['mes']][] = $value['valor'];

            foreach ($array_date as $keyP => $valueP) {
                $array_value[$keyP] = array_sum($array_date[$keyP]);


            }
        }

        //monta um novo array
        foreach ($array_value as $item => $value) {

            array_push($array_new, ['mes' => $item, 'valor' => (float)$value]);

        }


        uasort($array_new, function ($a, $b) {


            return date('Y-m', strtotime($a['mes'])) > date('Y-m', strtotime($b['mes']));

        });

        $array_new = array_values($array_new);

        foreach ($array_new as $item) {

            array_push($array_cr, ['mes' => substr(exibe_mes($item['mes']), 0, 3), 'valor' => $item['valor']]);

        }

        return json_encode($array_cr);

    }


    /**
     * @return mixed
     */
    public
    function getResult()
    {
        return $this->result;
    }


    /**
     * @return mixed
     */
    public
    function getPagseguro()
    {
        return $this->pagseguro;
    }


}
