<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 03/08/2018
 * Time: 12:00
 */
require_once "sql/SqlConfig.php";

class GrupoAcesso extends SqlConfig
{

    private $nivelAcesso;


    function __construct()
    {

        parent::__construct();
        $this->grupoAcesso();

    }

   private function grupoAcesso()
    {
        $this->carregar_all_GruposAcesso();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->nivelAcesso = $sql->fetchAll();

        } else {
            echo "Error function nivelAcesso";
        }

    }

    public function addGrupo($nome, $data)
    {

        $this->buscar_grupoAcesso();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('nome', $nome);
        $sql->execute();

        if ($sql->rowCount() > 0) {
            return '3';
        } else {
            $this->inserir_GrupoAcesso();
            $sql = $this->getPdo()->prepare($this->getSql());
            $sql->bindValue('nome', $nome);
            $sql->bindValue('data_cadastro', $data);
            $sql->execute();

            if ($sql->rowCount() > 0) {

                return '0';
            } else {

                return '1';
            }
        }
    }

    public function editGrupo($id, $nome, $data_alteracao)
    {
        $this->buscar_grupoAcesso();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('nome', $nome);
        $sql->execute();

        if ($sql->rowCount() > 0) {
            return '3';
        } else {

            $this->editar_GrupoAcesso();
            $sql = $this->getPdo()->prepare($this->getSql());
            $sql->bindValue('id', $id);
            $sql->bindValue('nome', $nome);
            $sql->bindValue('data_modificado', $data_alteracao);
            $sql->execute();

            if ($sql->rowCount() > 0) {

                return '0';

            } else {

                return '1';

            }
        }
    }


    public function deleteGrupo($id)
    {
        $this->deletar_GrupoAcesso();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('id', $id);
        $sql->execute();

        if ($sql->rowCount() > 0) {
            return '0';
        } else {
            return '1';
        }

    }

    public function getGrupos()
    {

        return $this->nivelAcesso;
    }
}