<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 17/12/2018
 * Time: 12:17
 */

require_once "sql/SqlISP.php";

class ISP extends SqlISP
{

    private $result;
    private $dia;
    private $acumulado;
    private $atraso;
    private $mes;
    private $total;


    private function carregarFaturamento($data_i, $data_f)
    {
        $this->resetvalue();
        $this->loadfaturamento();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue('data_i', $data_i);
        $sql->bindValue('data_f', $data_f);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result = $sql->fetchAll();
            $this->dia();
            $this->acumulado();
            $this->atraso();
            $this->mes();
            $this->total();

        } else {

            $this->result = null;
            $this->dia = null;
            $this->acumulado = null;
            $this->atraso = null;
            $this->mes = null;
            $this->total = null;
        }

    }

    function faturamento($data_i, $data_f){

        if (strtotime($data_f) <= strtotime('28-02-2021')) {

            if (strtotime($data_f) <= strtotime('16-02-2021')) {

                $this->carregarFaturamento($data_i, $data_f);

            }

            if (strtotime($data_f) > strtotime('16-02-2021') && strtotime($data_f) <= strtotime('28-02-2021')) {

                $this->carregarFaturamento($data_i, '16-02-2021');
                $this->carregarFaturamento2('17-02-2021', $data_f);
            }
        }

        if (strtotime($data_f) > strtotime('28-02-2021')) {

            $this->resetvalue();
            $this->carregarFaturamento2($data_i, $data_f);
        }

    }


    private function carregarFaturamento2($data_i, $data_f)
    {
        $this->loadfaturamento_dt_efetivacao();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue('data_i', $data_i);
        $sql->bindValue('data_f', $data_f);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            //pega o faturamento antigo se houver
            $result_old = $this->getResult();
            ///

            $this->result = $sql->fetchAll();
            if(!empty($result_old)) {
                $this->result = array_merge($result_old, $this->result);
            }
            $this->dia();
            $this->acumulado();
            $this->atraso();
            $this->mes();
            $this->total();

        } else {

            $this->result = null;
            $this->dia = null;
            $this->acumulado = null;
            $this->atraso = null;
            $this->mes = null;
            $this->total = null;
        }

    }

    function carregarfaturamento_Dia($dia, $tipo)
    {

        $this->resetvalue();
        $array = array();
        $this->loadfaturamento_Dia();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue('data_i', $dia);
        $sql->bindValue('data_f', $dia);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $row) {

                if ($row['pagto'] == strtoupper($tipo)) {


                    array_push($array, $row);

                } else if ($tipo == 'Todos') {

                    array_push($array, $row);
                }

            }

            $this->result = $array;

        }

    }

    function carregarfaturamento_Dia2($dia, $tipo)
    {

        $this->resetvalue();
        $array = array();
        $this->loadfaturamento_Dia2();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue('data_i', $dia);
        $sql->bindValue('data_f', $dia);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $row) {

                if ($row['pagto'] == strtoupper($tipo)) {


                    array_push($array, $row);

                } else if ($tipo == 'Todos') {

                    array_push($array, $row);
                }

            }

            $this->result = $array;

        }

    }

    private function resetvalue(){


        $this->result = null;
        $this->mes = null;
        $this->atraso = null;
        $this->acumulado = null;
        $this->dia = null;


    }


    private function dia()
    {

        $dia = array();

        foreach ($this->result as $item) {

            array_push($dia, $item['data']);
        }

        $this->dia = $dia;

    }

    public function totaldiario($data)
    {

        if (!empty($this->getResult())) {

            foreach ($this->getResult() as $row) {

                if (date('j', strtotime($row['data'])) == $data) {

                    return ($row['mes'] + $row['atraso']);

                }

            }
        }

    }

    private function acumulado()
    {

        $acu = 0;
        $acumulado = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $item) {

                array_push($acumulado, $acu + ($item['atraso'] + $item['mes']));
                $acu = ($acu + ($item['atraso'] + $item['mes']));
            }

            $this->acumulado = $acumulado;
        }
    }

    private function atraso()
    {

        $atraso = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                array_push($atraso, $row['atraso']);

            }

            $this->atraso = $atraso;
        }
    }

    private function mes()
    {

        $no_mes = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                array_push($no_mes, $row['mes']);

            }

            $this->mes = $no_mes;
        }

    }

    private function total()
    {

        $soma = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                array_push($soma, $row['mes'] + $row['atraso']);

            }

            $this->total = $soma;
        }
    }

    /**
     * @return mixed
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * @return mixed
     */
    public function getDia()
    {
        return $this->dia;
    }

    /**
     * @return mixed
     */
    public function getAcumulado()
    {
        return $this->acumulado;
    }

    /**
     * @return mixed
     */
    public function getAtraso()
    {
        return $this->atraso;
    }

    /**
     * @return mixed
     */
    public function getMes()
    {
        return $this->mes;
    }

    /**
     * @return mixed
     */
    public function getTotal()
    {
        return $this->total;
    }


}
