<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 16/01/2019
 * Time: 10:26
 */
include_once "sql/SqlMaps.php";

class Maps extends SqlMaps
{

    private $lat;
    private $lng;
    private $allMarkers;
    private $allFiber;


    public function carregaclientes_Fibra()
    {

        $arrayFiber = array();
        $this->load_All_Clientes();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();
        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $row) {

                if ((strstr(unidade_financeira($row['tipo']), 'Fibra Residencial') ||
                    strstr(unidade_financeira($row['tipo']), 'Fibra Comercial') ||
                    strstr(unidade_financeira($row['tipo']), 'Fibra LINK IP ISP') ||
                    strstr(unidade_financeira($row['tipo']), 'Fibra Empresarial'))) {

                    array_push($arrayFiber, $row);


                } else {

                    $this->allFiber = null;
                }
            }
            $this->allFiber = $arrayFiber;
        }
    }

    public function verificaDados()
    {
        $this->allMarkers = null;
        $array_Reports = array();
        $array_MK = array();
        $novosMarkers = array();
        $allMarkers = array();

        $this->getALL_Conexao_Markers();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $row) {
                // armazena todas as conexoes da tabela markers do reports no array_Reports
                array_push($array_Reports, $row['codconexao']);
                array_push($allMarkers, $row);

            }

            // Carrega todos os Markers do BD
            $this->allMarkers = $allMarkers;

            foreach ($this->allFiber as $row) {
                // armazena todas as conexoes dos clientes residenciais fibra nao bloqueados do BD MK no array_MK

                array_push($array_MK, $row['codconexao']);
            }

            // armazena quantidade de registros dos clientes MK
            $conexoesMK = count($array_MK);

            //varre todas as posiçoes do array mk
            for ($i = 0; $i < $conexoesMK; $i++) {

                // procura a conexao no BD markers
                $busca = array_search($array_MK[$i], $array_Reports);


                // condição
                if (!is_numeric($busca)) {

                    // SE NÃO ENCONTRAR E ADICIONADO A CONEXAO NO ARRAY DE NOVOS MARKERS
                    array_push($novosMarkers, $array_MK[$i]);

                }
            }

            // ENVIA OS NOVOS MARKERS PARA ADICIONAR NA TABELA DE MARKERS
            !empty($novosMarkers) && $this->inserirDados($novosMarkers);
            $this->removerBloqueados($array_Reports, $array_MK);
            //$this->atualizaMarkers();


        }
    }


    private function removerBloqueados($arrayReports, $arrayMK)
    {

        // Armazena quantidade de registros do BD markers

        $arrayDelete = array();

        $conexoesReports = count($arrayReports);


        //REMOVE OS CLIENTES BLOQUEADOS
        for ($i = 0; $i < $conexoesReports; $i++) {

            // procura a conexao no array MK
            $busca = array_search($arrayReports[$i], $arrayMK);


            // condição
            if (!is_numeric($busca)) {
                // se nao existir chama a função remover e envia o codigo da conexao

                array_push($arrayDelete, $arrayReports[$i]);

            }
        }

        if (!empty($arrayDelete)) {
           $this->removeDados($arrayDelete);

        }

    }

    private function atualizaMarkers()
    {


        var_dump(count($this->allMarkers));
        var_dump(count($this->allFiber));


        /*
        $this->get_Conexao_Markers();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('conexao', $conexao);
        $sql->execute();
        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $row_a) {

                $rua = $row_a['address'];
                $bairro = $row_a['bairro'];
                $number = $row_a['number'];

            }

            $this->load_Cliente();
            $sql2 = $this->getPdomk()->prepare($this->getSql());
            $sql2->bindValue('conexao', $conexao);
            $sql2->execute();

            if ($sql2->rowCount() > 0) {

                foreach ($sql2->fetchAll() as $row) {

                    if ($rua <> utf8_encode($row['endereco']) || $bairro <> utf8_encode($row['bairro']) || $number <> $row['numero']) {

                        $this->delete_Conexao();
                        $sql = $this->getPdo()->prepare($this->getSql());
                        $sql->bindValue('conexao', $conexao);
                        $sql->execute();
                        $this->inserirDados($conexao);
                    }
                }

            } else {

                echo "Problema para buscar cliente com codconexao no BD do mk";
            }

        } else {

            echo "Erro no atualizar dados";
        }
        */

    }

    private function inserirDados($array)
    {

        $erro = array();
        $lat = null;
        $lng = null;
        $tipo = 'fibra';


        // BUSCA AS INFORMAÇOES DO NOVO CLIENTE NO ARRAY DE FIBRA E ARMAZENA NO BD
        foreach ($array as $row) {

             array_filter($this->allFiber, function ($rows) use ($row, $lat, $erro, $lng, $tipo) {

                 if ($rows['codconexao'] == $row) {

                     //VERIFICA SE A LATITUDE E LONGITUDE EXISTE NA TABELA DE ENDEREÇO DO REPORTS
                     if ($this->verificaLogradouro($rows['endereco'], $rows['bairro'], $rows['cidade'],
                         $rows['nomeestado'], $rows['siglaestado'])) {

                         $lat = $this->lat;
                         $lng = $this->lng;

                     } else {

                         // SE NAO EXISTE NO REPORTS, BUSCA LATITUE E LONGITUDE DO ENDEREÇO NO GOOGLE
                         $address = personalizaurl(utf8_encode($rows['endereco']));
                         $numero = $rows['numero'];
                         $cidade = personalizaurl(utf8_encode($rows['cidade']));
                         $estado = personalizaurl(utf8_encode($rows['nomeestado']));
                         $bairro = personalizaurl(utf8_encode($rows['bairro']));
                         $uf = personalizaurl($rows['siglaestado']);
                         $url = $address .'+'. $numero . ',' . $cidade . ',' .$uf;
                         $data = $this->apiGoogle($url);


                         // VERIFICA SE O RESULTADO ENCONTRADO NAO FOI EXATO
                         if(!empty($data['results'][0]['partial_match'])){

                         // TENTA UMA NOVA BUSCA APENAS PELO NOME DA RUA, BAIRRO, CIDADE E ESTADO, SEM O NUMERO DO LOGRADOURO
                         $url = $address . ',' . $bairro . ',' . $numero . ',' . $cidade . ',' .$uf;
                         $data = $this->apiGoogle($url);
                         }

                         if (empty($data['results'][0])) {

                             $erro[] = $address;
                             $lat = 0;
                             $lng = 0;

                         } else {

                             $lat = ($data['results'][0]['geometry']['location']['lat']);
                             $lng = ($data['results'][0]['geometry']['location']['lng']);

                         }

                     }
                     // INSERE NA TABELA MARKERS DO REPORTS A NOVA CONEXAO
                     $this->insert_markers();
                     $sql2 = $this->getPdo()->prepare($this->getSql());
                     $sql2->bindValue('name', utf8_encode($rows['cliente']));
                     $sql2->bindValue('address', utf8_encode($rows['endereco']));
                     $sql2->bindValue('bairro', utf8_encode($rows['bairro']));
                     $sql2->bindValue('lat', $lat);
                     $sql2->bindValue('lng', $lng);
                     $sql2->bindValue('type', $tipo);
                     $sql2->bindValue('codcli', $rows['codpessoa']);
                     $sql2->bindValue('codconexao', $rows['codconexao']);
                     $sql2->bindValue('number', $rows['numero']);
                     $sql2->bindValue('cidade', mb_strtoupper(utf8_encode($rows['cidade'])));
                     $sql2->bindValue('estado', strtoupper(utf8_encode($rows['nomeestado'])));
                     $sql2->bindValue('uf', $rows['siglaestado']);
                     $sql2->execute();

                     echo "<p>Novo cliente: " . utf8_encode($rows['cliente']) . "</p>";
                 }
             });

        }

    }


    private
    function apiGoogle($url)
    {

        $key = 'AIzaSyCqSZgP3rbKOa8c9u3S-933EP0fdTHAyrg';

        $arrContextOptions = array(
            "ssl" => array(
                "verify_peer" => false,
                "verify_peer_name" => false,
            ),
        );

        $url = "https://maps.googleapis.com/maps/api/geocode/json?address=$url&key=$key";
        $json = file_get_contents($url, false, stream_context_create($arrContextOptions));
        return json_decode($json, TRUE);

    }

    private
    function verificaLogradouro($logradouro, $bairro, $cidade)
    {
        $logradouro = utf8_encode($logradouro);
        $bairro = utf8_encode($bairro);
        $cidade = utf8_encode($cidade);
        $this->load_address_fibra();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('logradouro', $logradouro);
        $sql->bindValue('bairro', $bairro);
        $sql->bindValue('cidade', $cidade);
        $sql->execute();
        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $row) {


                $this->lat = $row['lat'];
                $this->lng = $row['lng'];

            }
            return true;

        } else {
            return false;
        }
    }

    private
    function removeDados($array)
    {


        $arrayString = implode(",", $array);
        $this->delete_markers_conexao($arrayString);
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            echo "<p>" . count($array) . " conexões foram removidas: bloqueada ou cancelada</p>";


        } else {

            echo "Problema no sql ou na função removeDados";
        }

    }


    /**
     * @return mixed
     */
    public
    function getArray()
    {
        return $this->allFiber;
    }


}

