<?php
/**
 * Created by PhpStorm.
 * User: suporte
 * Date: 09/01/2019
 * Time: 10:05
 */

require_once "sql/SqlMaps.php";

class Markers extends SqlMaps
{

    private $array;
    private $logradouro;
    private $cidade;
    private $bairro;
    private $latitude;
    private $longitude;


    function loadmarkers()
    {
        $this->load_markers();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->execute();
        if ($sql->rowCount() > 0) {

            $this->array = $sql->fetchAll();

        } else {

            echo "Erro function loadaddress";
        }
    }


    function loadedit($id)
    {

        $this->load_edit_markers($id);
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->array = $sql->fetchAll();
        } else {

            $this->array = null;
        }
    }


    function salvar_edit($id)
    {

        $this->update_markers();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('lat', $this->getLatitude());
        $sql->bindValue('lng', $this->getLongitude());
        $sql->bindValue('id', $id);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            return true;

        } else {

            return false;
        }

    }

    function loaddelete($id)
    {
        $this->load_edit_markers();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('id', $id);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            return true;
        } else {

            return false;
        }
    }

    function del_markers($id)
    {
        $this->delete_markers($id);
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            return true;
        } else {

            return false;
        }
    }

    /**
         * @return mixed
         */
    public function getArray()
{
    return $this->array;
}

    /**
     * @return mixed
     */
    public function getLogradouro()
    {
        return $this->logradouro;
    }

    /**
     * @param mixed $logradouro
     */
    public function setLogradouro($logradouro)
    {
        $this->logradouro = $logradouro;
    }

    /**
     * @return mixed
     */
    public function getCidade()
    {
        return $this->cidade;
    }

    /**
     * @param mixed $cidade
     */
    public function setCidade($cidade)
    {
        $this->cidade = $cidade;
    }

    /**
     * @return mixed
     */
    public function getBairro()
    {
        return $this->bairro;
    }

    /**
     * @param mixed $bairro
     */
    public function setBairro($bairro)
    {
        $this->bairro = $bairro;
    }

    /**
     * @return mixed
     */
    public function getLatitude()
    {
        return $this->latitude;
    }

    /**
     * @param mixed $latitude
     */
    public function setLatitude($latitude)
    {
        $this->latitude = $latitude;
    }

    /**
     * @return mixed
     */
    public function getLongitude()
    {
        return $this->longitude;
    }

    /**
     * @param mixed $longitude
     */
    public function setLongitude($longitude)
    {
        $this->longitude = $longitude;
    }



}
