<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 01/08/2018
 * Time: 14:10
 */

include_once "sql/SqlConfig.php";

class Menus extends SqlConfig
{

    private $menu;
    private $nome_menu;
    private $url_menu;
    private $alias_menu;
    private $menuconfig_menu;
    private $icone_menu;
    private $page_menu;


    public function __construct()
    {

        parent::__construct();
        $this->menu();

    }

    //CARREGA OS MENUS E SUAS PÁGINAS
    public function Menu()
    {
        $this->carregar_all_Menus();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->menu = $sql->fetchAll();

        } else {

            $this->menu = $sql->errorInfo();
        }
    }

    public function editarMenu($id)
    {

        $this->carregar_menu();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('id', $id);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->menu = $sql->fetchAll();
        } else {

            return '1';
        }

    }

    public function addMenu()
    {


        $this->submenu = 'N';
        //Insere menu na tabela de Menu
        $this->inserir_menu();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->execute(array(
            $this->nome_menu,
            $this->url_menu,
            $this->icone_menu,
            $this->alias_menu,
            $this->menuconfig_menu,
            $this->page_menu,
        ));

        if ($sql->rowCount() > 0) {

            $last_id = $this->getPdo()->lastInsertId();
            //insere o administrador na tabela de permissao do menu
            $this->inserir_permissao_menu();
            $sql2 = $this->getPdo()->prepare($this->getSql());
            $sql2->execute(array($last_id,
                'true',
                '1'));

            if ($sql2->rowCount() > 0) {
                // insere a pagina do menu
                $this->inserir_page_menu();
                $sql2 = $this->getPdo()->prepare($this->getSql());
                $sql2->execute(array(
                    $this->page_menu,
                    $last_id
                ));
            }

            if ($sql2->rowCount() > 0) {

                $last_id = $this->getPdo()->lastInsertId();
                //insere o administrador na tabela de permissao da pagina do menu
                $this->inserir_permissao_page();
                $sql2 = $this->getPdo()->prepare($this->getSql());
                $sql2->execute(array($last_id, '1', 'true'));
            }
            return '0';

        } else {

            return '1';
        }
    }

    public function salvarMenu($id)
    {
        $this->updateMenu();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->execute(array(
            $this->nome_menu,
            $this->url_menu,
            $this->icone_menu,
            $this->alias_menu,
            $this->menuconfig_menu,
            $this->page_menu,
            $id));

        if ($sql->rowCount() > 0) {


            $this->update_page_menu();
            $sql2 = $this->getPdo()->prepare($this->getSql());
            $sql2->execute(array(
                $this->page_menu,
                $id));

            return '0';

        } else {

            return '1';
        }
    }

    public function deleteMenu($id)
    {
        $this->verificasubmenu();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('menu', $id);
        $sql->execute();
        if(!($sql->rowCount() > 0)) {
            $this->deletar_menu();
            $sql = $this->getPdo()->prepare($this->getSql());
            $sql->bindValue('id', $id);
            $sql->execute();

            if ($sql->rowCount() > 0) {

                return '0';

            } else {

                return '1';
            }

        }else{

            return '1';
        }
    }

    public function setNome($n)
    {

        $this->nome_menu = $n;
    }

    public function setUrl($u)
    {

        $this->url_menu = $u;
    }

    public function setIcone($i)
    {

        $this->icone_menu = $i;
    }

    public function setAlias($a)
    {

        $this->alias_menu = $a;
    }

    public function setMenuconfig($mc)
    {

        $this->menuconfig_menu = $mc;
    }

    public function setPagina($p)
    {

        $this->page_menu = $p;
    }

    public function getMenu()
    {

        return $this->menu;
    }

}



