<?php
/**
 * Created by PhpStorm.
 * User: suporte
 * Date: 19/10/2018
 * Time: 15:32
 */
require_once "sql/SqlNotificacoesMK.php";

class NotificacoesMK extends SqlNotificacoesMK
{

    private $result;
    private $notificacoes;


    public function carregarNotificacoes($grupo)
    {

        $this->loadNotificacoes();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result = $sql->fetchAll();
            $this->result = $this->notificacoes($grupo);

        }

    }

    private function notificacoes($grupo)
    {

        $array = array();
        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if (strpos($row['grupo'], $grupo) !== false) {

                    array_push($array, $row);


                }

            }

        }
        return $array;

    }

    function loadUnidadeFinanceira()
{

    $array = array();

    if (!empty($this->getResult())) {
        foreach ($this->getResult() as $row) {

            if ($row['tipo'] == 'Sem UF Contrato') {

                array_push($array, $row);
            }

        }
    }

    $this->notificacoes = $array;


}

    function loadErroGrupoSla()
    {

        $array = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if ($row['tipo'] == 'Grupo/SLA Pendente') {

                    array_push($array, $row);
                }

            }
        }

        $this->notificacoes = $array;


    }

    function loadErroBairroCondominio()
    {

        $array = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if ($row['tipo'] == 'Erro Bairro') {

                    array_push($array, $row);
                }

            }
        }

        $this->notificacoes = $array;


    }

    function loadErroRegras()
    {

        $array = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if ($row['tipo'] == 'Erro de Regra Bloqueio') {

                    array_push($array, $row);
                }

            }
        }

        $this->notificacoes = $array;


    }

    function loadTecnicoIncorreto()
    {

        $array = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if ($row['tipo'] == 'Tecnico Incorreto') {

                    array_push($array, $row);
                }

            }
        }

        $this->notificacoes = $array;


    }

    function loadConexaoAssociada()
    {


        $array = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if ($row['tipo'] == 'Sem Username OS') {


                    array_push($array, $row);

                }

            }
        }

        $this->notificacoes = $array;


    }

    function loadClassificacaoEncerramento()
    {


        $array = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if ($row['tipo'] == 'Encerramento Incorreto') {


                    array_push($array, $row);

                }

            }
        }

        $this->notificacoes = $array;


    }

    function loadUF_Incorreta()
    {


        $array = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if ($row['tipo'] == 'UF Incorreta') {


                    array_push($array, $row);

                }

            }
        }

        $this->notificacoes = $array;


    }

    function loadOS_Pendente()
    {


        $array = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if ($row['tipo'] == 'OS Pendente') {


                    array_push($array, $row);

                }

            }
        }

        $this->notificacoes = $array;


    }

    function loadTickPendente()
    {


        $array = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if ($row['tipo'] == 'Ticket Pendente') {


                    array_push($array, $row);

                }

            }
        }

        $this->notificacoes = $array;


    }

    function loadMetodoFat()
    {

        $array = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if ($row['tipo'] == 'Metodo Fat Errado') {


                    array_push($array, $row);

                }

            }
        }

        $this->notificacoes = $array;

    }

    function loadticketsAprimorar()
    {

        $ticket = null;

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if ($row['tipo'] == 'Ticket Aprimorar') {


                    $ticket = $row['codigo'];

                }

            }
        }

        $this->notificacoes = $ticket;

    }

    function loadcontratosemparcela()
    {

        $array = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if ($row['tipo'] == 'Contrato sem Parcela') {


                    array_push($array, $row);

                }

            }
        }

        $this->notificacoes = $array;

    }

    function loadinstalacaobloq()
    {

        $array = array();

        if (!empty($this->getResult())) {
            foreach ($this->getResult() as $row) {

                if ($row['tipo'] == 'Inst Bloqueada') {


                    array_push($array, $row);

                }

            }
        }

        $this->notificacoes = $array;

    }

    /**
     * @return mixed
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * @return mixed
     */
    public function getNotificacoes()
    {
        return $this->notificacoes;
    }


}
