<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 27/07/2018
 * Time: 09:45
 */

require_once "sql/ConexaoBD.class.php";

class Permissao extends BD
{

    private $status;
    private $menu;
    private $submenu;


    public function verificaPermissao($pg, $id_permissao)
    {


        $sql = "select p.status, pg.nome_page from permissao_page p inner join pages pg on pg.cod_page = p.cod_page 
                    where :page = pg.nome_page and :nivel_acesso = p.nivel_acesso_user";
        $sql = $this->getPdo()->prepare($sql);
        $sql->bindValue('page', $pg);
        $sql->bindValue('nivel_acesso', $id_permissao);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $row) {

                $this->status = $row['status'];

            };
        }

    }

    public function carregamenu($acesso)
    {

        $sql = "SELECT m.id_menu, m.nome, m.url, m.icon, m.alias, p.acesso, n.nome_nivel, m.menu_config, case when sub.id_submenu is null then 'N' else 'S' end as submenu
                      FROM menu m INNER JOIN permissao_menu p on m.id_menu = p.cod_menu
                                  LEFT JOIN sub_menu sub on m.id_menu = sub.cod_menu  
                                  INNER JOIN nivel_acessos n on p.nivel_acesso = n.id 
                                  where p.acesso = 'true' and p.nivel_acesso = :acesso
                                  GROUP by m.id_menu
                                  ORDER BY m.menu_config, m.id_menu";
        $sql = $this->getPdo()->prepare($sql);
        $sql->bindValue('acesso', $acesso);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->menu = $sql->fetchAll();
        }else{
            $this->menu = null;

        }

    }

    public function carregaSubmenu($menu, $acesso)
    {

        $sql = "SELECT s.nome, s.url, s.icon, s.alias, p.acesso, n.nome_nivel FROM menu m 
	INNER JOIN sub_menu s on m.id_menu = s.cod_menu
    INNER JOIN permissao_submenu p on p.cod_submenu = s.id_submenu
    INNER JOIN nivel_acessos n on p.nivel_acesso = n.id 
    where p.acesso = 'true' and s.cod_menu = :menu and n.id = :acesso
    ORDER BY s.alias";
        $sql = $this->getPdo()->prepare($sql);
        $sql->bindValue('menu', $menu);
        $sql->bindValue('acesso', $acesso);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->submenu = $sql->fetchAll();
        }else{

            $this->submenu = null;
        }

    }


    public function getPermissao()
    {

        return $this->status;
    }

    public function getMenu()
    {

        return $this->menu;
    }


    public function getSubmenu()
    {

        return $this->submenu;
    }


}