<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 19/02/2019
 * Time: 16:41
 */

require_once "sql/SQLPrevisao.php";

class Previsao extends SQLPrevisao
{

    private $result;
    private $result_projetos;
    private $previsaolista;


    function carregarPrevisaoRes()
    {

        $this->loadPrevisaoRes();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $item) {

                $this->result = $item['valor'];
            }

            $this->inserePrevisao('RESIDENCIAL', $this->result);

        } else {

            $this->result = null;
        }

    }

    function carregarPrevisaoProjeto($codprojeto_mk, $codprojeto)
    {

        $this->result_projetos = null;
        $this->loadPrevisaoProjeto($codprojeto_mk);
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $item) {

                $this->result_projetos = $item['valor'];
            }

            if(empty($this->result_projetos)){
                $this->result_projetos = 0;
            }

            $this->inserePrevisaoProjeto($codprojeto, $this->result_projetos);

        } else {

            $this->result_projetos = null;
        }

    }


    private function inserePrevisao($tipo, $valor)
    {

        $this->buscaPrevisao($tipo, exibe_mes(date('m')));

        if(empty($this->result)) {
            $this->insertPrevisao();
            $sql = $this->getPdo()->prepare($this->getSql());
            $sql->bindValue('valor', $valor);
            $sql->bindValue('mes', exibe_mes(date('m')));
            $sql->bindValue('ano', date('Y'));
            $sql->bindValue('tipo', $tipo);
            $sql->bindValue('datareg', date('Y-m-d'));
            $sql->execute();
        }

    }

    private function inserePrevisaoProjeto($codprojeto, $valor)
    {

        if(!is_numeric($this->buscaPrevisaoProjeto($codprojeto, exibe_mes(date('m'))))){
            $this->insertPrevisaoProjeto();
            $sql = $this->getPdo()->prepare($this->getSql());
            $sql->bindValue('valor', $valor);
            $sql->bindValue('mes', exibe_mes(date('m')));
            $sql->bindValue('projeto', $codprojeto);
            $sql->execute();
        }

    }

    function buscaPrevisao($tipo, $mes, $ano = '2023')
    {

        $this->searchPrevisao();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('tipo', $tipo);
        $sql->bindValue('mes', $mes);
        $sql->bindValue('ano', $ano);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $item) {

                $this->result = $item['valor'];
            }
        } else {
            $this->result = null;
        }

    }

    function buscaPrevisaoProjeto($codprojeto, $mes)
    {

        $this->searchPrevisaoProjeto();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('projeto', $codprojeto);
        $sql->bindValue('mes', $mes);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $item) {

                return $this->result_projetos = $item['valor'];

            }

        } else {


            return $this->result_projetos = null;
        }

    }

    function carregarPrevisaoIsp()
    {

        $this->previsaolista = null;
        $array = array();
        $this->loadPrevisaoIsp();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->previsaolista = $sql->fetchAll();

            foreach ($this->previsaolista as $item) {

                array_push($array, $item['previsao']);
            }

            $this->result = array_sum($array);

            $this->inserePrevisao('ISP', $this->result);

        } else {

            $this->result = null;
        }

    }

    function carregarPrevisaoCom()
    {

        $this->loadPrevisaoCom();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $item) {

                $this->result = $item['valor'];
            }

            $this->inserePrevisao('COMERCIAL', $this->result);

        } else {

            $this->result = null;
        }

    }

    function carregarPrevisaoEmp()
    {

        $this->previsaolista = null;
        $array = array();
        $this->loadPrevisaoEmp();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->previsaolista = $sql->fetchAll();

            foreach ($this->previsaolista as $item) {

                array_push($array, $item['previsao']);
            }

            $this->result = array_sum($array);
            $this->inserePrevisao('EMPRESARIAL', $this->result);

        } else {

            $this->result = null;
        }

    }


    /**
     * @return mixed
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * @return mixed
     */
    public function getResultProjetos()
    {
        return $this->result_projetos;
    }



    /**
     * @return mixed
     */
    public function getPrevisaolista()
    {
        return $this->previsaolista;
    }




}
