<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 17/12/2018
 * Time: 12:17
 */

require_once "sql/SqlProjetos.php";

class Projetos extends SqlProjetos
{

    private $result;
    private $totalcarteira;
    private $statusbloq;
    private $resultFaturamento;
    private $dia;
    private $acumulado;
    private $atraso;
    private $mes;
    private $total;
    private $carteiraAnual;
    private $projetos;
    private $faturamentoanual;
    private $faturamentototal;
    private $data_projeto;
    private $markers;
    private $tipo_os;
    private $tipo_os_null;
    private $cidades_projeto;

    /**
     * Projetos constructor.
     * @param $result
     */
    public function __construct($codprojeto)
    {

        parent::__construct();
        $this->loadProjeto($codprojeto);
    }


    private function loadProjeto($codprojeto)
    {

        //carrega todos os projetos mk de um projeto reports
        $codprojeto = $this->loadallprojetos_mk($codprojeto);
        $this->loadCarteira($codprojeto);
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->result = $sql->fetchAll();
            $this->totalcarteira = $sql->rowCount();
            $this->loadmap();

        } else {

            $this->result = null;
            $this->totalcarteira = 0;
        }

    }

    private function loadmap()
    {


        $markers = array();
        $array_conexao = array();
        $array_compare = array();

        foreach ($this->getResult() as $item) {

            if ($item['bloqueado'] == 'N') {
                array_push($array_conexao, $item['codconexao']);
            }

        }

        $conexao = implode(',', $array_conexao);

        $this->loadmarkersBD($conexao);
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll(PDO::FETCH_ASSOC) as $item) {

                array_push($markers, $item);
                array_push($array_compare, $item['codconexao']);

            }

            $this->markers = $markers;
            $array_diff = array_diff($array_conexao, $array_compare);
            foreach ($array_diff as $row) {

                array_push($this->markers, ['name' => 'NAO LOCALIZADO CONEXAO: ' . $row,
                    'lat' => '-22.9' . $row, 'lng' => '-46.7' . $row]);

            }

            $this->markers = json_encode($this->markers);

        } else {

            $this->markers = null;
        }


    }


    //PEGA O CODIGO PROJETO REPORTS E BUSCA POR TODOS OS PROJETOS
    // EXISTENTES NA TABELA PROJETOS MAPS DO REPORTS E SALVA O CODIGO DESTE PROJETO
    // QUE É O CODIGO DO PROJETO NO MK PARA DEPOIS CARREGAR A
    // CARTEIRA TOTAL DE CLIENTE DESTES PROJETOS
    public function loadallprojetos_mk($codprojeto)
    {

        $newcodprojeto = array();
        $this->loadallProjetos_maps();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('projeto', $codprojeto);
        $sql->execute();
        foreach ($sql->fetchAll(pdo::FETCH_ASSOC) as $row) {
            array_push($newcodprojeto, $row['cod_projeto_mk']);
            $this->data_projeto = date('Y-m-d', strtotime($row['data_inicio']));
        }
        $codprojeto = implode(",", $newcodprojeto);
        return $codprojeto;
    }

    public function searchBase($codprojeto)
    {

        $this->searchcarteiraMes();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('mes', mb_strtoupper(exibe_mes(date('m')), 'UTF-8'));
        $sql->bindValue('projeto', $codprojeto);
        $sql->bindValue('ano', date('Y'));
        $sql->execute();

        if ($sql->rowCount() > 0) {


            foreach ($sql->fetchAll() as $item) {


                if ($item['total'] !== $this->totalcarteira) {

                    $this->updateBase($item['id'], $this->totalcarteira);

                }
            }

        } else {

            $this->insereBase(date('m'), $this->totalcarteira, $codprojeto);

        }

        $this->loadCarteiraAnualProjetos($codprojeto);

    }

    private function loadCarteiraAnualProjetos($codprojeto)
    {

        $array = array();
        $this->loadCarteiraAnual();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('projeto', $codprojeto);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $item) {

                if($item['ano'] == date('Y')) {
                    array_push($array, ['mes' => substr($item['mes'], 0, 3), 'total' =>
                        $item['total']]);
                }
            }

            $this->carteiraAnual = json_encode($array);

        } else {

            $this->carteiraAnual = null;
        }


    }

    private function insereBase($codmes, $total, $codprojeto)
    {

        $this->inserebaseProjeto();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('mes', $codmes);
        $sql->bindValue('total', $total);
        $sql->bindValue('projeto', $codprojeto);
        $sql->bindValue('ano', date('Y'));
        $sql->execute();

    }

    private function updateBase($id, $total)
    {

        $this->updateBaseProjeto();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('total', $total);
        $sql->bindValue('id', $id);
        $sql->execute();
    }

    public function carregarFaturamento($data_i, $data_f, $codprojeto)
    {

        $codprojeto = $this->loadallprojetos_mk($codprojeto);
        $this->loadfaturamentoProjeto($codprojeto, $this->data_projeto);
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue('data_i', $data_i);
        $sql->bindValue('data_f', $data_f);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->resultFaturamento = $sql->fetchAll();
            $this->dia();
            $this->acumulado();
            $this->atraso();
            $this->mes();
            $this->total();

        } else {

            $this->resultFaturamento = null;
            $this->mes = null;
            $this->atraso = null;
            $this->acumulado = null;
        }

    }

    public function carregarfaturamento_Dia($dia, $tipo, $codprojeto)
    {


        $this->resultFaturamento = null;
        $array = array();
        $codprojeto = $this->loadallprojetos_mk($codprojeto);
        $this->loadfaturamentoprojetoDia($codprojeto, $this->data_projeto);
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->bindValue('data_i', $dia);
        $sql->bindValue('data_f', $dia);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $row) {

                if ($row['pagto'] == strtoupper($tipo)) {


                    array_push($array, $row);

                } else if ($tipo == 'Todos') {

                    array_push($array, $row);
                }

            }

            $this->resultFaturamento = $array;

        } else {

            $this->resultFaturamento = $sql->errorInfo();

        }

    }

    private function dia()
    {

        $dia = array();

        foreach ($this->resultFaturamento as $item) {

            array_push($dia, $item['data']);
        }

        $this->dia = $dia;

    }

    private function acumulado()
    {

        $acu = 0;
        $acumulado = array();

        foreach ($this->resultFaturamento as $item) {

            array_push($acumulado, $acu + ($item['atraso'] + $item['mes']));
            $acu = ($acu + ($item['atraso'] + $item['mes']));
        }

        $this->acumulado = $acumulado;
    }

    private function atraso()
    {

        $atraso = array();

        foreach ($this->resultFaturamento as $row) {

            array_push($atraso, $row['atraso']);

        }

        $this->atraso = $atraso;
    }

    private function mes()
    {

        $no_mes = array();

        foreach ($this->resultFaturamento as $row) {

            array_push($no_mes, $row['mes']);

        }

        $this->mes = $no_mes;

    }

    private function total()
    {

        $soma = array();

        foreach ($this->resultFaturamento as $row) {

            array_push($soma, $row['mes'] + $row['atraso']);

        }

        $this->total = $soma;
    }

    public function statusBloqueio($status)
    {

        $array = array();

        if (!empty($this->getResult())) {

            foreach ($this->getResult() as $row) {

                if ($row['bloqueado'] == $status) {

                    array_push($array, $row);

                }

            }

            $this->statusbloq = $array;
        }


    }

    public function tipoOs($os)
    {

        $array = array();
        $arraynull = array();

        if (!empty($this->getResult())) {

            foreach ($this->getResult() as $row) {

                if (tipo_os($row['tipo_os']) === $os) {

                    array_push($array, $row);

                }

                if(empty($row['tipo_os'])){

                    array_push($arraynull, $row);
                }

            }

            $this->tipo_os = $array;
            $this->tipo_os_null = $arraynull;
        }

    }

    /**
     * @return mixed
     */
    public function getTipoOsNull()
    {
        return $this->tipo_os_null;
    }

    public function loadallProjetos($ece)
    {

        $array = array();
        $this->loadProjetos($ece);
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->projetos = $sql->fetchAll();
            foreach ($this->projetos as $row){

                array_push($array, $row['cidade'], SORT_STRING);
            }

            $this->cidades_projeto = array_unique($array);
             asort($this->cidades_projeto);

        } else {

            $this->projeto = null;
        }


    }

    public function buscaProjeto($codprojeto)
    {

        $this->buscaProjetoBD();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('projeto', $codprojeto);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->projetos = $sql->fetchAll();

        } else {

            $this->projetos = null;
        }

    }

    public function loadfaturamentoAnual($codprojeto)
    {

        $array = array();
        $codprojeto = $this->loadallprojetos_mk($codprojeto);
        $this->loadFaturamentoAnualBD($codprojeto, $this->data_projeto);
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $item) {

                array_push($array, ['mes' => exibe_mes($item['mes']),
                    'valor' => $item['valor_pago']]);
            }

            $this->faturamentoanual = json_encode($array); //soma o total geral recebido de todos os meses
        }

    }

    public function loadfaturamentoTotal($codprojeto)
    {

        $array = array();
        $arraytotal = array();
        $codprojeto = $this->loadallprojetos_mk($codprojeto);
        $this->loadFaturamentoTotalBD($codprojeto, $this->data_projeto);
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $item) {


                array_push($arraytotal, $item['valor_pago']);
            }

            $this->faturamentototal = array_sum($arraytotal); //soma o total recebido geral
        }

    }

    public function loadfaturamentoTotalTipo_os($codprojeto, $tipoos)
    {
        $codprojeto = $this->loadallprojetos_mk($codprojeto);
        $this->loadFaturamentoTotalTipo_osBD($codprojeto, $this->data_projeto);
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $item) {

                if(tipo_os($item['tipo_os']) === $tipoos) {

                    return $item['valor_pago'];
                }
            }
        }

    }

    /**
     * @return mixed
     */
    public function getFaturamentototal()
    {
        return $this->faturamentototal;
    }

    /**
     * @return mixed
     */
    public function getTipoOs()
    {
        return $this->tipo_os;
    }


    /**
     * @return mixed
     */
    public function getFaturamentoanual()
    {
        return $this->faturamentoanual;
    }


    /**
     * @return mixed
     */
    public function getProjetos()
    {
        return $this->projetos;
    }


    /**
     * @return mixed
     */
    public function getCarteiraAnual()
    {
        return $this->carteiraAnual;
    }


    /**
     * @return mixed
     */
    public function getStatusbloq()
    {
        return $this->statusbloq;
    }


    /**
     * @return mixed
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * @return mixed
     */
    public function getTotalcarteira()
    {
        return $this->totalcarteira;
    }

    /**
     * @return mixed
     */
    public function getResultFaturamento()
    {
        return $this->resultFaturamento;
    }

    /**
     * @return mixed
     */
    public function getDia()
    {
        return $this->dia;
    }

    /**
     * @return mixed
     */
    public function getAcumulado()
    {
        return $this->acumulado;
    }

    /**
     * @return mixed
     */
    public function getAtraso()
    {
        return $this->atraso;
    }

    /**
     * @return mixed
     */
    public function getMes()
    {
        return $this->mes;
    }

    /**
     * @return mixed
     */
    public function getTotal()
    {
        return $this->total;
    }

    /**
     * @return mixed
     */
    public function getMarkers()
    {
        return $this->markers;
    }

    /**
     * @return mixed
     */
    public function getCidadesProjeto()
    {
        return $this->cidades_projeto;
    }



}
