<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 17/08/2018
 * Time: 16:06
 */
include_once "sql/SqlConfig.php";

class Submenu extends SqlConfig
{

    private $submenu;
    private $nome_sub;
    private $url_sub;
    private $alias_sub;
    private $icone_sub;
    private $menupai;
    private $pageSub;


    public function __construct()
    {


        parent::__construct();
        $this->subMenu();
    }


    private function subMenu()
    {

        $this->carregar_all_Submenus();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->submenu = $sql->fetchAll();

        } else {

            $this->submenu = null;
        }
    }

    public function buscarSubmenu($id){

        $this->carregar_submenu();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('id', $id);
        $sql->execute();

        if($sql->rowCount() > 0){

            $this->submenu = $sql->fetchAll();
        }else{

            $this->submenu = null;
        }

    }

    public function inserir_sub($id_menu){

        $this->verificar_duplicidade_sub();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('nome', $this->getNomeSub());
        $sql->execute();

        if(!($sql->rowCount() > 0)){

            $this->inserir_submenu();
            $sql = $this->getPdo()->prepare($this->getSql());
            $sql->execute(array(
                $id_menu,
                $this->getNomeSub(),
                $this->getIconeSub(),
                $this->getUrlSub(),
                $this->getAliasSub(),
                $this->getPageSub(),
            ));

            if($sql->rowCount() > 0){

                $last_id = $this->getPdo()->lastInsertId();
                //insere o administrador na tabela de permissao do submenu
                $this->inserir_permissao_sub();
                $sql = $this->getPdo()->prepare($this->getSql());
                $sql->execute(array($last_id,
                    'true',
                    '1'));

                if ($sql->rowCount() > 0) {
                    // insere a pagina do menu
                    $this->inserir_page_sub();
                    $sql = $this->getPdo()->prepare($this->getSql());
                    $sql->execute(array(
                        $this->getPageSub(),
                        $last_id
                    ));
                }

                if ($sql->rowCount() > 0) {

                    $last_id = $this->getPdo()->lastInsertId();
                    //insere o administrador na tabela de permissao da pagina do submenu
                    $this->inserir_permissao_page();
                    $sql = $this->getPdo()->prepare($this->getSql());
                    $sql->execute(array($last_id, '1', 'true'));
                }

                return '0';

            } else {

                return '1';

            }
        }else{

           return '2';
        }

    }


    public function editar_sub($id_sub){

       $this->updateSubmenu();
       $sql = $this->getPdo()->prepare($this->getSql());
       $sql->execute(array(
          $this->getMenupai(),
          $this->getNomeSub(),
          $this->getIconeSub(),
          $this->getUrlSub(),
          $this->getAliasSub(),
          $this->getPageSub(),
          $id_sub
       ));

        if($sql->rowCount() > 0){
            $this->update_page_submenu();
            $sql2 = $this->getPdo()->prepare($this->getSql());
            $sql2->execute(array(
                $this->getPageSub(),
                $id_sub));

            return '0';

        } else {

            return '1';
        }

    }

    public function remover_sub($id_sub){

        $this->removerSubmenu();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('id', $id_sub);
        $sql->execute();

        if ($sql->rowCount() > 0){

            return true;

        }else{

            return false;
        }

    }

    /**
     * @return mixed
     */
    public function getNomeSub()
    {
        return $this->nome_sub;
    }

    /**
     * @param mixed $nome_sub
     */
    public function setNomeSub($nome_sub)
    {
        $this->nome_sub = $nome_sub;
    }

    /**
     * @return mixed
     */
    public function getUrlSub()
    {
        return $this->url_sub;
    }

    /**
     * @param mixed $url_sub
     */
    public function setUrlSub($url_sub)
    {
        $this->url_sub = $url_sub;
    }

    /**
     * @return mixed
     */
    public function getAliasSub()
    {
        return $this->alias_sub;
    }

    /**
     * @param mixed $alias_sub
     */
    public function setAliasSub($alias_sub)
    {
        $this->alias_sub = $alias_sub;
    }

    /**
     * @return mixed
     */
    public function getIconeSub()
    {
        return $this->icone_sub;
    }

    /**
     * @param mixed $icone_sub
     */
    public function setIconeSub($icone_sub)
    {
        $this->icone_sub = $icone_sub;
    }

    /**
     * @return mixed
     */
    public function getMenupai()
    {
        return $this->menupai;
    }

    /**
     * @param mixed $menupai
     */
    public function setMenupai($menupai)
    {
        $this->menupai = $menupai;
    }

    /**
     * @return mixed
     */
    public function getPageSub()
    {
        return $this->pageSub;
    }

    /**
     * @param mixed $pageSub
     */
    public function setPageSub($pageSub)
    {
        $this->pageSub = $pageSub;
    }



    /**
     * @return mixed
     */
    public function getSubmenu()
    {
        return $this->submenu;
    }
}
/*
    public function submenuIdMenu($id_menu)
    {

        $sql = "select * from sub_menu where cod_menu = :id";
        $sql = $this->getPdo()->prepare($sql);
        $sql->bindValue('id', $id_menu);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->submenu = $sql->fetchAll();

        } else {

            $this->submenu = null;
        }
    }

    public function submenuIdSub($id_sub)
    {

        $sql = "select * from sub_menu where id_submenu = :id";
        $sql = $this->getPdo()->prepare($sql);
        $sql->bindValue('id', $id_sub);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->submenu = $sql->fetchAll();

        } else {

            $this->submenu = null;
        }
    }

    public function salvar_edit_Sub($id_sub)
    {

        $sql = "update sub_menu set nome = ?, url = ?, icon = ?, alias = ? where id_submenu = ?";
        $sql = $this->getPdo()->prepare($sql);
        $sql->execute(array(
            $this->nome_sub,
            $this->url_sub,
            $this->icone_sub,
            $this->alias_sub,
            $id_sub));

        if ($sql->rowCount() > 0) {

            return '0';
        } else {
            return '1';
        }

    }

    public function addsubMenu_Menu($sub, $menu)
    {


        $sql = "UPDATE sub_menu set cod_menu = :menu where id_submenu = :sub";
        $sql = $this->getPdo()->prepare($sql);
        $sql->bindValue('menu', $menu);
        $sql->bindValue('sub', $sub);
        $sql->execute();

        if ($sql->rowCount() > 0) {


            $this->updatemenu($menu);
            return '0';

        } else {

            return '1';
        }

    }

    public function add_newSub($nome_sub, $id_menu)
    {

        $sql = "Select * from sub_menu where nome = :nome";
        $sql = $this->getPdo()->prepare($sql);
        $sql->bindValue('nome', $nome_sub);
        $sql->execute();
        if ($sql->rowCount() > 0) {

            return '2';

        } else {
            $sql = "INSERT INTO sub_menu set nome = ?, sub_page = ?";
            $sql = $this->getPdo()->prepare($sql);
            $sql->execute(array(
                $nome_sub,
                $nome_sub . '.php'
            ));

            if ($sql->rowCount() > 0) {

                $last_id = $this->getPdo()->lastInsertId();
                $sql = "INSERT INTO pages set nome_page = ?, page_cod_submenu = ?";
                $sql = $this->getPdo()->prepare($sql);
                $sql->execute(array(
                    $nome_sub . '.php',
                    $last_id
                ));

                if ($sql->rowCount() > 0) {

                    $last_id = $this->getPdo()->lastInsertId();
                    $sql = "SELECT nivel_acesso, acesso FROM permissao_menu where cod_menu = :idmenu";
                    $sql = $this->getPdo()->prepare($sql);
                    $sql->bindValue('idmenu', $id_menu);
                    $sql->execute();
                    if ($sql->rowCount() > 0) {

                        foreach ($sql->fetchAll() as $row) {

                            $sql2 = "INSERT INTO permissao_page set cod_page = ?, nivel_acesso_user = ?, status = ?";
                            $sql2 = $this->getPdo()->prepare($sql2);
                            $sql2->execute(array($last_id, $row['nivel_acesso'], $row['acesso']));

                        }
                    }

                }

                return '0';

            } else {

                return '1';
            }

        }
    }

    public function removeSub($id_sub, $id_menu)
    {

        if ($id_sub == 15) {

            return '2';

        }else{

            $sql = "DELETE sub, pg, psub from sub_menu sub inner join pages pg on sub.id_submenu = pg.page_cod_submenu
                             inner join permissao_page psub on psub.cod_page = pg.cod_page
                              where sub.id_submenu = :idsub";
            $sql = $this->getPdo()->prepare($sql);
            $sql->bindValue('idsub', $id_sub);
            $sql->execute();

            if ($sql->rowCount() > 0) {

                $this->updatemenu($id_menu);

                return '0';

            } else {
                return '1';
            }
        }
    }

    private
    function updatemenu($id_menu)
    {

        $sql = "select * from menu m inner join sub_menu sub on m.id_menu = sub.cod_menu where m.id_menu = :id";
        $sql = $this->getPdo()->prepare($sql);
        $sql->bindValue('id', $id_menu);
        $sql->execute();

        if ($sql->rowCount() == 0) {

            $sql2 = "UPDATE menu set sub_menu = 'N' where id_menu = :id";
            $sql2 = $this->getPdo()->prepare($sql2);
            $sql2->bindValue('id', $id_menu);
            $sql2->execute();

        } else {

            $sql2 = "UPDATE menu set sub_menu = 'S' where id_menu = :id";
            $sql2 = $this->getPdo()->prepare($sql2);
            $sql2->bindValue('id', $id_menu);
            $sql2->execute();

        }

    }


    public
    function getSubmenu()
    {

        return $this->submenu;
    }
}
*/
