<?php

require_once "sql/SqlTags.php";

class Tags extends SqlTags
{
    private $result;
    private $tagclient;


    public function __construct()
    {

        parent::__construct();
        $this->loadTags();
    }

    private function loadTags()
    {
        $this->loadSqlTags();
        $sql = $this->getPdomk()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {
            $this->result = $sql->fetchAll();
        }
    }

    public function loadTagsClient($codclient)
    {

        $array = array();

        foreach ($this->result as $row) {

            if ($row['cd_cliente'] === $codclient) {

                array_push($array, $row['nome_tag']);

            }

        }

        $this->tagclient = $array;

    }

    /**
     * @return mixed
     */
    public function getTagclient()
    {
        return $this->tagclient;
    }

    /**
     * @return mixed
     */
    public function getResult()
    {
        return $this->result;
    }


}
