<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 18/09/2018
 * Time: 15:47
 */
require_once "sql/SqlConfig.php";
require_once "../interfaces/Crud.php";

class Usuarios extends SqlConfig implements Crud
{

    private $array;
    private $nome;
    private $email;
    private $login;
    private $password;
    private $cargo;
    private $grupo;
    private $departamento;
    private $cidade;


    /**
     * Usuarios constructor.
     */

    public function carregar()
    {
        $this->carregar_all_Users();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->array = $sql->fetchAll();

        } else {

            $this->array = null;
        }

    }


    public function inserir()
    {

        $this->inserir_usuario();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('nome', $this->getNome());
        $sql->bindValue('email', $this->getEmail());
        $sql->bindValue('login', $this->getLogin());
        $sql->bindValue('senha', $this->getPassword());
        $sql->bindValue('grupo', $this->getGrupo());
        $sql->bindValue('data_cadastro', date('Y/m/d'));
        $sql->bindValue('cargo', $this->getCargo());
        $sql->bindValue('departamento', $this->getDepartamento());
        $sql->bindValue('cidade', $this->getCidade());
        $sql->bindValue('foto', 'user.png');
        $sql->execute();

        if ($sql->rowCount() > 0) {

            return true;

        } else {

            return $sql->errorInfo();
        }

    }


    public function editar($id)
    {
        $this->carregar_usuario();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('id_user', $id);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->array = $sql->fetchAll();

        } else {

            $this->array = null;
        }

    }

    public function excluir($id)
    {
        $this->deletar_usuario();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('id_user', $id);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            return true;

        } else {

            return false;
        }

    }

    public function salvar_edit($id)
    {

        $this->update_usuario();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('nome', $this->getNome());
        $sql->bindValue('email', $this->getEmail());
        $sql->bindValue('cargo', $this->getCargo());
        $sql->bindValue('data_alteracao', date('Y/m/d'));
        $sql->bindValue('grupo', $this->getGrupo());
        $sql->bindValue('departamento', $this->getDepartamento());
        $sql->bindValue('cidade', $this->getCidade());
        $sql->bindValue('id', $id);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            return true;

        } else {

            return false;
        }

    }

    public function trocar_password($id)
    {

        $this->trocar_senha();
        $sql = $this->getPdo()->prepare($this->getSql());
        $sql->bindValue('senha', $this->getPassword());
        $sql->bindValue('id', $id);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            return true;

        } else {

            return false;
        }
    }

    /**
     * @return mixed
     */
    public function getArray()
    {
        return $this->array;
    }

    /**
     * @return mixed
     */
    public function getNome()
    {
        return $this->nome;
    }

    /**
     * @param mixed $nome
     */
    public function setNome($nome)
    {
        $this->nome = $nome;
    }

    /**
     * @return mixed
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param mixed $email
     */
    public function setEmail($email)
    {
        $this->email = $email;
    }

    /**
     * @return mixed
     */
    public function getCargo()
    {
        return $this->cargo;
    }

    /**
     * @param mixed $cargo
     */
    public function setCargo($cargo)
    {
        $this->cargo = $cargo;
    }

    /**
     * @return mixed
     */
    public function getGrupo()
    {
        return $this->grupo;
    }

    /**
     * @param mixed $grupo
     */
    public function setGrupo($grupo)
    {
        $this->grupo = $grupo;
    }

    /**
     * @return mixed
     */
    public function getDepartamento()
    {
        return $this->departamento;
    }

    /**
     * @return mixed
     */
    public function getCidade()
    {
        return $this->cidade;
    }

    /**
     * @param mixed $cidade
     */
    public function setCidade($cidade)
    {
        $this->cidade = $cidade;
    }


    /**
     * @param mixed $departamento
     */
    public function setDepartamento($departamento)
    {
        $this->departamento = $departamento;
    }

    /**
     * @return mixed
     */
    public function getLogin()
    {
        return $this->login;
    }

    /**
     * @param mixed $login
     */
    public function setLogin($login)
    {
        $this->login = $login;
    }

    /**
     * @return mixed
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @param mixed $password
     */
    public function setPassword($password)
    {
        $this->password = $password;
    }

}