<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 28/09/2018
 * Time: 10:41
 */
require_once "ConexaoBD.class.php";

abstract class SQLDashAdm extends BD
{

    private $sql;


    public function load_newOS()
    {


        $this->sql = "select to_date(to_char(coalesce(data_fechamento,(a.data_i)),'DD-MM-YYYY'::text),'DD-MM-YYYY'::text) as data, 
codos, encerrado, x.codconexao, c.codcontrato, p.codpessoa, p.nome_razaosocial, ci.cidade as cidade, c.metodo_faturamento, 
substr(upper(b.bairro)::text,1,13)as bairro, case when mk_os.tipo_os = 1 then 'INSTALAÇÃO' when mk_os.tipo_os = 27 then 'MIGRAÇÃO'
else 'OUTRO' end as OS, case when e.codclassifenc = 1 then 'SUCESSO' when e.codclassifenc = 8 then 'SEM VISADA' when e.codclassifenc = 59 then 'SEM DB' when e.codclassifenc = 52
then 'DESISTENCIA' when e.codclassifenc = 66 then 'CTO CHEIA' when e.codclassifenc = 67 then 'SEM COBERTURA'  when e.codclassifenc is null THEN 'PENDENTE' ELSE 'ENCERRAMENTO INCORRETO' end as status, c.unidade_financeira as tipo, data_fechamento, f.usr_login, pl.descricao as plano
,coalesce(meio.descricao, us2.usr_nome, 'CAC Vendas') as vendedorCRM
from mk_os 
left join mk_os_classificacao_encerramento e on mk_os.classificacao_encerramento = e.codclassifenc and not e.codclassifenc = 69 
left join mk_os_tipo t on mk_os.tipo_os = t.codostipo 
left join mk_conexoes x on x.codconexao = conexao_associada 
left join (select max(a.com_inicio::date) as data_i, a.cd_integracao, (com_dt_realizacao::date) as data_r
from mk_compromissos a where (a.com_inicio::date) >= CURRENT_DATE and (a.com_inicio::date) <= CURRENT_DATE + interval '30 days'
group by a.cd_integracao,a.com_dt_realizacao)a on a.cd_integracao = mk_os.codos 
left join mk_contratos c on c.codcontrato = x.contrato 
left join (select max(l.codlead) as codlead, c.codcontrato, l.meio_entrada_crm from mk_crm_leads l inner join mk_contratos c on l.codlead = c.cd_lead where c.cancelado = 'N' group by c.codcontrato, l.meio_entrada_crm)l on c.cd_lead = l.codlead
left join mk_crm_meio_entrada meio on l.meio_entrada_crm = meio.cd_meio
left join fr_usuario f on f.usr_codigo = c.consultor_crm 
left join mk_pessoas p on p.codpessoa = mk_os.cliente 
left join mk_cidades ci on ci.codcidade = p.codcidade 
left join mk_bairros b on b.codbairro = p.codbairro 
left join mk_planos_acesso pl on pl.codplano = c.plano_acesso
left join fr_usuario us2 on us2.usr_codigo = c.consultor_crm
where mk_os.tipo_os in (1,27) and p.classificacao = 1 and coalesce((a.data_r), data_fechamento,(a.data_i)) 
between :inicio and :fim  group by meio.descricao, us2.usr_nome, codos, data, x.codconexao, c.codcontrato, p.codpessoa, ci.cidade, b.bairro, e.codclassifenc, f.usr_login, pl.descricao
order by data";

    }

    public function load_anualVendas()
    {

        $this->sql = "Select  Date_Part('month', mk_os.data_fechamento) As mes, Date_Part('year', mk_os.data_fechamento) As ano, count(mk_os.codos) as valor 
from mk_os inner join mk_os_classificacao_encerramento e on mk_os.classificacao_encerramento = e.codclassifenc
inner join mk_conexoes x on x.codconexao = conexao_associada inner join mk_contratos c on c.codcontrato = x.contrato
inner join mk_pessoas p on p.codpessoa = c.cliente where mk_os.tipo_os = 1 and mk_os.encerrado = 'S' and c.metodo_faturamento::integer = 1 and p.classificacao = 1 and e.codclassifenc in (1) 
and mk_os.data_fechamento between (date_trunc('month', current_date) - interval '12 month') and (date_trunc('month', current_date) - interval '1 day')
group by mes, ano
order by ano, mes";

    }

    /**
     * @return mixed
     */
    public function getSql()
    {
        return $this->sql;
    }


}
