<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 19/02/2019
 * Time: 16:30
 */

require_once "ConexaoBD.class.php";

abstract class SQLPrevisao extends BD
{

    private $sql;


    public function loadPrevisaoRes()
    {


        $this->sql = "select sum(tab.previsao) as valor from (SELECT coalesce(pl.vlr_mensalidade,c.vlr_renovacao) as previsao, c.cliente, c.codcontrato
FROM mk_contratos c inner join mk_conexoes x on c.codcontrato = x.contrato inner join mk_planos_acesso pl on pl.codplano = c.plano_acesso
WHERE substr(c.unidade_financeira,1,5) in('03.01','03.04','03.06') and substr(c.unidade_financeira,1,11) not in('03.01.01.02')
AND (c.suspenso = 'N' OR c.suspenso is NULL ) AND c.cancelado = 'N' AND c.adesao < Date_trunc('month', current_date)
AND x.conexao_bloqueada = 'N' AND c.metodo_faturamento::integer = 1 group by c.cliente, c.codcontrato, pl.vlr_mensalidade order by cliente)tab";

    }

    public function loadPrevisaoIsp()
    {


        $this->sql = "select y.cliente, y.nome_razaosocial, y.codcontrato, y.previsao from (
SELECT c.cliente, p.nome_razaosocial, c.codcontrato, x.conexao_bloqueada, coalesce(c.vlr_renovacao, pl.vlr_mensalidade) as previsao
FROM mk_contratos c left join mk_conexoes x on c.codcontrato = x.contrato inner join mk_planos_acesso pl on pl.codplano = c.plano_acesso
inner join mk_pessoas p on c.cliente = p.codpessoa WHERE substr(c.unidade_financeira,1,5) in ('03.08') AND (c.suspenso = 'N' OR c.suspenso is NULL )
AND c.adesao < Date_trunc('month', current_date) AND c.metodo_faturamento::integer in (1,2)
group by c.cliente, p.nome_razaosocial, c.codcontrato, pl.vlr_mensalidade, x.conexao_bloqueada order by p.nome_razaosocial
)y where (y.conexao_bloqueada = 'N' OR y.conexao_bloqueada IS NULL)";

    }

    public function loadPrevisaoCom()
    {


        $this->sql = "select sum(tab.previsao) as valor from (SELECT coalesce(c.vlr_renovacao, pl.vlr_mensalidade) as previsao, c.cliente, c.codcontrato
FROM mk_contratos c inner join mk_conexoes x on c.codcontrato = x.contrato inner join mk_planos_acesso pl on pl.codplano = c.plano_acesso
WHERE substr(c.unidade_financeira,1,5) in ('03.02') AND (c.suspenso = 'N' OR c.suspenso is NULL )
AND c.cancelado = 'N' AND x.conexao_bloqueada = 'N' AND c.adesao < Date_trunc('month', current_date) AND c.metodo_faturamento::integer = 1
group by c.cliente, c.codcontrato, pl.vlr_mensalidade order by cliente)tab";

    }

    public function loadPrevisaoEmp()
    {


        $this->sql = "select y.cliente, y.nome_razaosocial, y.codcontrato, y.previsao from (SELECT c.cliente, p.nome_razaosocial, c.codcontrato, x.conexao_bloqueada, coalesce(c.vlr_renovacao, pl.vlr_mensalidade) as previsao
FROM mk_contratos c left join mk_conexoes x on c.codcontrato = x.contrato inner join mk_planos_acesso pl on pl.codplano = c.plano_acesso
inner join mk_pessoas p on c.cliente = p.codpessoa WHERE substr(c.unidade_financeira,1,5) in('03.03') AND substr(c.unidade_financeira,1,8) not in ('03.03.12','03.03.09','03.03.04') AND (c.suspenso = 'N' OR c.suspenso is NULL )
AND c.cancelado = 'N' AND c.adesao < Date_trunc('month', current_date) AND c.metodo_faturamento::integer in (1,2)
group by c.cliente, p.nome_razaosocial, c.codcontrato, pl.vlr_mensalidade, x.conexao_bloqueada order by p.nome_razaosocial)y where (y.conexao_bloqueada = 'N' OR y.conexao_bloqueada IS NULL)";

    }

    public function loadPrevisaoProjeto($codprojeto_mk)
    {

        $this->sql = "select sum(tab.previsao) as valor from (SELECT coalesce(c.vlr_renovacao, pl.vlr_mensalidade) as previsao, c.cliente, c.codcontrato, pro.nome as projeto
    from mk_fiber_projeto pro -- busca armarios criados 
        inner join mk_fiber_caixa cx on cx.cd_projeto = pro.codprojeto -- vincula um projeto com as CTO
        inner join mk_fiber_postes pt on cx.cd_poste = pt.codposte -- vincula a caixa ao poste
        inner join mk_fiber_splitter spli on cx.codcaixa = spli.cd_caixa --vincula as CTO com as splitter
        inner join mk_conexoes x on spli.codsplitter = x.cd_splitter -- vincula uma splitter com uma conexao
        inner join mk_contratos c on x.contrato = c.codcontrato
        inner join mk_planos_acesso pl on pl.codplano = c.plano_acesso
	left join mk_fiber_armarios arm on arm.cd_projeto = pro.codprojeto -- vincula um projeto ao armario
WHERE (c.suspenso = 'N' OR c.suspenso is NULL ) AND c.cancelado = 'N' AND c.adesao < Date_trunc('month', current_date)
AND x.conexao_bloqueada = 'N' AND c.metodo_faturamento::integer = 1 and pro.codprojeto in ($codprojeto_mk)
 group by c.cliente, c.codcontrato, pro.nome, pl.vlr_mensalidade order by cliente)tab";

    }


    public function insertPrevisao()
    {

        $this->sql = "update previsao_newreports set valor = :valor, data_reg = :datareg where mes = :mes and tipo = :tipo and ano = :ano";

    }

    public function insertPrevisaoProjeto()
    {

        $this->sql = "insert into previsao_projetos set valor = :valor, mes = :mes, codprojeto = :projeto, ano = 2019";

    }

    public function searchPrevisao()
    {

        $this->sql = "select valor from previsao_newreports where tipo = :tipo and mes = :mes and ano = :ano";

    }

    public function searchPrevisaoProjeto()
    {

        $this->sql = "select valor from previsao_projetos where codprojeto = :projeto and mes = :mes and ano = 2019";

    }


    /**
     * @return mixed
     */
    public function getSql()
    {
        return $this->sql;
    }


}
