<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 01/11/2018
 * Time: 09:47
 */


require_once "ConexaoBD.class.php";

abstract class SQlComissoes extends BD
{

    private $sql;


    public function loadComissoes()
    {


        $this->sql = "select o.data_fechamento as data, p.nome_razaosocial as nome, o.operador, u.usr_nome as nome_usuario, o.codos as codigo,  
	case when o.tipo_os = 1 then 'INSTALACAO' ELSE 'MIGRACAO' end as tipo, g.grp_nome as grupo, con.unidade_financeira, con.vlr_renovacao, 
	''::text as pago
		from mk_os o 
		inner join mk_pessoas p on o.cliente = p.codpessoa
		inner join mk_os_classificacao_encerramento enc on o.classificacao_encerramento = enc.codclassifenc
		inner join fr_usuario u on u.usr_login = o.operador
		inner join fr_usuario_grupo ug on u.usr_codigo = ug.usr_codigo
		inner join fr_grupo g on g.grp_codigo = ug.grp_codigo
		inner join mk_conexoes c on o.conexao_associada = c.codconexao
		inner join mk_contratos con on c.contrato = con.codcontrato
		left join mk_pessoas pc on pc.codpessoa = con.vendedor
		where o.status = '3' and o.tipo_os in (1) and o.classificacao_encerramento = '1' and p.classificacao = 1 
		and g.grp_nome in ('CAC - Vendas', 'Filiais') and con.metodo_faturamento::integer = 1
		and data_fechamento  between :datai and :dataf";
    }

    public function loadComissoes_externo(){


        $this->sql = "select o.data_fechamento as data, p.codpessoa as codpessoa, p.nome_razaosocial as nome, lower(pc.nome_razaosocial) as operador, o.codos as codigoos, con.cancelado,
case when o.tipo_os = 1 then 'INSTALACAO' ELSE 'MIGRACAO'
end as tipo, con.vlr_renovacao, con.unidade_financeira, contas.pago as faturado, CASE WHEN substr(coalesce(obs_adesao::text, historico_eventos::text), 
length(substring(upper(coalesce(obs_adesao::text, historico_eventos::text)), '^(.*RH-COM-)'::text)) + 1, 11) > 0 then
 substr(coalesce(obs_adesao::text, historico_eventos::text), length(substring(upper(coalesce(obs_adesao::text, historico_eventos::text)), '^(.*RH-COM-)'::text)) + 1, 11) END as \"pago em\"
 from mk_os o 
		inner join mk_pessoas p on o.cliente = p.codpessoa
		inner join mk_os_classificacao_encerramento enc on o.classificacao_encerramento = enc.codclassifenc
		inner join mk_conexoes c on o.conexao_associada = c.codconexao
		inner join mk_contratos con on c.contrato = con.codcontrato
		left join (select case when count(codconta) > 0 then 'SIM' end as pago, codvinculado from mk_plano_contas 
			where tipo_conta = 'R' AND NOT nomenclatura_integracao = 'ACR' and liquidado = 'S' and codvinculado is not null
			group by codvinculado)contas on con.codcontrato = contas.codvinculado
		inner join mk_pessoas pc on pc.codpessoa = con.vendedor
		where o.status = '3' and o.tipo_os in (1,27) and con.metodo_faturamento::integer = 1 and o.classificacao_encerramento = '1' and p.classificacao = 1
		 and pc.classificacao_tipo_cliente_com = '06' and data_fechamento between  :datai and :dataf 
union
select o.data_fechamento as data, p.codpessoa as codpessoa, p.nome_razaosocial as nome, lower(us.usr_nome) as operador, o.codos as codigoos, con.cancelado,
case when o.tipo_os = 1 then 'INSTALACAO' ELSE 'MIGRACAO'
end as tipo, con.vlr_renovacao, con.unidade_financeira, contas.pago as faturado, CASE WHEN substr(coalesce(obs_adesao::text, historico_eventos::text), 
length(substring(upper(coalesce(obs_adesao::text, historico_eventos::text)), '^(.*RH-COM-)'::text)) + 1, 11) > 0 then
 substr(coalesce(obs_adesao::text, historico_eventos::text), length(substring(upper(coalesce(obs_adesao::text, historico_eventos::text)), '^(.*RH-COM-)'::text)) + 1, 11) END as \"pago em\"
 from mk_os o 
		inner join mk_pessoas p on o.cliente = p.codpessoa
		inner join mk_os_classificacao_encerramento enc on o.classificacao_encerramento = enc.codclassifenc
		inner join mk_conexoes c on o.conexao_associada = c.codconexao
		inner join mk_contratos con on c.contrato = con.codcontrato
		left join (select case when count(codconta) > 0 then 'SIM' end as pago, codvinculado from mk_plano_contas 
			where tipo_conta = 'R' AND NOT nomenclatura_integracao = 'ACR' and liquidado = 'S' and codvinculado is not null
			group by codvinculado)contas on con.codcontrato = contas.codvinculado
		inner join fr_usuario us on us.usr_codigo = con.consultor_crm
		where o.status = '3' and o.tipo_os in (1,27) and con.metodo_faturamento::integer = 1 and o.classificacao_encerramento = '1' and p.classificacao = 1 and con.vendedor is null
		 and data_fechamento between  :datai and :dataf order by data";

    }

    /**
     * @return mixed
     */
    public function getSql()
    {
        return $this->sql;
    }




}
