<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 04/12/2018
 * Time: 15:25
 */

require_once "ConexaoBD.class.php";

abstract class SqlCancelamento extends BD
{

    private $sql;


    public function loadCancelamento()
    {

        $sql = "select p.codpessoa, substr(p.nome_razaosocial::text, 1,35) as nome, substr(mo.descricao_mot_cancel::text, 1,18) as motivo, os.codos, os.data_abertura,
    c.vlr_renovacao as mensalidade, c.unidade_financeira as tipo, un.descricao as tipo2, upper(b.bairro) as bairro, c.codcontrato, 
	upper(ci.cidade) as cidade, dt_cancelamento as data, upper(pl.descricao) as plano, lower(user_cancelamento) as operador 
	from mk_contratos c
	inner join mk_pessoas p on p.codpessoa = c.cliente
	inner join mk_planos_acesso pl on pl.codplano = c.plano_acesso
	inner join mk_motivo_cancelamento mo on mo.codmotcancel = c.motivo_cancelamento_2
	left join mk_unidade_financeia un on c.unidade_financeira = un.nomenclatura    
	inner join mk_cidades ci on ci.codcidade = p.codcidade
	inner join mk_bairros b on b.codbairro = p.codbairro
	left join (select max(codos) as codos, cliente, cd_contrato, max(data_abertura) as data_abertura from mk_os where tipo_os = 5 and status = 3 group by cliente, cd_contrato)os on c.codcontrato = os.cd_contrato	
	where c.cancelado = 'S' and p.classificacao = 1 and c.metodo_faturamento::integer != 3 and c.motivo_cancelamento_2 not in (16,4,17,32,19,31,30,33,34,35,36,29,56,62,63,59) 
	and c.dt_cancelamento between :data_i and :data_f order by data desc";

        $this->sql = $sql;
    }

    public function loadOSPendenteCancelamento()
    {
        $sql = "select a.data_i as data_agendamento, data_abertura, codos, encerrado, x.codconexao, c.codcontrato, p.codpessoa, p.nome_razaosocial, ci.cidade as cidade, c.metodo_faturamento, 
c.vlr_renovacao as mensalidade, substr(upper(b.bairro)::text,1,13)as bairro, mk_os.tipo_os as tipo_os, mk_os.status as os_status, mk_os.classificacao_encerramento as encerramento, c.unidade_financeira as tipo,
un.descricao as tipo2, us.usr_login as tecnicos, coalesce(mk_os.operador_fech_tecnico::integer, a.cd_operador) as codtecnico
from mk_os  
inner join mk_conexoes x on x.codconexao = conexao_associada left join (select max(a.com_inicio::date) as data_i, a.cd_integracao, (com_dt_realizacao::date) as data_r, a.cd_operador 
from mk_compromissos a where (a.com_inicio::date) >= CURRENT_DATE and (a.com_inicio::date) <= CURRENT_DATE + interval '30 days'
group by a.cd_integracao,a.com_dt_realizacao, a.cd_operador)
a on a.cd_integracao = mk_os.codos inner join mk_contratos c on c.codcontrato = x.contrato left join mk_unidade_financeia un on c.unidade_financeira = un.nomenclatura 
inner join mk_pessoas p on p.codpessoa = mk_os.cliente
inner join mk_cidades ci on ci.codcidade = p.codcidade inner join mk_bairros b on b.codbairro = p.codbairro
inner join (select * from fr_usuario where not usr_codigo = 32)us on us.usr_codigo = coalesce(mk_os.operador_fech_tecnico::integer, a.cd_operador) 
where encerrado = 'N' and tipo_os = 5 and p.classificacao = 1 and c.metodo_faturamento::integer != 3 and c.cancelado = 'N'
and data_abertura between :data_i and :data_f group by codos, data_agendamento, x.codconexao, un.descricao, c.codcontrato, a.cd_operador, p.codpessoa, ci.cidade, b.bairro, mk_os.classificacao_encerramento, us.usr_login
order by us.usr_login";

        $this->sql = $sql;

    }


    public function loadAnualCancelamento()
    {


        $sql = "select  Date_Part('month', c.dt_cancelamento) As mes, Date_Part('year', c.dt_cancelamento) As ano,
	count(c.codcontrato) As valor
	from mk_contratos c inner join mk_pessoas p on p.codpessoa = c.cliente
	inner join mk_motivo_cancelamento mo on mo.codmotcancel = c.motivo_cancelamento_2 
	where c.cancelado = 'S' and p.classificacao = 1 and c.metodo_faturamento::integer != 3 and c.motivo_cancelamento_2 not in (16,4,17,32,19,31,30,33,34,35,36,29,56,62,63,59) 
	and c.dt_cancelamento between date_trunc('month' , current_date - interval '12 month') and (date_trunc('month', current_date) - interval '1 day')
	group by mes, ano order by ano, mes
";

        $this->sql = $sql;
    }

    public function loadequipamentosperdidos()
    {

        $sql = "select  p.codpessoa, p.nome_razaosocial, c.codcontrato, os.codos, enc.classificacao, os.data_fechamento, c.unidade_financeira, b.bairro, cid.cidade, substr(p.email,1,50) as email, coalesce(fone01,fone02) as telefone from mk_os os 
		       inner join mk_conexoes con on con.codconexao = os.conexao_associada
		       inner join mk_contratos c on c.codcontrato = con.contrato
		       inner join mk_os_classificacao_encerramento enc on enc.codclassifenc = os.classificacao_encerramento
		       inner join mk_pessoas p on con.codcliente = p.codpessoa
		       inner join mk_bairros b on p.codbairro = b.codbairro
		       inner join mk_unidade_financeia uf on uf.nomenclatura = c.unidade_financeira
		       inner join mk_cidades cid on cid.codcidade = p.codcidade
		       where c.cancelado = 'S' and os.classificacao_encerramento not in (1) and os.tipo_os = 5
               and os.data_fechamento between (date_trunc('month', current_date) - interval '3 month') and (date_trunc('month', current_date) - interval '1 day')
		       order by os.data_fechamento";

        $this->sql = $sql;
    }

    public function loadfluxo()
    {

        $sql = "
select * from (select a.dt_abertura as data, ci.cidade as cidade, p.codpessoa as codigo, p.nome_razaosocial as cliente, ap.nome_processo as processo, a.operador_abertura as operador, 
        CASE
             WHEN ate.cd_os IS NULL AND o.codos IS NOT NULL THEN 'TICKET SEM OS'::text
             WHEN ate.cd_os IS NOT NULL AND o.codos IS NOT NULL AND o.conexao_associada IS NULL THEN 'OS SEM CONEXAO'::text
             WHEN ate.cd_os IS NOT NULL AND o.status = 1 AND o.encerrado = 'N' THEN 'AGENDAR'::text
             WHEN ate.cd_os IS NOT NULL AND o.status = 2 AND o.encerrado = 'N'::bpchar AND (ag.com_inicio IS NOT NULL) AND (now()::date > ag.com_inicio) THEN 'REAGENDAR'::text
             WHEN ate.cd_os IS NOT NULL AND o.status = 2 AND o.encerrado = 'N'::bpchar THEN 'AGUARDANDO'::text
             WHEN ate.cd_os IS NOT NULL AND o.status = 3 THEN 'CONCLUIDO'::text
             ELSE '-'
         END as os, 
	CASE
             WHEN ate.cd_os IS NOT NULL AND o.status = 1 AND o.encerrado = 'N'::bpchar AND (ag.com_inicio IS NULL) THEN 'AGENDAR'::text
             WHEN ate.cd_os IS NOT NULL AND o.status = 2 AND o.encerrado = 'N'::bpchar AND (ag.com_inicio IS NOT NULL) AND (now()::date > ag.com_inicio) THEN 'REAGENDAR'::text
             WHEN ate.cd_os IS NOT NULL AND o.status = 2 AND o.encerrado = 'N' AND (ag.com_inicio IS NOT NULL) AND (now()::date <= ag.com_inicio) THEN (to_char(ag.com_inicio, 'dd/mm/yyyy - HH24:MI'::text))
             WHEN ate.cd_os IS NOT NULL AND o.encerrado = 'S'::bpchar THEN 'CONCLUIDO'::text
             ELSE '-'
         END as agenda, 
         CASE
             WHEN a.finalizado = 'N' then 'PENDENTE'
	     WHEN a.finalizado = 'S' then 'ENCERRADO'
             ELSE '-'
         END as ticket, o.data_fechamento as encerramento,
         CASE
             WHEN ate.cd_os IS NOT NULL AND o.encerrado = 'S'::bpchar THEN e.classificacao::text
             ELSE '-'
         END as classificacao, o.codos, a.codatendimento, b.bairro     
   from mk_atendimento a INNER JOIN mk_ate_processos ap on a.cd_processo = ap.codprocesso
                               INNER JOIN mk_pessoas p on a.cliente_cadastrado = p.codpessoa
                               INNER JOIN mk_bairros b on b.codbairro = p.codbairro
                               INNER JOIN mk_cidades ci on p.codcidade = ci.codcidade
			       LEFT JOIN mk_ate_os ate ON a.codatendimento = ate.cd_atendimento
			       LEFT JOIN mk_os o on o.codos = ate.cd_os
			       LEFT JOIN mk_os_classificacao_encerramento e ON o.classificacao_encerramento = e.codclassifenc
                               LEFT JOIN ( SELECT max(mk_compromissos.codcompromisso) AS codigo, mk_compromissos.cd_integracao, mk_compromissos.com_inicio
   FROM mk_compromissos
  GROUP BY mk_compromissos.cd_integracao, mk_compromissos.com_inicio) ag ON ag.cd_integracao = o.codos
 where a.cd_processo in (5,37,17,11) and a.situacao = 'I'  and a.dt_abertura >= '15-03-2019' order by data desc) fluxo 
	where not fluxo.ticket = 'ENCERRADO' 
";

        $this->sql = $sql;

    }

    public function loadInativos()
    {

        $sql = "select c.codcontrato, c.unidade_financeira, f.nome_razaosocial, f.codpessoa, x.codconexao, c.adesao, x.conexao_bloqueada, sum(
                CASE
                    WHEN NOT p.codvinculado IS NULL THEN 1
                    ELSE 0
                END) AS qtd_aberto, min(p.data_vencimento) as pri_vencto
	from mk_contratos c
               INNER JOIN mk_pessoas f ON f.codpessoa = c.cliente
               INNER JOIN mk_plano_contas p ON p.codvinculado = c.codcontrato AND p.nomenclatura_integracao in ('CNT','MAN','ADE') and p.tipo_conta = 'R' AND p.liquidado = 'N' and p.suspenso = 'N'
               INNER JOIN mk_contas_faturadas ft ON p.codconta = ft.cd_conta 
               INNER JOIN mk_faturas fa ON ft.cd_fatura = fa.codfatura
	       INNER JOIN mk_conexoes x ON c.codcontrato = x.contrato
	       where c.cancelado = 'N' AND c.adesao >= '01-01-2016' and (c.suspenso = 'N' OR c.suspenso IS NULL)
			AND p.data_vencimento_original <= :data
	        group by c.codcontrato, c.unidade_financeira, f.nome_razaosocial, f.codpessoa, x.codconexao
	        order by qtd_aberto";

        $this->sql = $sql;
    }

    // CARREGA OS CANCELAMENTOS APARTIR DA DATA DE ABERTURA DA OS DE CANCELAMENTO
    public function loadCancelamentoOS()
    {
        $sql = "
        select o.data_abertura, p.nome_razaosocial, p.codpessoa, c.codcontrato, o.codos, c.unidade_financeira as tipo, un.descricao as tipo2, x.conexao_bloqueada, c.cancelado from mk_os o 
            inner join mk_conexoes x on o.conexao_associada = x.codconexao
            inner join mk_contratos c on x.contrato = c.codcontrato
            inner join mk_pessoas p on p.codpessoa = c.cliente
            inner join mk_unidade_financeia un on c.unidade_financeira = un.nomenclatura   
            where o.data_abertura between :data_i and :data_f and o.tipo_os = 5 and c.metodo_faturamento::integer != 3 and p.classificacao = 1
            order by o.data_abertura";

            $this->sql = $sql;
    }

    /**
     * @return mixed
     */
    public function getSql()
    {
        return $this->sql;
    }


}
