<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 26/02/2019
 * Time: 15:36
 */

require_once "ConexaoBD.class.php";

abstract class SqlClientes extends BD
{


    private $sql;

    public function loadCarteiraClientes_Ativos($unidade)
    {

        $this->sql = "select c.cliente, p.nome_razaosocial as nome, c.codcontrato, c.unidade_financeira as tipo, pg.data
as ult_pgto, c.adesao, ci.cidade from mk_contratos c inner join mk_conexoes x on c.codcontrato = x.contrato
inner join mk_pessoas p on c.cliente = p.codpessoa 
inner join mk_cidades ci on p.codcidade = ci.codcidade
left join (select max(data_liquidacao) as data, codvinculado as contrato
from mk_plano_contas where liquidado = 'S' and tipo_conta = 'R' and nomenclatura_integracao = 'CNT' 
and data_liquidacao is not null and codvinculado is not null group by codvinculado) pg on c.codcontrato = pg.contrato
where c.cancelado = 'N' and (c.suspenso = 'N' or c.suspenso is null) and c.metodo_faturamento::integer != 3
and x.conexao_bloqueada = 'N' and substr(c.unidade_financeira, 1,5) in ('$unidade') and c.unidade_financeira not in ('03.02.02','03.03.04','03.01.01.02')
group by c.cliente, p.nome_razaosocial, c.codcontrato, pg.data, c.unidade_financeira, c.adesao, ci.cidade
order by c.adesao desc";

    }


    public function load_newAccession()
    {


        $this->sql = "select to_date(to_char(coalesce(adesao,(a.data_i)),'DD-MM-YYYY'::text),'DD-MM-YYYY'::text) as data, 
codos, encerrado, x.codconexao, c.codcontrato, p.codpessoa, p.nome_razaosocial, ci.cidade as cidade, c.metodo_faturamento, 
substr(upper(b.bairro)::text,1,13)as bairro, case when mk_os.tipo_os = 1 then 'INSTALAÇÃO' when mk_os.tipo_os = 27 then 'MIGRAÇÃO'
else 'OUTRO' end as OS, case when e.codclassifenc = 1 then 'SUCESSO' when e.codclassifenc = 8 then 'SEM VISADA' when e.codclassifenc = 59 then 'SEM DB' when e.codclassifenc = 52
then 'DESISTENCIA' when e.codclassifenc = 66 then 'CTO CHEIA' when e.codclassifenc = 67 then 'SEM COBERTURA'  when e.codclassifenc is null THEN 'PENDENTE' ELSE 'ENCERRAMENTO INCORRETO' end as status, c.unidade_financeira as tipo, data_fechamento, f.usr_login, pl.descricao as plano
from mk_os left join mk_os_classificacao_encerramento e on mk_os.classificacao_encerramento = e.codclassifenc and not e.codclassifenc = 69 
left join mk_os_tipo t on mk_os.tipo_os = t.codostipo left join mk_conexoes x on x.codconexao = conexao_associada 
left join (select max(a.com_inicio::date) as data_i, a.cd_integracao, (com_dt_realizacao::date) as data_r
from mk_compromissos a where (a.com_inicio::date) >= CURRENT_DATE and (a.com_inicio::date) <= CURRENT_DATE + interval '30 days'
group by a.cd_integracao,a.com_dt_realizacao)a on a.cd_integracao = mk_os.codos left join mk_contratos c on c.codcontrato = x.contrato left join fr_usuario f on f.usr_codigo = c.consultor_crm left join mk_pessoas p on p.codpessoa = mk_os.cliente 
left join mk_cidades ci on ci.codcidade = p.codcidade left join mk_bairros b on b.codbairro = p.codbairro left join mk_planos_acesso pl on pl.codplano = c.plano_acesso
where mk_os.tipo_os in (1,27) and p.classificacao = 1 and coalesce((a.data_r), adesao,(a.data_i)) 
between :inicio and :fim  group by codos, data, x.codconexao, c.codcontrato, p.codpessoa, ci.cidade, b.bairro, e.codclassifenc, f.usr_login, pl.descricao
order by data";

    }


    public function loadVendidos()
    {

        $this->sql = "select p.codpessoa, p.nome_razaosocial, p.grupo_atendimento, b.bairro, ci.cidade, c.unidade_financeira as tipo, pl.descricao as plano, uf.descricao as planocontas, to_char(ag.com_inicio, 'dd/mm/yyyy'::text) as agenda from (SELECT p_1.codpessoa AS cliente
FROM mk_pessoas p_1 LEFT JOIN mk_os o_1 ON p_1.codpessoa = o_1.cliente AND o_1.tipo_os = 1
WHERE p_1.classificacao = 1 AND p_1.datacadastro = current_date UNION SELECT o_1.cliente FROM mk_os o_1
WHERE o_1.tipo_os = 1 AND o_1.data_abertura = current_date)i JOIN mk_pessoas p on p.codpessoa = i.cliente
JOIN mk_cidades ci on p.codcidade = ci.codcidade
JOIN mk_bairros b on p.codbairro = b.codbairro
LEFT JOIN mk_os o ON o.cliente = i.cliente AND o.tipo_os = 1 AND o.data_abertura = current_date
LEFT JOIN mk_conexoes x on o.conexao_associada = x.codconexao
LEFT JOIN mk_contratos c on x.contrato = c.codcontrato
LEFT JOIN mk_planos_acesso pl on pl.codplano = c.plano_acesso
LEFT JOIN mk_unidade_financeia uf on uf.nomenclatura = c.unidade_financeira
LEFT JOIN ( SELECT max(mk_compromissos.codcompromisso) AS codigo, mk_compromissos.cd_integracao, mk_compromissos.com_inicio,
mk_compromissos.com_dt_realizacao FROM mk_compromissos GROUP BY mk_compromissos.cd_integracao, mk_compromissos.com_inicio, mk_compromissos.com_dt_realizacao) ag ON ag.cd_integracao = o.codos
LEFT JOIN fr_log_event l ON l.log_operacao = 'I'::bpchar AND l.log_chave::text = 'codpessoa'::text AND l.log_chavecont::text = i.cliente::text
JOIN (select u.usr_login, ug.grp_codigo from fr_usuario u inner join fr_usuario_grupo ug on u.usr_codigo = ug.usr_codigo where ug.grp_codigo = :codigo) cac
ON cac.usr_login::text = COALESCE(o.operador, l.log_usuario)::text where p.grupo_atendimento = :segmento and o.tipo_os is not null and ag.com_inicio is not null
order by p.nome_razaosocial";

    }

    public function loadtotalCarteira(){


        $this->sql = "SELECT c.id, c.total, s.seguimento, m.mes, c.ano FROM carteira_clientes c INNER JOIN seguimento s on 
c.cod_seguimento = s.id_seguimento INNER JOIN mes m ON c.cod_mes = m.id where s.id_seguimento = :seguimento and m.mes = :mes and c.ano = :ano";

    }
    public function loadAllCarteira(){


        $this->sql = "SELECT c.total, m.mes, c.ano, m.id FROM carteira_clientes c INNER JOIN seguimento s on 
c.cod_seguimento = s.id_seguimento INNER JOIN mes m ON c.cod_mes = m.id where s.seguimento = :seguimento and c.ano = :ano order by m.id";
    }

    public function updatecarteiraCliente(){

        $this->sql = "update carteira_clientes set total = :total, dt_alteracao = :dt_alteracao where id = :id";
    }

    public function insereClientes(){

        $this->sql = "insert into carteira_clientes set cod_mes = :mes, ano = :ano, total = :total, cod_seguimento = :seguimento";
    }

    /**
     * @return mixed
     */
    public function getSql()
    {
        return $this->sql;
    }


}

?>
