<?php


require_once "ConexaoBD.class.php";

abstract class SqlCobranca extends BD{

    private $sql;

    public function loadQuerySemCobranca(){

        $this->sql = "SELECT * FROM (select p.codpessoa, p.nome_razaosocial, upper(b.bairro) as bairro, upper(ci.cidade) as cidade, Sum(f.valor_total) As total, min(f.data_vencimento) as primeiro_vcto, current_date - min(f.data_vencimento) as dias_em_atraso
 from mk_cobr_faturas cob
	inner join mk_faturas f on cob.cd_fatura = f.codfatura
	inner join mk_pessoas p on f.cd_pessoa = p.codpessoa
	inner join mk_bairros b on p.codbairro = b.codbairro
	inner join mk_cidades ci on p.codcidade = ci.codcidade
	inner join mk_contas_faturadas cf on f.codfatura = cf.cd_fatura
	inner join mk_plano_contas pl on cf.cd_conta = pl.codconta
	where pl.tipo_conta = 'R' and f.excluida = 'N' and f.suspenso = 'N' and f.liquidado = 'N' and cob.status = 0 and cob.excluida = 'N'
	Group By p.codpessoa, b.bairro, ci.cidade
	order by dias_em_atraso)cob where cob.dias_em_atraso >= 20";
    }

    public function loadQueryCobrancaSPC(){
        $this->sql = "select ac.dh_start::date as data_inicio, u.usr_login as operador, p.codpessoa, p.nome_razaosocial, upper(b.bairro) as bairro, upper(ci.cidade) as cidade, af.em_acordo, f.codfatura, f.data_vencimento as prazo_acordo, ac.data_tolerancia, af.vlr_original As valor,
case when f.liquidado = 'N' and h.vct_original < current_date then current_date - h.vct_original else 0 end as dias_atraso,
case when f.liquidado = 'S' then 'LIQUIDADO' when s.cd_fatura is not null then 'SPC OK'
    when o.encerrado = 'N' then 'AGUARDANDO RETIRADA' when f.data_vencimento < current_date then 'ACORDO VENCIDO'  else 'AGUARDANDO PAGAMENTO' end as acordo, h.vct_original, 
case when f.liquidado = 'S' and maxos.codos is null then '-' when (maxos.codos is null) and (current_date - h.vct_original) > 74 and f.data_vencimento < current_date then 'ABRIR OS' else maxos.codos::text end as codos,
case when o.encerrado = 'S' then oc.classificacao when o.encerrado = 'N' then 'AGUARDANDO RETIRADA' else o.encerrado end as encerrado,
case when s.cd_fatura is not null then 'SPC OK' when o.classificacao_encerramento in (57,1) and f.liquidado = 'N' and f.data_vencimento < current_date then 'SPC ENV' when o.classificacao_encerramento = 69 then 'OS INCORRETA' else '-' end as SPC
 from mk_cobr_faturas cob
	inner join mk_faturas f on cob.cd_fatura = f.codfatura
	inner join mk_pessoas p on f.cd_pessoa = p.codpessoa
	left join (select max(codos) as codos, tipo_os, cliente from mk_os where tipo_os = 62 group by tipo_os, cliente)maxos on p.codpessoa = maxos.cliente
	left join mk_os o on maxos.codos = o.codos
	left join mk_os_classificacao_encerramento oc on o.classificacao_encerramento = oc.codclassifenc
	inner join mk_bairros b on p.codbairro = b.codbairro
	inner join mk_cidades ci on p.codcidade = ci.codcidade
	left join mk_cobr_conta_acordos_faturas af on f.codfatura = af.cd_fatura and af.em_acordo = 'S'
	inner join mk_cobr_conta_acordos ac on af.cd_acordo = ac.codcobrcontaacordo
        left join mk_cobr_conta cd on p.codpessoa = cd.cd_cliente
        left join mk_cobr_spc s on f.codfatura = s.cd_fatura
        left join fr_usuario u on coalesce(cob.id_operador, cob.ope_troca_status) = u.usr_codigo
        left join (select min(vcto) as vct_original, cd_fatura from mk_cobr_historico group by cd_fatura)h on f.codfatura = h.cd_fatura
	where f.excluida = 'N' and f.suspenso = 'N' and cob.status in (3,4) and cob.excluida = 'N' and ac.dh_start >= '01-01-2022'
	order by nome_razaosocial";
    }

    public function loadQueryCobrancaLiquidadosAnual()
    {

        $this->sql = "select Date_Part('month',cob.data_inicio) As mes, Date_Part('year', cob.data_inicio) As ano, count(cob.codfatura) as total, sum(cob.valor) as valor, cob.acordo from (
select ac.dh_start::date as data_inicio, u.usr_login as operador, p.codpessoa, p.nome_razaosocial, upper(b.bairro) as bairro, upper(ci.cidade) as cidade, af.em_acordo, f.codfatura, f.data_vencimento as prazo_acordo, ac.data_tolerancia, af.vlr_original As valor,
case when f.liquidado = 'N' and h.vct_original < current_date then current_date - h.vct_original else 0 end as dias_atraso,
case when f.liquidado = 'S' then 'LIQUIDADO' when s.cd_fatura is not null then 'SPC OK'
    when o.encerrado = 'N' then 'AGUARDANDO RETIRADA' when f.data_vencimento < current_date then 'ACORDO VENCIDO'  else 'AGUARDANDO PAGAMENTO' end as acordo, h.vct_original, 
case when f.liquidado = 'S' and maxos.codos is null then '-' when (maxos.codos is null) and (current_date - h.vct_original) > 44 and f.data_vencimento < current_date then 'ABRIR OS' else maxos.codos::text end as codos,
case when o.encerrado = 'S' then oc.classificacao when o.encerrado = 'N' then 'AGUARDANDO RETIRADA' else o.encerrado end as encerrado,
case when s.cd_fatura is not null then 'SPC OK' when o.classificacao_encerramento in (57,1) and f.liquidado = 'N' and f.data_vencimento < current_date then 'SPC ENV' when o.classificacao_encerramento = 69 then 'OS INCORRETA' else '-' end as SPC
 from mk_cobr_faturas cob
	inner join mk_faturas f on cob.cd_fatura = f.codfatura
	inner join mk_pessoas p on f.cd_pessoa = p.codpessoa
	left join (select max(codos) as codos, tipo_os, cliente from mk_os where tipo_os = 62 group by tipo_os, cliente)maxos on p.codpessoa = maxos.cliente
	left join mk_os o on maxos.codos = o.codos
	left join mk_os_classificacao_encerramento oc on o.classificacao_encerramento = oc.codclassifenc
	inner join mk_bairros b on p.codbairro = b.codbairro
	inner join mk_cidades ci on p.codcidade = ci.codcidade
	left join mk_cobr_conta_acordos_faturas af on f.codfatura = af.cd_fatura and af.em_acordo = 'S'
	inner join mk_cobr_conta_acordos ac on af.cd_acordo = ac.codcobrcontaacordo
        left join mk_cobr_conta cd on p.codpessoa = cd.cd_cliente
        left join mk_cobr_spc s on f.codfatura = s.cd_fatura
        left join fr_usuario u on coalesce(cob.id_operador, cob.ope_troca_status) = u.usr_codigo
        left join (select min(vcto) as vct_original, cd_conta_cobr from mk_cobr_historico group by cd_conta_cobr)h on cd.codcobrconta = h.cd_conta_cobr
	where f.excluida = 'N' and f.suspenso = 'N' and cob.status in (3,4) and cob.excluida = 'N' and ac.dh_start::date >= '2021-06-01' --and f.codfatura = 1123374
	order by nome_razaosocial)cob
	where cob.acordo = 'LIQUIDADO' or cob.acordo = 'SPC OK' 
	group by mes, ano, cob.acordo
	order by ano limit 22";
    }

        public function loadQueryAbaSPC(){
            $this->sql = "select spc.dh::date as data_inicio, p.nome_razaosocial, spc.cd_fatura as fatura_SPC, 
case when f.liquidado = 'S' then 'Liquidado' when f.suspenso = 'S' then 'Suspenso' when f.excluida = 'S' then 'Excluida' else '-' end as liquidado, 
spc.fim, max(aten.codatendimento) as atendimento, f.cd_pessoa , ate.cd_processo, ate.finalizado,
case when ate.cd_processo = 85 and f.liquidado = 'N' and f.suspenso = 'N' and f.excluida = 'N' then 'AGUARDAR' when ate.cd_processo is null then 'ABRIR TICKET' when ate.finalizado = 'S' then 'FINALIZADO' when f.liquidado = 'S' or f.excluida = 'S' then 'ENCERRAR TICKET'  end as ticket,
case when ate.codatendimento is null then 'ENVIAR SPC' when ate.codatendimento is not null and f.liquidado = 'N' and f.suspenso = 'N' and f.excluida = 'N' then 'AGUARDAR' when spc.fim = 'S'  then 'FINALIZADO' when ate.codatendimento is not null and f.liquidado = 'S' then 'RETIRAR SPC'  end as SPC
from mk_cobr_spc spc
inner join mk_faturas f on f.codfatura = spc.cd_fatura
inner join mk_contratos c on c.cliente = f.cd_pessoa
inner join mk_pessoas p on p.codpessoa = c.cliente
left join (select max(codatendimento) as codatendimento ,cliente_cadastrado, cd_processo  from mk_atendimento where cd_processo = 85 group by cliente_cadastrado, cd_processo) aten on c.cliente = aten.cliente_cadastrado
left join mk_atendimento ate on aten.codatendimento = ate.codatendimento
group by spc.cd_fatura, f.cd_pessoa , ate.cd_processo, f.liquidado, spc.fim, ate.codatendimento, p.nome_razaosocial, ate.finalizado, spc.dh, f.suspenso, f.excluida
order by spc.dh desc";
        }



    /**
     * @return mixed
     */
    public function getSql()
    {
        return $this->sql;
    }


}
