<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 19/09/2018
 * Time: 13:22
 */

require_once "ConexaoBD.class.php";

abstract class SqlConfig extends BD
{

    private $sql;


    //SQL USUARIOS

    public function carregar_all_Users()
    {


        $this->sql = "SELECT u.id, u.nome, u.email, u.login, u.nivel_acesso_id, ac.nome_nivel, u.data_cadastro,
                u.data_alteracao, u.cargo, dep.pagina_home, u.cod_dep, dep.nome_dep, ci.cidade, u.codcidade FROM usuarios u 
                inner JOIN nivel_acessos ac on ac.id = u.nivel_acesso_id
                inner join cidades ci on ci.idcidade = u.codcidade 
                left join departamento dep on u.cod_dep = dep.id_dep";

    }

    public function carregar_usuario()
    {

        $this->sql = "SELECT u.id, u.nome, u.email, u.login, u.nivel_acesso_id, ac.nome_nivel, u.data_cadastro,
                u.data_alteracao, u.cargo, dep.pagina_home, u.cod_dep, dep.nome_dep, ci.cidade, u.codcidade FROM usuarios u 
                inner JOIN nivel_acessos ac on ac.id = u.nivel_acesso_id
                inner join cidades ci on ci.idcidade = u.codcidade  
                inner join departamento dep on u.cod_dep = dep.id_dep
                WHERE u.id = :id_user";

    }

    public function update_usuario(){


        $this->sql = "UPDATE usuarios SET nome = :nome, email = :email, cargo = :cargo, data_alteracao = :data_alteracao,
                nivel_acesso_id = :grupo, cod_dep = :departamento, codcidade = :cidade WHERE id = :id";

    }

    public function inserir_usuario(){


        $this->sql = "INSERT INTO usuarios set nome = :nome, email = :email, login = :login, senha = :senha, nivel_acesso_id = :grupo,
                         data_cadastro = :data_cadastro, cargo = :cargo, cod_dep = :departamento, codcidade = :cidade, foto = :foto";

    }

    public function deletar_usuario(){

        $this->sql = "DELETE FROM usuarios where id = :id_user limit 1";

    }


    //SQL MENU

    public function carregar_all_Menus(){

        //carrega os menus e suas paginas

        $this->sql = "select * from menu m inner join pages pg on m.id_menu = pg.page_cod_menu";

    }

    public function carregar_menu(){

        $this->sql = "select * from menu where id_menu = :id";
    }

    public function inserir_menu(){

        $this->sql = "INSERT INTO menu SET nome = ?, url = ?, icon = ?, alias = ?, menu_config = ?, menu_page = ?";

    }

    public function inserir_permissao_menu(){

        $this->sql = "INSERT INTO permissao_menu set cod_menu = ?, acesso = ?, nivel_acesso = ?";
    }

    public function inserir_page_menu(){

        $this->sql = "INSERT INTO pages set nome_page = ?, page_cod_menu = ?";

    }

    public function inserir_permissao_page(){

        $this->sql = "INSERT INTO permissao_page set cod_page = ?, nivel_acesso_user = ?, status = ?";

    }

    public function updateMenu(){

        $this->sql = "update menu set nome = ?, url = ?, icon = ?, alias = ?, menu_config = ?, menu_page = ? where id_menu = ?";

    }

    public function update_page_menu(){

        $this->sql = "UPDATE pages set nome_page = ? where page_cod_menu = ?";

    }

    public function verificasubmenu(){

        $this->sql = "select * from sub_menu where cod_menu = :menu";
    }

    public function deletar_menu(){

        //deleta o menu,a permissao do menu, paginas do meu e as permissoes da pagina do menu
        $this->sql = "delete m, p, pg, pp from menu m INNER join permissao_menu p on m.id_menu = p.cod_menu
                                         INNER JOIN pages pg on pg.nome_page = m.menu_page
                                         inner join permissao_page pp on pp.cod_page = pg.cod_page
                                         where m.id_menu = :id";
    }


    //SQL SUBMENU

    public function carregar_all_Submenus(){


        $this->sql = "select sub.id_submenu, pg.cod_page, sub.nome, m.nome as menu, m.alias as menu_alias, sub.cod_menu, sub.icon, sub.url, sub.alias, sub.sub_page 
                                                  from sub_menu sub 
                                                  inner join pages pg on sub.id_submenu = pg.page_cod_submenu
                                                  left join menu m on sub.cod_menu = m.id_menu";
    }

    public function carregar_submenu(){

        $this->sql = "select sub.id_submenu, pg.cod_page, sub.nome, m.nome as menu, m.alias as menu_alias, sub.cod_menu, sub.icon, sub.url, sub.alias, sub.sub_page 
                                                  from sub_menu sub 
                                                  inner join pages pg on sub.id_submenu = pg.page_cod_submenu
                                                  left join menu m on sub.cod_menu = m.id_menu
                                                  where id_submenu = :id";
    }

    public function verificar_duplicidade_sub(){

        $this->sql = "select * from sub_menu where nome = :nome";

    }

    public function inserir_submenu(){

        $this->sql = "INSERT INTO sub_menu set cod_menu = ?, nome = ?, icon = ?, url = ?, alias = ?, sub_page = ?";

    }

    public function inserir_permissao_sub(){

        $this->sql = "INSERT INTO permissao_submenu set cod_submenu = ?, acesso = ?, nivel_acesso = ?";

    }

    public function inserir_page_sub(){

        $this->sql = "INSERT INTO pages set nome_page = ?, page_cod_submenu = ?";


    }

    public function updateSubmenu(){

        $this->sql = "update sub_menu set cod_menu = ?, nome = ?, icon = ?, url = ?, alias = ?, sub_page = ? where id_submenu = ?";

    }

    public function update_page_submenu(){

        $this->sql = "UPDATE pages set nome_page = ? where page_cod_submenu = ?";

    }

    public function removerSubmenu(){

        $this->sql = "delete sub, p, pg, pp from sub_menu sub INNER join permissao_submenu p on sub.id_submenu = p.cod_submenu
                                         INNER JOIN pages pg on pg.page_cod_submenu = sub.id_submenu
                                         inner join permissao_page pp on pp.cod_page = pg.cod_page
                                         where sub.id_submenu= :id and not sub.id_submenu = 15";

    }

    public function carregapermissaoGrupo_Submenu(){

        $this->sql = "select p.acesso, sub.nome, n.nome_nivel from permissao_submenu p 
		inner join sub_menu sub on p.cod_submenu = sub.id_submenu
        inner join nivel_acessos n on p.nivel_acesso = n.id 
        where n.id = :id and p.cod_submenu = :submenu";
    }

    public function carragapermissaoSubmenu(){

        $this->sql = "select * from permissao_submenu where cod_submenu = :submenu and nivel_acesso = :acesso";

    }


    //SQL GRUPO DE ACESSO

    public function carregar_all_GruposAcesso()
    {


        $this->sql = "select * from nivel_acessos order by nome_nivel";


    }

    public function buscar_grupoAcesso()
    {

        $this->sql = "SELECT nome_nivel from nivel_acessos where nome_nivel = :nome";

    }

    public function inserir_GrupoAcesso()
    {

        $this->sql = "INSERT INTO nivel_acessos set nome_nivel = :nome, data_cadastro = :data_cadastro";

    }


    //SQL DEPARTAMENTOS

    public function carregar_all_Departamentos(){

        $this->sql = "SELECT * from departamento order by nome_dep";

    }

    //SQL CIDADES

    public function carregar_cidades_Filiais(){

        $this->sql = "SELECT * from cidades order by  cidade";

    }

    public function trocar_senha(){

        $this->sql = "UPDATE usuarios SET senha = :senha where id = :id limit 1 ";

    }

    /**
     * @return mixed
     */
    public function getSql()
    {
        return $this->sql;
    }


}

