<?php

require_once "ConexaoBD.class.php";


abstract class SqlDashCRM extends BD
{

    private $sql;

    public function loadSqlReunioes()
    {
        $this->sql = "SELECT r.id as codReuniao, r.name, r.status, r.date_entered as data_criacao, us.id as cod_Usuario, us.first_name, us.last_name,
	ac.name as cliente, r.date_start as data_reuniao FROM suitecrm_db.meetings r
		inner join suitecrm_db.accounts ac on r.parent_id = ac.id
        inner join suitecrm_db.users us on r.assigned_user_id = us.id
			where r.status in ('Held', 'Planned') and r.deleted = 0 and r.date_start between :inicio and :fim ";
    }

    public function loadSqlOportunidade()
    {
        $this->sql = "SELECT ac.name as cliente, ac.billing_address_city, op.name as descricao, us.title,
        case when op.sales_stage = 'Closed Won' then 'Ganhamos'
	    when op.sales_stage = 'Negotiation/Review' then 'Em Análise'
        when op.sales_stage = 'Proposal/Price Quote' then 'Negociando'
        when op.sales_stage = 'Perception Analysis' then 'Enviada'
        else 'outros' end as  FaseVenda, cs.perfil_c as tipo,
        us.first_name, us.last_name, op.probability, op.amount, op.date_closed
		FROM suitecrm_db.opportunities op
			inner join suitecrm_db.users us on op.assigned_user_id = us.id
            inner join suitecrm_db.accounts_opportunities aop on op.id = aop.opportunity_id
            inner join suitecrm_db.accounts ac on ac.id = aop.account_id
		    inner join suitecrm_db.accounts_cstm cs on ac.id = cs.id_c
			where op.sales_stage not in ('Closed Lost') and date_closed between :inicio and :fim
            and aop.id not in ('dc29c98a-1814-a26d-b8ae-5d2878ab391e') -- ID da oportunidade errada
            order by op.date_closed";
    }

    public function loadSqlVendedores(){

        $this->sql = "SELECT user_name, first_name, last_name, is_admin, title, department
	from suitecrm_db.users where status = 'Active' and employee_status = 'Active' and title = 'Gerente de Negócios'";

    }

    public function loadSqlSomaOportunidades(){
        $this->sql = "SELECT case when op.sales_stage = 'Closed Won' then 'Ganhamos'
	    when op.sales_stage = 'Negotiation/Review' then 'Em Análise'
        when op.sales_stage = 'Proposal/Price Quote' then 'Negociando'
        when op.sales_stage = 'Perception Analysis' then 'Enviada'
        else 'outros' end as  FaseVenda, sum(op.amount) as valor, op.date_closed
		FROM suitecrm_db.opportunities op
			inner join suitecrm_db.users us on op.assigned_user_id = us.id
            inner join suitecrm_db.accounts_opportunities aop on op.id = aop.opportunity_id
            inner join suitecrm_db.accounts ac on ac.id = aop.account_id
			where op.sales_stage not in ('Closed Lost') and date_closed between :inicio and :fim
            and aop.id not in ('dc29c98a-1814-a26d-b8ae-5d2878ab391e') -- ID da oportunidade errada
            group by FaseVenda";
    }

    /**
     * @return mixed
     */
    public function getSql()
    {
        return $this->sql;
    }


}

