<?php
/**
 * Created by PhpStorm.
 * User: suporte
 * Date: 26/11/2018
 * Time: 11:44
 */
require_once "ConexaoBD.class.php";

abstract class SqlDashCac extends BD
{

    private $sql;

    public function loadVendas()
    {

        $this->sql = "select 'Mes Passado' as mes, o.operador, count(*) as Quantidade
		from mk_os o 
		inner join mk_pessoas p on o.cliente = p.codpessoa
		inner join mk_os_classificacao_encerramento enc on o.classificacao_encerramento = enc.codclassifenc
		inner join fr_usuario u on u.usr_login = o.operador
		inner join fr_usuario_grupo ug on u.usr_codigo = ug.usr_codigo
		inner join fr_grupo g on g.grp_codigo = ug.grp_codigo
		inner join mk_conexoes c on o.conexao_associada = c.codconexao
		inner join mk_contratos con on c.contrato = con.codcontrato
		where o.status = '3' and o.tipo_os in (1) and o.classificacao_encerramento = '1' and p.classificacao = 1 
		and g.grp_nome = 'CAC - Vendas' and con.metodo_faturamento::integer = 1
		and o.data_fechamento between (date_trunc('month', current_date) - interval '1 month') and (date_trunc('month', current_date) - interval '1 day')
		group by o.operador, mes
union
select 'Mes Atual' as mes, o.operador, count(*) as Quantidade
		from mk_os o
		inner join mk_pessoas p on o.cliente = p.codpessoa
		inner join mk_os_classificacao_encerramento enc on o.classificacao_encerramento = enc.codclassifenc
		inner join fr_usuario u on u.usr_login = o.operador
		inner join fr_usuario_grupo ug on u.usr_codigo = ug.usr_codigo
		inner join fr_grupo g on g.grp_codigo = ug.grp_codigo
		inner join mk_conexoes c on o.conexao_associada = c.codconexao
		inner join mk_contratos con on c.contrato = con.codcontrato
		where o.status = '3' and o.tipo_os in (1) and o.classificacao_encerramento = '1' and p.classificacao = 1 
		and g.grp_nome = 'CAC - Vendas' and con.metodo_faturamento::integer = 1
		and o.data_fechamento between date_trunc('month', current_date) and (date_trunc('month', current_date + interval '1 month') - interval '1 day')
		group by o.operador, mes
		order by mes";
    }

    function loadFluxo()
    {

        // fluxo antes da implantacao do CRM
        $this->sql = "select * from rn_fluxovendas_web where data <= '2021-06-09'";

    }

    function loadFluxo2()
    {

        // fluxo antes da implantacao do CRM
        $this->sql = 'select * from rn_fluxo_crm';

    }

    /**
     * @return mixed
     */
    public function getSql()
    {
        return $this->sql;
    }


}
