<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 17/12/2018
 * Time: 12:12
 */
require_once "ConexaoBD.class.php";

abstract class SqlEmpresarial extends BD
{

    private $sql;


    public function loadfaturamento()
    {

        $this->sql = "select tab.data_pagto as data, sum(tab.no_mes) as mes, sum(tab.atraso) as atraso from (select x.data_pagto, case when x.pagto = 'NO MÊS' then sum(x.valor_pago) end as no_mes,
case when x.pagto = 'ATRASO MÊS ANT.' then sum(x.valor_pago) end as atraso from (select p.codfatura, p.vlr_liquidacao AS valor_pago, f.data_liquidacao AS data_pagto, CASE WHEN TO_CHAR(COALESCE(f.data_vencimento, p.data_vencimento_original),'yyyymm') < TO_CHAR(f.data_liquidacao,'yyyymm')
THEN 'ATRASO MÊS ANT.' ELSE 'NO MÊS' END AS pagto FROM mk_plano_contas f
 inner join mk_contas_faturadas ft on f.codconta = ft.cd_conta
  inner join mk_faturas p on ft.cd_fatura = p.codfatura
   WHERE f.tipo_conta = 'R' and f.nomenclatura_integracao in ('CNT','MAN','ADE') AND f.liquidado = 'S' and (NOT f.meio_pgto = 6 OR f.meio_pgto IS NULL)
and (NOT p.forma_pgto_liquidacao in (5,2) OR p.forma_pgto_liquidacao IS NULL) and f.valor_lancamento > 0
AND (substr(f.unidade_financeira,1,5) = '03.03' OR (substr(f.unidade_financeira,1,5) in ('01.10','01.11','01.12'))) AND f.data_liquidacao between :data_i and :data_f
group by p.codfatura, f.data_liquidacao, f.data_vencimento)x
group by x.data_pagto, x.pagto order by x.data_pagto)tab group by data Order by data";
    }

    public function loadfaturamento_dt_efetivacao()
    {

        $this->sql = "select tab.data_pagto as data, sum(tab.no_mes) as mes, sum(tab.atraso) as atraso from (select x.data_pagto, case when x.pagto = 'NO MÊS' then sum(x.valor_pago) end as no_mes,
case when x.pagto = 'ATRASO MÊS ANT.' then sum(x.valor_pago) end as atraso from (select p.codfatura, p.vlr_liquidacao AS valor_pago, p.dt_efetivacao_credito AS data_pagto, CASE WHEN TO_CHAR(COALESCE(f.data_vencimento, p.data_vencimento_original),'yyyymm') < TO_CHAR(p.dt_efetivacao_credito,'yyyymm')
THEN 'ATRASO MÊS ANT.' ELSE 'NO MÊS' END AS pagto FROM mk_plano_contas f inner join mk_contas_faturadas ft on f.codconta = ft.cd_conta inner join mk_faturas p on ft.cd_fatura = p.codfatura WHERE f.tipo_conta = 'R' and f.nomenclatura_integracao in ('CNT','MAN','ADE') AND f.liquidado = 'S' and (NOT f.meio_pgto = 6 OR f.meio_pgto IS NULL)
and (NOT p.forma_pgto_liquidacao in (5,2) OR p.forma_pgto_liquidacao IS NULL) and f.valor_lancamento > 0
AND (substr(f.unidade_financeira,1,5) = '03.03' OR (substr(f.unidade_financeira,1,5) in ('01.10','01.11','01.12'))) AND p.dt_efetivacao_credito between :data_i and :data_f
group by p.codfatura, f.data_vencimento)x
group by x.data_pagto, x.pagto order by x.data_pagto)tab group by data Order by data";
    }

//Agrupa por data e unidade financeira
    public function loadfaturamentoEmpresa()
    {

        $this->sql = "select tab.data_pagto as data, tab.unidade_financeira, sum(tab.no_mes) as mes, sum(tab.atraso) as atraso from (select x.data_pagto, x.unidade_financeira, case when x.pagto = 'NO MÊS' then sum(x.valor_pago) end as no_mes,
case when x.pagto = 'ATRASO MÊS ANT.' then sum(x.valor_pago) end as atraso from (select p.vlr_liquidacao AS valor_pago, f.data_liquidacao AS data_pagto, f.unidade_financeira, CASE WHEN TO_CHAR(COALESCE(f.data_vencimento, p.data_vencimento_original),'yyyymm') < TO_CHAR(f.data_liquidacao,'yyyymm')
THEN 'ATRASO MÊS ANT.' ELSE 'NO MÊS' END AS pagto FROM mk_plano_contas f inner join mk_contas_faturadas ft on f.codconta = ft.cd_conta inner join mk_faturas p on ft.cd_fatura = p.codfatura WHERE f.tipo_conta = 'R' and f.nomenclatura_integracao in ('CNT','MAN','ADE') AND f.liquidado = 'S' and (NOT f.meio_pgto = 6 OR f.meio_pgto IS NULL)
and (NOT p.forma_pgto_liquidacao in (5,2) OR p.forma_pgto_liquidacao IS NULL) and f.valor_lancamento > 0
AND (substr(f.unidade_financeira,1,5) = '03.03' OR (substr(f.unidade_financeira,1,5) in ('01.10','01.11','01.12'))) AND f.data_liquidacao between :data_i and :data_f)x
group by x.data_pagto, x.pagto, x.unidade_financeira order by x.data_pagto)tab group by data, unidade_financeira Order by data";
    }

    public function loadfaturamento_Dia()
    {

        $this->sql = "SELECT p.vlr_liquidacao AS valor_pago, f.data_liquidacao AS data_pagto, pe.nome_razaosocial as nome, CASE
WHEN to_char(COALESCE(f.data_vencimento, p.data_vencimento_original)::timestamp with time zone, 'yyyymm'::text) < to_char(f.data_liquidacao::timestamp with time zone, 'yyyymm'::text) THEN 'ATRASO'::text
ELSE 'MES'::text END AS pagto, f.nomenclatura_integracao as tipo, p.codfatura FROM mk_plano_contas f JOIN mk_contas_faturadas ft ON f.codconta = ft.cd_conta JOIN mk_faturas p ON ft.cd_fatura = p.codfatura
JOIN mk_pessoas pe on pe.codpessoa = f.codcliente_codfornecedor WHERE f.tipo_conta = 'R'::bpchar AND f.nomenclatura_integracao in ('CNT','MAN','ADE') AND (NOT f.meio_pgto = 6 OR f.meio_pgto IS NULL) 
AND (NOT p.forma_pgto_liquidacao in (5,2) OR p.forma_pgto_liquidacao IS NULL) AND f.liquidado = 'S'::bpchar AND f.valor_lancamento > 0::double precision AND
((substr(f.unidade_financeira::text, 1, 5) = ANY (ARRAY['03.03'::text])) OR ((substr(f.unidade_financeira,1,2) = '01' AND substr(f.unidade_financeira,1,5) in ('01.10','01.11','01.12'))))
AND f.data_liquidacao between :data_i and :data_f GROUP BY p.vlr_liquidacao, pe.nome_razaosocial, f.data_liquidacao, f.nomenclatura_integracao,
( CASE WHEN to_char(COALESCE(f.data_vencimento, p.data_vencimento_original)::timestamp with time zone, 'yyyymm'::text) < to_char(f.data_liquidacao::timestamp with time zone, 'yyyymm'::text) THEN 'ATRASO'::text
ELSE 'MES'::text END), p.codfatura";

    }

    public function loadfaturamento_Dia2()
    {

        $this->sql = "SELECT p.vlr_liquidacao AS valor_pago, p.dt_efetivacao_credito AS data_pagto, pe.nome_razaosocial as nome, CASE
WHEN to_char(COALESCE(f.data_vencimento, p.data_vencimento_original)::timestamp with time zone, 'yyyymm'::text) < to_char(p.dt_efetivacao_credito::timestamp with time zone, 'yyyymm'::text) THEN 'ATRASO'::text
ELSE 'MES'::text END AS pagto, f.nomenclatura_integracao as tipo, p.codfatura FROM mk_plano_contas f JOIN mk_contas_faturadas ft ON f.codconta = ft.cd_conta JOIN mk_faturas p ON ft.cd_fatura = p.codfatura
JOIN mk_pessoas pe on pe.codpessoa = f.codcliente_codfornecedor WHERE f.tipo_conta = 'R'::bpchar AND f.nomenclatura_integracao in ('CNT','MAN','ADE') AND (NOT f.meio_pgto = 6 OR f.meio_pgto IS NULL) 
AND (NOT p.forma_pgto_liquidacao in (5,2) OR p.forma_pgto_liquidacao IS NULL) AND f.liquidado = 'S'::bpchar AND f.valor_lancamento > 0::double precision AND
((substr(f.unidade_financeira::text, 1, 5) = ANY (ARRAY['03.03'::text])) OR ((substr(f.unidade_financeira,1,2) = '01' AND substr(f.unidade_financeira,1,5) in ('01.10','01.11','01.12'))))
AND p.dt_efetivacao_credito between :data_i and :data_f GROUP BY p.vlr_liquidacao, pe.nome_razaosocial, p.dt_efetivacao_credito, f.nomenclatura_integracao,
( CASE WHEN to_char(COALESCE(f.data_vencimento, p.data_vencimento_original)::timestamp with time zone, 'yyyymm'::text) < to_char(p.dt_efetivacao_credito::timestamp with time zone, 'yyyymm'::text) THEN 'ATRASO'::text
ELSE 'MES'::text END), p.codfatura";

    }

    /**
     * @return mixed
     */
    public function getSql()
    {
        return $this->sql;
    }


}
