<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 14/12/2018
 * Time: 10:12
 */

require_once "ConexaoBD.class.php";

abstract class SqlFinanceiro extends BD
{
    private $sql;

    public function loadCR()
    {
        $this->sql = "--CR TABELA ANTIGA, INATIVAR EM JULHO
select  data_lancamento::date as data, vlr_lancamento as total, 
case when ponto_recebimento = 31 then 'CR' when ponto_recebimento = 56 then 'CR - CARTAO' when ponto_recebimento = 57 then 'CR - PAGSEGURO'
when ponto_recebimento = 58 THEN 'CR - NAOIDENTIFICADO' END AS ponto_recebimento from mk_fluxo_financeiro where ponto_recebimento in (31,56,57,58)
and data_lancamento >= '01-01-2022' group by data, total, ponto_recebimento
union
--CR SOMANDO O TOTAL DE RECEBIMENTOS
select cr.data, sum(cr.valor) as valor, cr.ponto_recebimento from (select data_hora::date as data, sum(cx.valor) as valor, 1 as qtde, case when cx.categoria in (2,3) then 'CR' else 'SEM CATEGORIA' END as ponto_recebimento
 from mk_conciliacao_leituras con 
	inner join mk_conciliacao_extrato cx on con.codconcilialeitura = cx.cd_leitura 
	inner join mk_conciliacao_extrato_categorizacao cat on cx.categoria = cat.cd_categoria
	where con.cd_profile in (19,3,24,23,18,11,32,34,44,45,46,55,57,58,59,60,61,62,63,64,65,68,69,70,71,72,73,74,75,76,77,79,80,81,82,83,84,85,86,90,91,94,93,95,96,97,103,104,105) and con.conciliacao_ok = 'S' and cx.tipo_lcto = 'C' and cx.conciliado = 'S' and cx.categoria in (2,3) 
	group by con.data_hora, ponto_recebimento) cr
	where cr.data >= '01-01-2022'
	group by cr.data, cr.ponto_recebimento
union
-- CR SOMANDO PIX
select cr.data as data, sum(cr.valor) as valor, cr.ponto_recebimento from (select data_hora::date as data, sum(cx.valor) as valor, 1 as qtde, case when cx.categoria = 7 then 'CR - PIX'
else 'SEM CATEGORIA' END as ponto_recebimento
 from mk_conciliacao_leituras con 
	inner join mk_conciliacao_extrato cx on con.codconcilialeitura = cx.cd_leitura 
	--inner join mk_conciliacao_extrato_categorizacao cat on cx.categoria = cat.cd_categoria
	where con.cd_profile in (19,3,24,23,18,11,32,34,44,45,46,55,57,58,59,60,61,62,63,64,65,68,69,70,71,72,73,74,75,76,77,79,80,81,82,83,84,85,86,90,91,94,93,95,96,97,103,104,105) and cx.tipo_lcto = 'C' --and con.conciliacao_ok = 'S'
	and cx.categoria in (7)
	group by con.data_hora, ponto_recebimento) cr
	where cr.data >= '01-01-2023'
	group by cr.data, cr.ponto_recebimento	
union
-- CR SOMANDO CAIXA FECHADO
select cx.data as data, sum(cx.valor) as valor, 'CR - CAIXA'::text as ponto_recebimento from mk_movimentacao_caixa_fechamentos f
inner join mk_movimentacao_caixa cx on cx.id_caixa = f.hash_identificacao  where f.conciliado = 'S' and cx.tipo = 'C' and cx.estornado = 'N' and cx.credor_devedor is not null and cx.data >= '01-01-2022'
group by data, ponto_recebimento
union
--CR SOMANDO CARTAO E PAGSEURO
select cr.data as data, sum(cr.valor) as valor, cr.ponto_recebimento from (select data_hora::date as data, sum(cx.valor) as valor, 1 as qtde, case when cx.categoria = 4 then 'CR - PAGSEGURO'
when cx.categoria = 5 then 'CR - CARTAO' else 'SEM CATEGORIA' END as ponto_recebimento
 from mk_conciliacao_leituras con 
	inner join mk_conciliacao_extrato cx on con.codconcilialeitura = cx.cd_leitura 
	inner join mk_conciliacao_extrato_categorizacao cat on cx.categoria = cat.cd_categoria
	where con.cd_profile in (19,3,24,23,18,11,32,34,44,45,46,55,57,58,59,60,61,62,63,64,65,68,69,70,71,72,73,74,75,76,77,79,80,81,82,83,84,85,86,90,91,94,93,95,96,97,103,104,105) and con.conciliacao_ok = 'S' and cx.tipo_lcto = 'C' and cx.conciliado = 'S' and cx.categoria in (4,5) 
	group by con.data_hora, ponto_recebimento) cr
	where cr.data >= '01-01-2022'
	group by cr.data, cr.ponto_recebimento	
order by data";
    }

    /**
     * @return mixed
     */
    public function getSql()
    {
        return $this->sql;
    }


}
