<?php
/**
 * Created by PhpStorm.
 * User: suporte
 * Date: 09/01/2019
 * Time: 09:55
 */

require_once "ConexaoBD.class.php";

abstract class SqlMaps extends BD
{

    private $sql;

    // CARREGA TODOS OS LOGRADOUROS DA TABELA LOGRADOUROS_FIBRA DO REPORTS
    public function load_All_address_fibra(){

        $sql = "SELECT * FROM logradouros_fibra";

        $this->sql = $sql;
    }

    // CARREGA UM UNICO LOGRADOURO DA TABELA LOGRADOUROS_FIBRA DO REPORTS
    public function load_address_fibra(){

        $sql = "Select * from logradouros_fibra where logradouro = :logradouro and bairro = :bairro and cidade = :cidade";

        $this->sql = $sql;

    }

    public function load_edit(){

        $sql = "SELECT * FROM logradouros_fibra WHERE id = :id";

        $this->sql = $sql;
    }

    public function insert_address(){

        $sql = "INSERT INTO logradouros_fibra set cidade = :cidade, bairro = :bairro, logradouro = :logradouro, lat = :lat, lng = :lng";

        $this->sql = $sql;
    }


    public function delete_address(){

        $sql = "DELETE FROM logradouros_fibra where id = :id limit 1";

        $this->sql = $sql;
    }


    public function update_address(){

        $sql = "UPDATE logradouros_fibra set cidade = :cidade, bairro = :bairro, logradouro = :logradouro, lat = :lat, lng = :lng where id= :id";

        $this->sql = $sql;
    }


    // QUERYS REFERENTES A MARKERS
    public function load_markers(){

        $sql = "SELECT * FROM markers";

        $this->sql = $sql;
    }


    public function load_edit_markers($id){

        $sql = "SELECT * FROM markers WHERE id in ($id) ORDER BY id DESC";

        $this->sql = $sql;
    }

    public function delete_markers($id){

        $sql = "DELETE FROM markers where id in ($id) ";

        $this->sql = $sql;
    }

    public function delete_markers_conexao($array){

        $sql = "DELETE FROM markers where codconexao in ($array)";

        $this->sql = $sql;
    }

    public function insert_markers(){

        $sql = "INSERT INTO markers set name = :name, address = :address, bairro = :bairro, lat = :lat, lng = :lng,
                type = :type, codcli = :codcli, codconexao = :codconexao, number = :number, cidade = :cidade, estado = :estado, uf = :uf";

        $this->sql = $sql;

    }

    // Carrega Todos os Cliente Fibra no MK
    public function load_All_Clientes(){

        $sql = "select p.codpessoa, p.nome_razaosocial as cliente, x.codconexao, c.codcontrato, c.unidade_financeira as tipo, c.adesao, x.logradouro, x.bairro as codbairro, l.logradouro as endereco, x.numero, b.bairro, ci.cidade, est.nomeestado, est.siglaestado from mk_conexoes x 
inner join mk_contratos c on x.contrato = c.codcontrato inner join mk_pessoas p on p.codpessoa = c.cliente left join mk_logradouros l on l.codlogradouro = x.logradouro
left join mk_bairros b on b.codbairro = x.bairro left join mk_cidades ci on ci.codcidade = x.cidade left join mk_estados est on est.codestado = x.uf 
where c.cancelado = 'N' and c.metodo_faturamento::integer = 1 and p.classificacao = 1 and x.tipo_conexao = 1 and (c.suspenso = 'N' or c.suspenso is null) and x.conexao_bloqueada = 'N' 
group by c.codcontrato, p.codpessoa, x.codconexao, x.logradouro, l.logradouro, x.numero, b.bairro, ci.cidade, x.bairro, est.nomeestado, est.siglaestado 
order by p.nome_razaosocial";

        $this->sql = $sql;
    }

    // Carrega um unico cliente fibra no MK
    public function load_Cliente(){

        $sql = "select p.codpessoa, p.nome_razaosocial as cliente, x.codconexao, c.codcontrato, c.adesao, c.unidade_financeira as tipo, x.logradouro, x.bairro as codbairro, l.logradouro as endereco, p.numero, b.bairro, ci.cidade from mk_conexoes x 
inner join mk_contratos c on x.contrato = c.codcontrato inner join mk_pessoas p on p.codpessoa = c.cliente left join mk_logradouros l on l.codlogradouro = x.logradouro
left join mk_bairros b on b.codbairro = x.bairro left join mk_cidades ci on ci.codcidade = x.cidade where c.cancelado = 'N' and c.metodo_faturamento::integer = 1 and p.classificacao = 1 and x.tipo_conexao = 1 and (c.suspenso = 'N' or c.suspenso is null) and x.conexao_bloqueada = 'N' and x.codconexao = :conexao
group by c.codcontrato, p.codpessoa, x.codconexao, x.logradouro, l.logradouro, p.numero, b.bairro, ci.cidade, x.bairro
order by p.nome_razaosocial limit 1";

        $this->sql = $sql;
    }

    // Carrega todas as conexoes da tabela markers
    public function getALL_Conexao_Markers(){

        $sql = "select codconexao from markers";

        $this->sql = $sql;
    }

    // carrega uma unica conexao na tabela markers
    public function get_Conexao_Markers(){

        $sql = "select * from markers where codconexao = :conexao";

        $this->sql = $sql;
    }


    // deleta uma conexao da tabela markers
    public function delete_Conexao(){

        $sql = "delete from markers where codconexao = :conexao";

        $this->sql = $sql;

    }


    /**
     * @return mixed
     */
    public function getSql()
    {
        return $this->sql;
    }



}
