<?php
/**
 * Created by PhpStorm.
 * User: suporte
 * Date: 19/10/2018
 * Time: 15:24
 */
require_once "ConexaoBD.class.php";

abstract class SqlNotificacoesMK extends BD
{
    private $sql;


    public function loadNotificacoes()
    {

        $this->sql = "select a.dt_abertura as data, p.nome_razaosocial as nome, a.operador_abertura as operador, 'Ticket Pendente' as tipo, 
a.cliente_cadastrado as codigo, 'Administrador, Supervisor, Cancelamento, Vendas, Supervisao CAC, Pos Venda' as grupo from mk_atendimento a 
inner join fr_usuario u on u.usr_login =  a.operador_abertura inner join fr_usuario_grupo ug on u.usr_codigo = ug.usr_codigo
inner join fr_grupo g on ug.grp_codigo = g.grp_codigo inner join mk_os o on a.codatendimento = o.cd_atendimento 
inner join mk_pessoas p on p.codpessoa = a.cliente_cadastrado inner join mk_ate_processos pro on pro.codprocesso = a.cd_processo 
where a.finalizado = 'N' and a.situacao = 'I' and g.grp_nome in ('CAC - Cancelamento') and o.encerrado = 'S' 
and a.dt_abertura <= current_date - interval '5 days'
union
--tickets pendetes mais de 5 dias Vendas
select a.dt_abertura as data, p.nome_razaosocial as nome, a.operador_abertura as operador, 'Ticket Pendente' as tipo, a.cliente_cadastrado as codigo, 
'Administrador, Supervisor, Vendas, Supervisao CAC, Vendas PJ, Vendas Externo' as grupo from mk_atendimento a inner join fr_usuario u on u.usr_login =  a.operador_abertura
inner join fr_usuario_grupo ug on u.usr_codigo = ug.usr_codigo inner join fr_grupo g on ug.grp_codigo = g.grp_codigo
inner join mk_pessoas p on p.codpessoa = a.cliente_cadastrado inner join mk_ate_processos pro on pro.codprocesso = a.cd_processo
WHERE a.cliente_cadastrado not in (select o.cliente from mk_os o left join mk_ate_os atos on o.codos = atos.cd_os inner join 
(select  a.cliente_cadastrado as codigo, a.codatendimento as ticket from mk_atendimento a inner join fr_usuario u on u.usr_login =  a.operador_abertura
inner join fr_usuario_grupo ug on u.usr_codigo = ug.usr_codigo inner join fr_grupo g on ug.grp_codigo = g.grp_codigo inner join mk_ate_processos pro on pro.codprocesso = a.cd_processo
and a.finalizado = 'N' and a.situacao = 'I' and g.grp_nome = 'CAC - Vendas' and a.dt_abertura <= current_date - interval '5 days')tick on tick.ticket = atos.cd_atendimento 
where (o.encerrado = 'N' OR data_fechamento = current_date)) and a.finalizado = 'N' and a.situacao = 'I' and g.grp_nome = 'CAC - Vendas' and a.dt_abertura <= current_date - interval '5 days'
union
--contrato sem Unidade Financeira
select c.adesao as data,  p.nome_razaosocial as nome, c.operador, 'Sem UF Contrato' as tipo, c.codcontrato as codigo, 'Administrador' as grupo  
from mk_contratos c inner join mk_pessoas p on c.cliente = p.codpessoa where c.unidade_financeira is null and c.cancelado = 'N'
union
--TECNICO DE ENCERRAMENTO INCORRETO
select data_fechamento as data, us.usr_login as tecnicos, mk_os.operador_fechamento, 'Tecnico Incorreto' as tipo,
codos, 'Administrador, Supervisor' as grupo from mk_os 
	left join mk_compromissos a on a.cd_integracao = mk_os.codos
	inner join mk_pessoas p on p.codpessoa = mk_os.cliente
	inner join fr_usuario us on us.usr_codigo = coalesce(mk_os.operador_fech_tecnico::integer, a.cd_operador) 
where p.classificacao = 1 and data_fechamento >= '01-04-2019'
and coalesce(mk_os.operador_fech_tecnico::integer, a.cd_operador) not in (1457,1456,1451,1452,1434,1433,1432,1405,1369,1370,1247,1250,1252,1253,1255,1245,1249,1242,1257,1254,1246,1243,1251,1371,1256,1244,1281,1248,1304,1305,32,1315,1316,1319,1320,1327,1336,1352,1353,1354,1355,1356,1359,1414)
group by codos, data, a.cd_operador, p.codpessoa, mk_os.classificacao_encerramento, us.usr_login
union
select grupos.adesao, grupos.nome_razaosocial, grupos.operador, 'Grupo/SLA Pendente' as tipo, grupos.codcontrato, 'Administrador, Supervisor, Vendas, Supervisao CAC' as grupo from (
-- GRUPO/SLA RESIDENCIAL PENDENTE 
select c.adesao, p.nome_razaosocial, c.operador, c.codcontrato from mk_contratos c 
	inner join mk_pessoas p on c.cliente = p.codpessoa 
	where c.cancelado = 'N' and c.suspenso = 'N' and (p.grupo_atendimento not in (3) or c.cd_tabela_sla not in (2)) and c.unidade_financeira in ('03.06.01', '03.01.01','03.06.24','03.01.03')
union
-- GRUPO/SLA COMERCIAL PENDENTE 
select c.adesao, p.nome_razaosocial, c.operador, c.codcontrato  from mk_contratos c 
	inner join mk_pessoas p on c.cliente = p.codpessoa 
	where c.cancelado = 'N' and c.suspenso = 'N' and (p.grupo_atendimento not in (4) or c.cd_tabela_sla not in (3)) and substr(c.unidade_financeira,1,5) = '03.02'
union
-- GRUPO/SLA EMPRESARIAL PENDENTE 
select c.adesao, p.nome_razaosocial, c.operador, c.codcontrato  from mk_contratos c 
	inner join mk_pessoas p on c.cliente = p.codpessoa 
	where c.cancelado = 'N' and c.suspenso = 'N' and (p.grupo_atendimento not in (5) or c.cd_tabela_sla not in (4)) and substr(c.unidade_financeira,1,5) = '03.03' and p.codpessoa not in (91265,91320,91322)
union
-- GRUPO/SLA ISP PENDENTE 
select c.adesao, p.nome_razaosocial, c.operador, c.codcontrato  from mk_contratos c 
	inner join mk_pessoas p on c.cliente = p.codpessoa 
	where c.cancelado = 'N' and c.suspenso = 'N' and (p.grupo_atendimento not in (8) or c.cd_tabela_sla not in (5)) and substr(c.unidade_financeira,1,5) = '03.08' )grupos
union
--contratos com metodo de faturamento errado
select c.adesao, p.nome_razaosocial as nome, c.operador, 'Metodo Fat Errado' as tipo, c.codcontrato as codigo, 'Administrador' as grupo
from mk_contratos c inner join mk_pessoas p on c.cliente = p.codpessoa inner join mk_sla s on c.cd_tabela_sla = s.codsla
where c.metodo_faturamento::integer  = 2 and c.cancelado = 'N' and p.classificacao = 1 and c.cd_tabela_sla not in (4,5) and c.codcontrato not in (27648,37560)
union
-- contratos faturados mas sem parcelas e sem renovacao automatica
select c.adesao, p.nome_razaosocial as nome, c.operador, 'Contrato sem Parcela' as tipo , c.codcontrato as codigo, 'Administrador' as grupo
from mk_contratos c inner join mk_pessoas p on c.cliente = p.codpessoa left join mk_plano_contas pl on c.codcontrato = pl.codvinculado 
where c.ignora_renovacao_auto = 'S' and c.cancelado = 'N' and not c.metodo_faturamento::integer = 3 and  c.unidade_financeira not in ('03.01.01.02', '03.03.04') and p.classificacao = 1 and pl.codvinculado is null
union	
--Os sem tickets
select o.data_abertura as data, p.nome_razaosocial as nome, o.operador, 'Sem Username OS' as tipo, o.codos as codigo, 'Administrador, Supervisor' as grupo 
from mk_os o inner join mk_pessoas p on o.cliente = p.codpessoa where o.conexao_associada is null and o.tipo_os in (1,27,3,5,32) and o.status in (2,3) and classificacao_encerramento not in (69) and o.cliente not in (79257,98872)
and o.data_abertura >= '28-10-2019'
union
--Erro CONEXÃO BLOQUEADA, INSTALAÇÃO CONCLUIDA COM SUCESSO
select o.data_abertura, p.nome_razaosocial, o.operador, 'Inst Bloqueada' as tipo, x.codconexao as codigo, 'Administrador, Supervisor' as grupo   
	from mk_os o
	left join mk_conexoes x on x.codconexao = o.conexao_associada
	left join mk_contratos c on c.codcontrato = x.contrato
	inner join mk_pessoas p on p.codpessoa = o.cliente
	where tipo_os = 1 and encerrado = 'S' and classificacao_encerramento = 1 and c.metodo_faturamento::integer != 3 and not( c.suspenso = 'N' or c.suspenso is null) and  x.motivo_bloqueio = 3 
	and data_fechamento between date_trunc('month', current_date) and date_trunc('month', current_date) + interval '1 month' - interval '1 day' 
union
--ERRO REGRA DE BLOQUEIO
select c.adesao as data, p.nome_razaosocial as nome, c.operador, 'Erro de Regra Bloqueio' as Tipo, c.codcontrato as codigo, 'Administrador, Supervisor, Vendas, Supervisao CAC' as grupo
from mk_contratos c
inner join mk_pessoas p on p.codpessoa = c.cliente
where c.adesao >= '2020-10-13' and c.cancelado = 'N' and (substr(c.unidade_financeira,1,5) = '03.06' or c.unidade_financeira in ('03.02.06','03.02.06.00')) and c.cd_regua_configuracao not in ('1010', '1011', '1013', '1014')
union
select c.adesao as data, p.nome_razaosocial as nome, c.operador, 'Erro de Regra Bloqueio' as Tipo, c.codcontrato as codigo, 'Administrador, Supervisor, Vendas, Supervisao CAC' as grupo
from mk_contratos c
inner join mk_pessoas p on p.codpessoa = c.cliente
where c.adesao >= '2020-10-13' and c.cancelado = 'N' and substr(c.unidade_financeira, 1,5) in ('03.01') and c.unidade_financeira not in ('03.02.02','03.03.04','03.01.01.02') and c.cd_regua_configuracao not in ('2', '4', '1013', '1014')
union
-- OS instalacao com encerramento incorreto
select o.data_fechamento as data, p.nome_razaosocial as nome, o.operador, 'Encerramento Incorreto' as tipo, o.codos as codigo, 
'Administrador, Supervisor, Coordenadores' as grupo from mk_os o inner join mk_pessoas p on o.cliente = p.codpessoa
left join mk_os_classificacao_encerramento enc on o.classificacao_encerramento = enc.codclassifenc where status = '3' and tipo_os = '1' 
and (not o.classificacao_encerramento in (1,59,8,52,66,67,69) or o.classificacao_encerramento is null) and data_fechamento >= '2018-01-01'
union
--Os pendente de agendamento a mais de 5 dias
select to_date(to_char(coalesce(max(c.com_inicio),o.data_abertura),'dd/mm/yyyy'::text), 'dd/mm/yyyy'::text) as data, p.nome_razaosocial as nome,
case when o.tipo_os = 1 then 'Instalação' when o.tipo_os = 5 then 'Retirada' when o.tipo_os = 3 then 'Transferência' when o.tipo_os = 27 then 'Migração'
when o.tipo_os = 4 then 'Upgrade' when o.tipo_os in (2,32) then 'Manutenção' when o.tipo_os = 62 then 'Canc Inativos' when o.tipo_os is null then 'Sem tipo' else 'Outros' end as status, 'OS Pendente'::text as tipo, o.codos as codigo,
'Administrador, Supervisor' as grupo from mk_os o inner join mk_pessoas p on o.cliente = p.codpessoa left join mk_compromissos c on  c.cd_integracao = o.codos 
where o.encerrado = 'N' and coalesce(c.com_inicio,o.data_abertura) < current_date - INTERVAL '5 days' group by p.codpessoa, p.nome_razaosocial, o.codos, o.status  
UNION
--OS pendente de agendamento a mais de 1 dia
select to_date(to_char(coalesce(max(c.com_inicio),o.data_abertura),'dd/mm/yyyy'::text), 'dd/mm/yyyy'::text) as data, p.nome_razaosocial as nome,
case when o.tipo_os = 1 then 'Instalação' when o.tipo_os = 5 then 'Retirada' when o.tipo_os = 3 then 'Transferência' when o.tipo_os = 27 then 'Migração'
when o.tipo_os = 4 then 'Upgrade' when o.tipo_os in (2,32) then 'Manutenção' when o.tipo_os = 62 then 'Canc Inativos' when o.tipo_os is null then 'Sem tipo' else 'Outros' end as status, 'OS Pendente'::text as tipo, o.codos as codigo, 
'Coordenadores' as grupo from mk_os o inner join mk_pessoas p on o.cliente = p.codpessoa left join mk_compromissos c on  c.cd_integracao = o.codos 
where o.encerrado = 'N' and not o.tipo_os = 5 and coalesce(c.com_inicio,o.data_abertura) < current_date group by p.codpessoa, p.nome_razaosocial, o.codos, o.status   
UNION
--OS pendente de agendamento a mais de 1 dia - Cancelamento 
select to_date(to_char(coalesce(max(c.com_inicio),o.data_abertura),'dd/mm/yyyy'::text), 'dd/mm/yyyy'::text) as data, p.nome_razaosocial as nome,
o.operador, 'OS Pendente'::text as tipo, o.codos as codigo, 
'Cancelamento, Corporativo, Coordenadores' as grupo from mk_os o inner join mk_pessoas p on o.cliente = p.codpessoa left join mk_compromissos c on  c.cd_integracao = o.codos 
where o.encerrado = 'N' and o.tipo_os = 5 and coalesce(c.com_inicio,o.data_abertura) < current_date group by p.codpessoa, p.nome_razaosocial, o.codos, o.status
UNION 
select current_date as data, a.operador_abertura as nome, a.operador_abertura as operador, 'Ticket Aprimorar' as tipo, count(a.codatendimento) as codigo, 'Administrador, Supervisor'::text as grupo
 from mk_atendimento a inner join mk_ate_processos p on a.cd_processo = p.codprocesso 
	where a.situacao = 'I' and cd_processo = 8 and operador_abertura = 'aprimorar'
	and dt_abertura between date_trunc('month', current_date) and (date_trunc('month', current_date + interval '1 month') - interval '1 day') 
	group by nome, a.operador_abertura, a.cd_processo
order by data";
    }

    /**
     * @return mixed
     */
    public function getSql()
    {
        return $this->sql;
    }


}
