<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 17/12/2018
 * Time: 12:12
 */
require_once "ConexaoBD.class.php";

abstract class SqlProjetos extends BD
{

    private $sql;


    public function loadCarteira($codprojeto)
    {

        $this->sql = "select pro.codprojeto, pro.nome as projeto, pro.valor_orcado as valor, case 
when pro.situacao = 3 THEN 'CONCLUIDO' when pro.situacao = 1 THEN 'INICIADO'
ELSE 'PARADO' END AS statusprojeto, arm.codarmario as codarmario, arm.descricao as armario, cx.identificacao as cto, p.codpessoa, p.nome_razaosocial, l.logradouro, b.bairro, 
ci.cidade, cd.descricao as condominio, c.unidade_financeira, c.vlr_renovacao, pl.descricao as plano, c.adesao, x.codconexao, x.conexao_bloqueada as bloqueado, os.tipo_os  
from mk_fiber_projeto pro -- busca projetos criados 
        inner join mk_fiber_caixa cx on cx.cd_projeto = pro.codprojeto -- vincula um projeto com as CTO
        inner join mk_fiber_postes pt on cx.cd_poste = pt.codposte -- vincula a caixa ao poste
        inner join mk_fiber_splitter spli on cx.codcaixa = spli.cd_caixa --vincula as CTO com as splitter
        inner join mk_conexoes x on spli.codsplitter = x.cd_splitter -- vincula uma splitter com uma conexao
        left join (select cliente, conexao_associada, tipo_os, max(codos) as codos from mk_os where tipo_os in (1,27) and classificacao_encerramento = 1
        group by cliente, conexao_associada, tipo_os)os on x.codconexao = os.conexao_associada
        inner join mk_planos_acesso pl on x.codplano_acesso = pl.codplano -- vincula conexao ao plano de acesso
        left join mk_fiber_armarios arm on arm.cd_projeto = pro.codprojeto -- vincula um projeto ao armario
        inner join mk_pessoas p on p.codpessoa = x.codcliente -- vincula conexao com cadastro de pessoas
        inner join mk_contratos c on x.contrato = c.codcontrato -- vincula conexao com contrato
        left join mk_condominios cd on x.condominio = cd.codcondominio -- vincula conexao com condominio se houver
        inner join mk_logradouros l on x.logradouro = l.codlogradouro -- vincula logradouro com o endereço do cadastro
        inner join mk_bairros b on x.bairro = b.codbairro -- vincula bairro com o endereço do cadastro
        inner join mk_cidades ci on x.cidade = ci.codcidade -- vincula cidade com o endereço do cadastro
  where c.cancelado = 'N' and (c.suspenso = 'N' or c.suspenso is null) and pro.codprojeto in ($codprojeto) and x.tipo_conexao = 1
  order by p.nome_razaosocial";

    }

    public function loadfaturamentoProjeto($codprojeto, $dt_projeto)
    {
        $this->sql = "SELECT tab.data_pagto AS data, sum(tab.no_mes) AS mes, sum(tab.atraso) AS atraso FROM ( SELECT x.data_pagto, CASE WHEN x.pagto = 'NO MÊS'::text THEN sum(x.valor_pago) ELSE NULL::double precision
END AS no_mes, CASE WHEN x.pagto = 'ATRASO MÊS ANT.'::text THEN sum(x.valor_pago) ELSE NULL::double precision END AS atraso FROM ( SELECT p.vlr_liquidacao AS valor_pago, f.data_liquidacao AS data_pagto, CASE
WHEN to_char(COALESCE(f.data_vencimento_original, f.data_vencimento)::timestamp with time zone, 'yyyymm'::text) < to_char(f.data_liquidacao::timestamp with time zone, 'yyyymm'::text) THEN 'ATRASO MÊS ANT.'::text
ELSE 'NO MÊS'::text END AS pagto, p.codfatura 
FROM mk_plano_contas f 
JOIN mk_contas_faturadas ft ON f.codconta = ft.cd_conta
JOIN mk_faturas p ON ft.cd_fatura = p.codfatura
JOIN mk_conexoes x ON x.codcliente = f.codcliente_codfornecedor -- vincula conexao ao plano de contas
JOIN mk_fiber_splitter split on split.codsplitter = x.cd_splitter -- vincula a conexao com o splitter
JOIN mk_fiber_caixa cx on cx.codcaixa = split.cd_caixa --vincula as CTO com as splitter
JOIN mk_fiber_projeto pro on cx.cd_projeto = pro.codprojeto -- vincula um projeto com as CTO
WHERE pro.codprojeto in ($codprojeto) and x.tipo_conexao = 1 and f.tipo_conta = 'R'::bpchar AND f.nomenclatura_integracao in ('CNT','MAN', 'ADE') AND 
(NOT f.meio_pgto = 6 OR f.meio_pgto IS NULL) AND (NOT p.forma_pgto_liquidacao in (5,2) OR p.forma_pgto_liquidacao IS NULL) 
AND f.liquidado = 'S'::bpchar AND f.valor_lancamento > 0::double precision
AND f.data_liquidacao between :data_i and :data_f and f.data_liquidacao >= '$dt_projeto' GROUP BY p.vlr_liquidacao, f.data_liquidacao, 
( CASE WHEN to_char(COALESCE(f.data_vencimento_original, f.data_vencimento)::timestamp with time zone, 'yyyymm'::text) < to_char(f.data_liquidacao::timestamp with time zone, 'yyyymm'::text)
THEN 'ATRASO MÊS ANT.'::text ELSE 'NO MÊS'::text END), p.codfatura) x  
GROUP BY x.data_pagto, x.pagto ORDER BY x.data_pagto) tab GROUP BY tab.data_pagto ORDER BY tab.data_pagto";

    }

    public function loadfaturamentoprojetoDia($codprojeto, $dt_projeto)
    {

        $this->sql = "SELECT p.vlr_liquidacao AS valor_pago, f.data_liquidacao AS data_pagto, pe.nome_razaosocial as nome, CASE
WHEN to_char(COALESCE(f.data_vencimento_original, f.data_vencimento)::timestamp with time zone, 'yyyymm'::text) < to_char(f.data_liquidacao::timestamp with time zone, 'yyyymm'::text) THEN 'ATRASO'::text
ELSE 'MES'::text END AS pagto, f.nomenclatura_integracao as tipo, p.codfatura 
FROM mk_plano_contas f 
JOIN mk_contas_faturadas ft ON f.codconta = ft.cd_conta
JOIN mk_faturas p ON ft.cd_fatura = p.codfatura
JOIN mk_conexoes x ON x.codcliente = f.codcliente_codfornecedor -- vincula conexao ao plano de contas
JOIN mk_pessoas pe ON pe.codpessoa = f.codcliente_codfornecedor -- vincula plano de contas a cadastro de pessoas
JOIN mk_fiber_splitter split on split.codsplitter = x.cd_splitter -- vincula a conexao com o splitter
JOIN mk_fiber_caixa cx on cx.codcaixa = split.cd_caixa --vincula as CTO com as splitter
JOIN mk_fiber_projeto pro on cx.cd_projeto = pro.codprojeto -- vincula um projeto com as CTO
WHERE pro.codprojeto in ($codprojeto) and x.tipo_conexao = 1 and f.tipo_conta = 'R'::bpchar AND f.nomenclatura_integracao in ('CNT','MAN', 'ADE') AND 
(NOT f.meio_pgto = 6 OR f.meio_pgto IS NULL) AND (NOT p.forma_pgto_liquidacao in (5,2) OR p.forma_pgto_liquidacao IS NULL) 
AND f.liquidado = 'S'::bpchar AND f.valor_lancamento > 0::double precision
AND f.data_liquidacao between :data_i and :data_f and f.data_liquidacao >= '$dt_projeto' GROUP BY p.vlr_liquidacao, pe.nome_razaosocial, f.data_liquidacao, f.nomenclatura_integracao, 
( CASE WHEN to_char(COALESCE(f.data_vencimento_original, f.data_vencimento)::timestamp with time zone, 'yyyymm'::text) < to_char(f.data_liquidacao::timestamp with time zone, 'yyyymm'::text)
THEN 'ATRASO'::text ELSE 'MES'::text END), p.codfatura";
    }

    public function searchcarteiraMes()
    {


        $this->sql = "select p.projeto, m.mes, c.total, c.id, c.codprojeto, c.cod_mes, c.ano  from carteira_projetos c INNER JOIN projetos p on c.codprojeto = p.id_projeto
                inner join mes m on c.cod_mes = m.id where m.mes = :mes and p.id_projeto = :projeto and c.ano = :ano";


    }

    public function inserebaseProjeto()
    {


        $this->sql = "INSERT INTO carteira_projetos set cod_mes = :mes, total = :total, ano = :ano, codprojeto = :projeto";


    }

    public function updateBaseProjeto()
    {

        $this->sql = "update carteira_projetos set total = :total where id = :id";
    }

    public function loadCarteiraAnual()
    {

        $this->sql = "select c.total, m.mes, m.id, c.ano from carteira_projetos c INNER JOIN projetos p on c.codprojeto = p.id_projeto
INNER JOIN mes m ON c.cod_mes = m.id WHERE p.id_projeto = :projeto order by m.id";

    }

    public function loadFaturamentoTotalBD($codprojeto, $dt_projeto)
    {


        $this->sql = "SELECT Date_Part('month', f.data_liquidacao) As mes, Date_Part('year', f.data_liquidacao) || '' as ano, 
cast(sum(round(cast(@p.vlr_liquidacao as numeric),2)) as double precision) As valor_pago
FROM mk_plano_contas f 
JOIN mk_contas_faturadas ft ON f.codconta = ft.cd_conta
JOIN mk_faturas p ON ft.cd_fatura = p.codfatura
JOIN mk_conexoes x ON x.codcliente = f.codcliente_codfornecedor -- vincula conexao ao plano de contas
JOIN mk_fiber_splitter split on split.codsplitter = x.cd_splitter -- vincula a conexao com o splitter
JOIN mk_fiber_caixa cx on cx.codcaixa = split.cd_caixa --vincula as CTO com as splitter
JOIN mk_fiber_projeto pro on cx.cd_projeto = pro.codprojeto -- vincula um projeto com as CTO
WHERE pro.codprojeto in ($codprojeto) and x.tipo_conexao = 1 and f.tipo_conta = 'R'::bpchar AND f.nomenclatura_integracao in ('CNT','MAN', 'ADE') AND 
(NOT f.meio_pgto = 6 OR f.meio_pgto IS NULL) AND (NOT p.forma_pgto_liquidacao in (5,2) OR p.forma_pgto_liquidacao IS NULL) 
AND f.liquidado = 'S'::bpchar AND f.valor_lancamento > 0::double precision and f.data_liquidacao >= '$dt_projeto' GROUP BY mes, ano order by ano, mes";

    }

    public function loadFaturamentoTotalTipo_osBD($codprojeto, $dt_projeto){

        $this->sql = "SELECT os.tipo_os, 
cast(sum(round(cast(@p.vlr_liquidacao as numeric),2)) as double precision) As valor_pago
FROM mk_plano_contas f 
JOIN mk_contas_faturadas ft ON f.codconta = ft.cd_conta
JOIN mk_faturas p ON ft.cd_fatura = p.codfatura
JOIN mk_conexoes x ON x.codcliente = f.codcliente_codfornecedor -- vincula conexao ao plano de contas
left join (select cliente, conexao_associada, tipo_os, max(codos) as codos from mk_os where tipo_os in (1,27) and classificacao_encerramento = 1
group by cliente, conexao_associada, tipo_os)os on x.codconexao = os.conexao_associada
JOIN mk_fiber_splitter split on split.codsplitter = x.cd_splitter -- vincula a conexao com o splitter
JOIN mk_fiber_caixa cx on cx.codcaixa = split.cd_caixa --vincula as CTO com as splitter
JOIN mk_fiber_projeto pro on cx.cd_projeto = pro.codprojeto -- vincula um projeto com as CTO
WHERE pro.codprojeto in ($codprojeto) and x.tipo_conexao = 1 and f.tipo_conta = 'R'::bpchar AND f.nomenclatura_integracao in ('CNT','MAN', 'ADE') AND 
(NOT f.meio_pgto = 6 OR f.meio_pgto IS NULL) AND (NOT p.forma_pgto_liquidacao in (5,2) OR p.forma_pgto_liquidacao IS NULL) 
AND f.liquidado = 'S'::bpchar AND f.valor_lancamento > 0::double precision and f.data_liquidacao >= '$dt_projeto' GROUP BY os.tipo_os";

    }

    public function loadFaturamentoAnualBD($codprojeto, $dt_projeto)
    {


        $this->sql = "SELECT Date_Part('month', f.data_liquidacao) As mes, Date_Part('year', f.data_liquidacao) || '' as ano, 
cast(sum(round(cast(@p.vlr_liquidacao as numeric),2)) as double precision) As valor_pago
FROM mk_plano_contas f 
JOIN mk_contas_faturadas ft ON f.codconta = ft.cd_conta
JOIN mk_faturas p ON ft.cd_fatura = p.codfatura
JOIN mk_conexoes x ON x.codcliente = f.codcliente_codfornecedor -- vincula conexao ao plano de contas
JOIN mk_fiber_splitter split on split.codsplitter = x.cd_splitter -- vincula a conexao com o splitter
JOIN mk_fiber_caixa cx on cx.codcaixa = split.cd_caixa --vincula as CTO com as splitter
JOIN mk_fiber_projeto pro on cx.cd_projeto = pro.codprojeto -- vincula um projeto com as CTO
WHERE pro.codprojeto in ($codprojeto) and x.tipo_conexao = 1 and f.tipo_conta = 'R'::bpchar AND f.nomenclatura_integracao in ('CNT','MAN', 'ADE') AND 
(NOT f.meio_pgto = 6 OR f.meio_pgto IS NULL) AND (NOT p.forma_pgto_liquidacao in (5,2) OR p.forma_pgto_liquidacao IS NULL) 
and f.data_liquidacao >= Date_trunc('month', current_date ) - interval '1 year'
AND f.liquidado = 'S'::bpchar AND f.valor_lancamento > 0::double precision and f.data_liquidacao >= '$dt_projeto' GROUP BY mes, ano order by ano, mes";
    }

    public function loadProjetos($ece)
    {

        $this->sql = "select * from projetos where ece = $ece order by projeto";

    }

    public function loadallProjetos_maps()
    {

        $this->sql = "select * from projetos p inner join projetos_maps pm on p.id_projeto = pm.cod_projeto 
        where pm.cod_projeto = :projeto";

    }

    public function buscaProjetoBD()
    {

        $this->sql = "select * from projetos where id_projeto = :projeto order by projeto";
    }

    public function loadmarkersBD($conexao)
    {


        $this->sql = "SELECT * FROM markers WHERE codconexao in ($conexao)";

    }

    /**
     * @return mixed
     */
    public function getSql()
    {
        return $this->sql;
    }


}
