<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 17/12/2018
 * Time: 12:12
 */
require_once "ConexaoBD.class.php";

abstract class SqlResidencial extends BD
{

    private $sql;


    // funcao utilizada para buscar o faturamento antes de 17/02/2021
    public function loadfaturamento()
    {

        $this->sql = "SELECT tab.data_pagto AS data, sum(tab.no_mes) AS mes, sum(tab.atraso) AS atraso FROM ( SELECT x.data_pagto, CASE WHEN x.pagto = 'NO MÊS'::text THEN sum(x.valor_pago) ELSE NULL::double precision
END AS no_mes, CASE WHEN x.pagto = 'ATRASO MÊS ANT.'::text THEN sum(x.valor_pago) ELSE NULL::double precision END AS atraso FROM ( SELECT p.vlr_liquidacao AS valor_pago, f.data_liquidacao AS data_pagto, CASE
WHEN to_char(COALESCE(f.data_vencimento, p.data_vencimento_original)::timestamp with time zone, 'yyyymm'::text) < to_char(f.data_liquidacao::timestamp with time zone, 'yyyymm'::text) THEN 'ATRASO MÊS ANT.'::text
ELSE 'NO MÊS'::text END AS pagto, p.codfatura FROM mk_plano_contas f JOIN mk_contas_faturadas ft ON f.codconta = ft.cd_conta JOIN mk_faturas p ON ft.cd_fatura = p.codfatura
WHERE f.tipo_conta = 'R'::bpchar AND f.nomenclatura_integracao in ('CNT','MAN', 'ADE') AND (NOT f.meio_pgto = 6 OR f.meio_pgto IS NULL) AND (NOT p.forma_pgto_liquidacao in (5,2) OR p.forma_pgto_liquidacao IS NULL) 
AND f.liquidado = 'S'::bpchar AND f.valor_lancamento > 0::double precision AND
    ((substr(f.unidade_financeira::text, 1, 5) = ANY (ARRAY['03.01'::text, '03.04'::text, '03.06'::text])) OR ((substr(f.unidade_financeira,1,2) = '01'
        AND substr(f.unidade_financeira,1,5) not in ('01.10','01.11','01.12','01.13','01.14','01.15','01.16','01.17','01.18'))))
AND f.data_liquidacao between :data_i and :data_f GROUP BY p.vlr_liquidacao, f.data_liquidacao, 
( CASE WHEN to_char(COALESCE(f.data_vencimento, p.data_vencimento_original)::timestamp with time zone, 'yyyymm'::text) < to_char(f.data_liquidacao::timestamp with time zone, 'yyyymm'::text) THEN 'ATRASO MÊS ANT.'::text
ELSE 'NO MÊS'::text END), p.codfatura) x  GROUP BY x.data_pagto, x.pagto ORDER BY x.data_pagto) tab GROUP BY tab.data_pagto ORDER BY tab.data_pagto";

    }


    // funcao criada para buscar o faturamento a partir de 17/02/2021
    public function loadFaturamento_dt_efetivacao(){
       $this->sql = "SELECT tab.data_pagto AS data, sum(tab.no_mes) AS mes, sum(tab.atraso) AS atraso FROM ( SELECT x.data_pagto, CASE WHEN x.pagto = 'NO MÊS'::text THEN sum(x.valor_pago) ELSE NULL::double precision
END AS no_mes, CASE WHEN x.pagto = 'ATRASO MÊS ANT.'::text THEN sum(x.valor_pago) ELSE NULL::double precision END AS atraso FROM ( SELECT p.vlr_liquidacao AS valor_pago, p.dt_efetivacao_credito AS data_pagto, CASE
WHEN to_char(COALESCE(f.data_vencimento, p.data_vencimento_original)::timestamp with time zone, 'yyyymm'::text) < to_char(p.dt_efetivacao_credito::timestamp with time zone, 'yyyymm'::text) THEN 'ATRASO MÊS ANT.'::text
ELSE 'NO MÊS'::text END AS pagto, p.codfatura FROM mk_plano_contas f JOIN mk_contas_faturadas ft ON f.codconta = ft.cd_conta JOIN mk_faturas p ON ft.cd_fatura = p.codfatura
WHERE f.tipo_conta = 'R'::bpchar AND f.nomenclatura_integracao in ('CNT','MAN', 'ADE') AND (NOT f.meio_pgto = 6 OR f.meio_pgto IS NULL) AND (NOT p.forma_pgto_liquidacao in (5,2) OR p.forma_pgto_liquidacao IS NULL) 
AND f.liquidado = 'S'::bpchar AND f.valor_lancamento > 0::double precision AND
        ((substr(f.unidade_financeira::text, 1, 5) = ANY (ARRAY['03.01'::text, '03.04'::text, '03.06'::text])) OR ((substr(f.unidade_financeira,1,2) = '01'
            AND substr(f.unidade_financeira,1,5) not in ('01.10','01.11','01.12','01.13','01.14','01.15','01.16','01.17','01.18'))))
AND p.dt_efetivacao_credito between :data_i and :data_f GROUP BY p.vlr_liquidacao, p.dt_efetivacao_credito, 
( CASE WHEN to_char(COALESCE(f.data_vencimento, p.data_vencimento_original)::timestamp with time zone, 'yyyymm'::text) < to_char(p.dt_efetivacao_credito::timestamp with time zone, 'yyyymm'::text) THEN 'ATRASO MÊS ANT.'::text
ELSE 'NO MÊS'::text END), p.codfatura) x  GROUP BY x.data_pagto, x.pagto ORDER BY x.data_pagto) tab GROUP BY tab.data_pagto ORDER BY tab.data_pagto";


    }

    //Agrupa por data e unidade financeira
    public function loadfaturamentoEmpresa()
    {

        $this->sql = "SELECT tab.data_pagto AS data, sum(tab.no_mes) AS mes, sum(tab.atraso) AS atraso, tab.unidade_financeira FROM ( SELECT x.data_pagto, x.unidade_financeira, CASE WHEN x.pagto = 'NO MÊS'::text THEN sum(x.valor_pago) ELSE NULL::double precision
END AS no_mes, CASE WHEN x.pagto = 'ATRASO MÊS ANT.'::text THEN sum(x.valor_pago) ELSE NULL::double precision END AS atraso FROM ( SELECT p.vlr_liquidacao AS valor_pago, f.data_liquidacao AS data_pagto, f.unidade_financeira, CASE
WHEN to_char(COALESCE(f.data_vencimento, p.data_vencimento_original)::timestamp with time zone, 'yyyymm'::text) < to_char(f.data_liquidacao::timestamp with time zone, 'yyyymm'::text) THEN 'ATRASO MÊS ANT.'::text
ELSE 'NO MÊS'::text END AS pagto, p.codfatura FROM mk_plano_contas f JOIN mk_contas_faturadas ft ON f.codconta = ft.cd_conta JOIN mk_faturas p ON ft.cd_fatura = p.codfatura
WHERE f.tipo_conta = 'R'::bpchar AND f.nomenclatura_integracao in ('CNT','MAN', 'ADE') AND (NOT f.meio_pgto = 6 OR f.meio_pgto IS NULL) AND (NOT p.forma_pgto_liquidacao in (5,2) OR p.forma_pgto_liquidacao IS NULL) 
AND f.liquidado = 'S'::bpchar AND f.valor_lancamento > 0::double precision AND
    ((substr(f.unidade_financeira::text, 1, 5) = ANY (ARRAY['03.01'::text, '03.04'::text, '03.06'::text])) OR ((substr(f.unidade_financeira,1,2) = '01'
        AND substr(f.unidade_financeira,1,5) not in ('01.10','01.11','01.12','01.13','01.14','01.15','01.16','01.17','01.18'))))
AND f.data_liquidacao between :data_i and :data_f GROUP BY p.vlr_liquidacao, f.data_liquidacao, f.unidade_financeira, 
( CASE WHEN to_char(COALESCE(f.data_vencimento, p.data_vencimento_original)::timestamp with time zone, 'yyyymm'::text) < to_char(f.data_liquidacao::timestamp with time zone, 'yyyymm'::text) THEN 'ATRASO MÊS ANT.'::text
ELSE 'NO MÊS'::text END), p.codfatura) x  GROUP BY x.data_pagto, x.pagto, x.unidade_financeira ORDER BY x.data_pagto) tab GROUP BY tab.data_pagto, tab.unidade_financeira ORDER BY tab.data_pagto";

    }

    public function loadfaturamento_Dia(){

        $this->sql = "SELECT p.vlr_liquidacao AS valor_pago, f.data_liquidacao AS data_pagto, pe.nome_razaosocial as nome, CASE
WHEN to_char(COALESCE(f.data_vencimento, p.data_vencimento_original)::timestamp with time zone, 'yyyymm'::text) < to_char(f.data_liquidacao::timestamp with time zone, 'yyyymm'::text) THEN 'ATRASO'::text
ELSE 'MES'::text END AS pagto, f.nomenclatura_integracao as tipo, p.codfatura FROM mk_plano_contas f JOIN mk_contas_faturadas ft ON f.codconta = ft.cd_conta JOIN mk_faturas p ON ft.cd_fatura = p.codfatura
JOIN mk_pessoas pe on pe.codpessoa = f.codcliente_codfornecedor WHERE f.tipo_conta = 'R'::bpchar AND f.nomenclatura_integracao in ('CNT','MAN','ADE') AND (NOT f.meio_pgto = 6 OR f.meio_pgto IS NULL) AND (NOT p.forma_pgto_liquidacao in (5,2) OR p.forma_pgto_liquidacao IS NULL) AND f.liquidado = 'S'::bpchar AND f.valor_lancamento > 0::double precision AND
((substr(f.unidade_financeira::text, 1, 5) = ANY (ARRAY['03.01'::text, '03.04'::text, '03.06'::text])) OR ((substr(f.unidade_financeira,1,2) = '01' AND substr(f.unidade_financeira,1,5) not in ('01.10','01.11','01.12','01.13','01.14','01.15','01.16','01.17','01.18'))))
AND f.data_liquidacao between :data_i and :data_f GROUP BY p.vlr_liquidacao, pe.nome_razaosocial, f.data_liquidacao, f.nomenclatura_integracao, ( CASE WHEN to_char(COALESCE(f.data_vencimento, p.data_vencimento_original)::timestamp with time zone, 'yyyymm'::text) < to_char(f.data_liquidacao::timestamp with time zone, 'yyyymm'::text) THEN 'ATRASO'::text
ELSE 'MES'::text END), p.codfatura";

    }

    public function loadfaturamento_Dia2(){

        $this->sql = "SELECT p.vlr_liquidacao AS valor_pago, p.dt_efetivacao_credito AS data_pagto, pe.nome_razaosocial as nome, CASE
WHEN to_char(COALESCE(f.data_vencimento, p.data_vencimento_original)::timestamp with time zone, 'yyyymm'::text) < to_char(p.dt_efetivacao_credito::timestamp with time zone, 'yyyymm'::text) THEN 'ATRASO'::text
ELSE 'MES'::text END AS pagto, f.nomenclatura_integracao as tipo, p.codfatura FROM mk_plano_contas f JOIN mk_contas_faturadas ft ON f.codconta = ft.cd_conta JOIN mk_faturas p ON ft.cd_fatura = p.codfatura
JOIN mk_pessoas pe on pe.codpessoa = f.codcliente_codfornecedor WHERE f.tipo_conta = 'R'::bpchar AND f.nomenclatura_integracao in ('CNT','MAN','ADE') AND (NOT f.meio_pgto = 6 OR f.meio_pgto IS NULL) AND (NOT p.forma_pgto_liquidacao in (5,2) OR p.forma_pgto_liquidacao IS NULL) AND f.liquidado = 'S'::bpchar AND f.valor_lancamento > 0::double precision AND
        ((substr(f.unidade_financeira::text, 1, 5) = ANY (ARRAY['03.01'::text, '03.04'::text, '03.06'::text])) OR ((substr(f.unidade_financeira,1,2) = '01' AND substr(f.unidade_financeira,1,5) not in ('01.10','01.11','01.12','01.13','01.14','01.15','01.16','01.17','01.18'))))
AND p.dt_efetivacao_credito between :data_i and :data_f GROUP BY p.vlr_liquidacao, pe.nome_razaosocial, p.dt_efetivacao_credito, f.nomenclatura_integracao, ( CASE WHEN to_char(COALESCE(f.data_vencimento, p.data_vencimento_original)::timestamp with time zone, 'yyyymm'::text) < to_char(p.dt_efetivacao_credito::timestamp with time zone, 'yyyymm'::text) THEN 'ATRASO'::text
ELSE 'MES'::text END), p.codfatura";


    }

    /**
     * @return mixed
     */
    public function getSql()
    {
        return $this->sql;
    }


}