<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 26/02/2019
 * Time: 15:36
 */

require_once "ConexaoBD.class.php";

abstract class SqlConexoes extends BD
{


    private $sql;

    public function sqlDesbloqueadosMes()
    {

        $this->sql = "select p.codpessoa, p.nome_razaosocial, c.codcontrato, coalesce(pl.vlr_mensalidade,c.vlr_renovacao) as previsao, desbloq.codconexao, desbloq.bloqueado as conex_bloq,
	desbloq.desbloqueio as ult_desbloqueio, desbloq.bloqueio as ult_bloqueio, c.unidade_financeira as plano_contas, un.descricao as tipo, ci.cidade
    from mk_contratos c
	inner join (select x.codcliente, x.codconexao, desbloq.desbloqueio, bloq.bloqueio, x.conexao_bloqueada as bloqueado, c.codcontrato
	from mk_contratos c
	inner join mk_conexoes x on c.codcontrato = x.contrato
	
	left join (select max(data) as desbloqueio, cd_conexao from mk_conexoes_historico_eventos where tipo_evento = 2 and not cd_regua is null  
	group by cd_conexao)desbloq on x.codconexao = desbloq.cd_conexao --desbloqueados automaticamente

	left join (select max(data) as bloqueio, cd_conexao from mk_conexoes_historico_eventos where tipo_evento = 1 --and not cd_regua is null  
	group by cd_conexao)bloq on x.codconexao = bloq.cd_conexao --bloqueados automaticamente


	where c.cancelado = 'N' and (c.suspenso = 'N' OR c.suspenso is NULL ) AND c.metodo_faturamento::integer != 3 and x.conexao_bloqueada = 'N')desbloq -- tabela de controle de desbloqueio
	ON c.codcontrato = desbloq.codcontrato
	inner join mk_pessoas p on c.cliente = p.codpessoa
	inner join mk_planos_acesso pl on pl.codplano = c.plano_acesso
	left join mk_unidade_financeia un on c.unidade_financeira = un.nomenclatura
	inner join mk_cidades ci on p.codcidade = ci.codcidade
	where desbloq.desbloqueio between date_trunc('month', current_date) and date_trunc('month', current_date) + interval '1 month' - interval '1 day' -- desbloqueado este mes
	and desbloq.bloqueio < date_trunc('month', current_date) -- ultimo bloqueio menor que este mes
	order by ult_desbloqueio";

    }
    public function sqlDesbloqueadosManualMes()
    {

        $this->sql = "select p.codpessoa, p.nome_razaosocial, c.codcontrato, coalesce(pl.vlr_mensalidade,c.vlr_renovacao) as previsao, desbloq.codconexao, desbloq.bloqueado as conex_bloq,
	desbloq.desbloqueio as ult_desbloqueio, desbloq.bloqueio as ult_bloqueio, c.unidade_financeira as plano_contas, un.descricao as tipo, ci.cidade
    from mk_contratos c
	inner join (select x.codcliente, x.codconexao, desbloq.desbloqueio, bloq.bloqueio, x.conexao_bloqueada as bloqueado, c.codcontrato
	from mk_contratos c
	inner join mk_conexoes x on c.codcontrato = x.contrato
	
	left join (select max(data) as desbloqueio, cd_conexao from mk_conexoes_historico_eventos where tipo_evento = 2 and cd_regua is null  
	group by cd_conexao)desbloq on x.codconexao = desbloq.cd_conexao --desbloqueados automaticamente

	left join (select max(data) as bloqueio, cd_conexao from mk_conexoes_historico_eventos where tipo_evento = 1 
	group by cd_conexao)bloq on x.codconexao = bloq.cd_conexao --bloqueados automaticamente


	where c.cancelado = 'N' and (c.suspenso = 'N' OR c.suspenso is NULL ) AND c.metodo_faturamento::integer != 3 and x.conexao_bloqueada = 'N')desbloq -- tabela de controle de desbloqueio
	ON c.codcontrato = desbloq.codcontrato
	inner join mk_pessoas p on c.cliente = p.codpessoa
	inner join mk_planos_acesso pl on pl.codplano = c.plano_acesso
	left join mk_unidade_financeia un on c.unidade_financeira = un.nomenclatura
	inner join mk_cidades ci on p.codcidade = ci.codcidade
	where desbloq.desbloqueio between date_trunc('month', current_date) and date_trunc('month', current_date) + interval '1 month' - interval '1 day' -- desbloqueado este mes
	and desbloq.bloqueio < date_trunc('month', current_date) -- ultimo bloqueio menor que este mes
	order by ult_desbloqueio";

    }

    public function sqlBloqueadosMes(){

        $this->sql = "select p.codpessoa, p.nome_razaosocial, c.codcontrato, coalesce(pl.vlr_mensalidade,c.vlr_renovacao) as previsao, bloq.codconexao, bloq.bloqueado as conex_bloq,
	bloq.bloqueio as ult_bloqueio, bloq.descricao as motivo_bloq, c.unidade_financeira as plano_contas, un.descricao as tipo, ci.cidade
    from mk_contratos c
	inner join (select x.codcliente, x.codconexao, bloq.bloqueio, x.conexao_bloqueada as bloqueado, c.codcontrato, mb.descricao
	from mk_contratos c
	inner join mk_conexoes x on c.codcontrato = x.contrato
	left join mk_motivos_bloqueio mb on x.motivo_bloqueio = mb.codmotbloq

	left join (select max(data) as bloqueio, cd_conexao from mk_conexoes_historico_eventos where tipo_evento = 1 --and not cd_regua is null  
	group by cd_conexao)bloq on x.codconexao = bloq.cd_conexao --bloqueados automaticamente
		
	where c.cancelado = 'N' and (c.suspenso = 'N' OR c.suspenso is NULL ) AND c.metodo_faturamento::integer != 3 AND x.motivo_bloqueio = 1)bloq -- tabela de controle de bloqueio
	ON c.codcontrato = bloq.codcontrato
	inner join mk_pessoas p on c.cliente = p.codpessoa
	inner join mk_planos_acesso pl on pl.codplano = c.plano_acesso
	left join mk_unidade_financeia un on c.unidade_financeira = un.nomenclatura
	inner join mk_cidades ci on p.codcidade = ci.codcidade
	where bloq.bloqueio between date_trunc('month', current_date) and date_trunc('month', current_date) + interval '1 month' - interval '1 day'
	order by ult_bloqueio";

    }


    public function sqlReduzidosMes(){

        $this->sql = "select p.codpessoa, p.nome_razaosocial, c.codcontrato, coalesce(pl.vlr_mensalidade,c.vlr_renovacao) as previsao, r.codconexao, r.bloqueado as conex_bloq,
	r.entr_reducao as ult_reducao, c.unidade_financeira as plano_contas, un.descricao as tipo, ci.cidade
    from mk_contratos c
	inner join (select x.codcliente, x.codconexao, redu.entr_reducao, x.conexao_bloqueada as bloqueado, c.codcontrato
	from mk_contratos c
	inner join mk_conexoes x on c.codcontrato = x.contrato
	
	left join (select max(data) as entr_reducao, cd_conexao from mk_conexoes_historico_eventos where tipo_evento = 3 
	group by cd_conexao)redu on x.codconexao = redu.cd_conexao --reduzidos
		
	where c.cancelado = 'N' and (c.suspenso = 'N' OR c.suspenso is NULL ) AND c.metodo_faturamento::integer = 1 and x.conexao_bloqueada = 'N' and x.esta_reduzida = 'S')r -- tabela de controle de desbloqueio
	ON c.codcontrato = r.codcontrato
	inner join mk_pessoas p on c.cliente = p.codpessoa
	inner join mk_planos_acesso pl on pl.codplano = c.plano_acesso
	left join mk_unidade_financeia un on c.unidade_financeira = un.nomenclatura
	inner join mk_cidades ci on p.codcidade = ci.codcidade
	where r.entr_reducao between date_trunc('month', current_date) and date_trunc('month', current_date) + interval '1 month' - interval '1 day' -- desbloqueado este mes
	--and desbloq.bloqueio between date_trunc('month', current_date - interval '1 month') and date_trunc('month', current_date) - interval '1 day' -- ultimo bloqueio mes passado
	order by ult_reducao ";
    }

    public function sqlHistoricoConexao(){
        $this->sql = "select * from acumulado_historico_conexao where cod_mes = :mes and ano = :ano";
    }


    public function sqlAllHistoricoConexao(){
        $this->sql = "select * from acumulado_historico_conexao order by cod_mes";
    }

    public function loadHistoricoBloqueioDesbloqueio(){
        $this->sql = "--BLOQUEADOS (AUTOMATICAMENTO POR INADIMPLENCIA) IGNORA OS BLOQUEADOS MANUALMENTE POR TEMPO INDETERMINDADO
select xe.data, p.nome_razaosocial, p.codpessoa, c.codcontrato, c.unidade_financeira as tipo, un.descricao as tipo2, x.codconexao, xo.descricao, xe.cd_debito 
from mk_conexoes x
inner join (select ev.codconhistevento, ev.data, ev.cd_conexao, ev.tipo_evento, ev.cd_debito
 from mk_conexoes_historico_eventos ev 
 inner join (select max(codconhistevento) as codhistorico, max(data) as data, cd_conexao, tipo_evento from mk_conexoes_historico_eventos where tipo_evento in (1) and cd_debito is not null
	group by cd_conexao, tipo_evento)his on ev.codconhistevento = his.codhistorico)xe on x.codconexao = xe.cd_conexao 
inner join mk_contratos c on x.contrato = c.codcontrato
inner join mk_pessoas p on p.codpessoa = c.cliente
inner join mk_unidade_financeia un on c.unidade_financeira = un.nomenclatura
inner join mk_conexoes_operacoes xo on xe.tipo_evento = xo.codconexaohistorico
where xe.data between :data_i and :data_f and c.metodo_faturamento::integer != 3 and p.classificacao = 1 and (c.suspenso = 'N' or c.suspenso is null) and c.cancelado = 'N'
union
--DESBLOQUEADOS AUTOMATICAMENTE (POR AUTO DESBLOQUEIO OU RETORNO) IGNORA DESBLOQUEIOS MANUAIS 
 select xe.data, p.nome_razaosocial, p.codpessoa, c.codcontrato, c.unidade_financeira as tipo, un.descricao as tipo2, x.codconexao, xo.descricao, xe.cd_debito 
 from mk_conexoes x
 inner join (select codconhistevento, data, cd_conexao, tipo_evento, cd_debito
 from mk_conexoes_historico_eventos ev
 inner join (select max(hd.codhistorico) as codhistorico from (
 select max(codconhistevento) as codhistorico, max(data) as data, cd_conexao, tipo_evento, cd_debito
 from mk_conexoes_historico_eventos where tipo_evento in (23) 
 group by cd_conexao, tipo_evento, cd_debito
 union	
select max(codconhistevento) as codhistorico, max(data) as data, cd_conexao, tipo_evento, cd_debito
		from mk_conexoes_historico_eventos where tipo_evento in (2) and cd_debito is not null 
	group by cd_conexao, tipo_evento, cd_debito)hd group by hd.cd_conexao)his on ev.codconhistevento = his.codhistorico)xe on x.codconexao = xe.cd_conexao
inner join mk_contratos c on x.contrato = c.codcontrato
inner join mk_pessoas p on p.codpessoa = c.cliente
inner join mk_unidade_financeia un on c.unidade_financeira = un.nomenclatura
inner join mk_conexoes_operacoes xo on xe.tipo_evento = xo.codconexaohistorico   
where xe.data between :data_i and :data_f  and c.metodo_faturamento::integer != 3 and p.classificacao = 1 and (c.suspenso = 'N' or c.suspenso is null) and c.cancelado = 'N'
order by nome_razaosocial
";}

    /**
     * @return mixed
     */
    public function getSql()
    {
        return $this->sql;
    }


}

?>
