<?php
/**
 * Created by PhpStorm.
 * User: dgddias
 * Date: 05/10/2018
 * Time: 09:41
 */
include_once "../../classes/Dashboard_Adm.php";
include_once "../../funcoes/funcoes.php";

//PEGA primeiro do mes 3 MESES ATRÁS
$date_3 = date('Y-m-d', mktime(0, 0, 0, date('m') - 3,
    1, date('Y')));
// PEGA ULTIMO DIA DO MES
$dt_f = date('Y-m-d', mktime(23, 59, 59, date('m'),
    date("t"), date('Y')));
$dt_i = date('Y-m-d', mktime(0, 0, 0, date('m'), 1,
    date('Y')));


$indicadores = new Dashboard_Adm();

// CARREGA A TABELA DE ORDEM DE SERVICO DO DASH ADM

$page = isset($_GET['page']) ? $_GET['page'] : '';

if ($page == 'formresumo'):
    $indicadores->carregarOS($date_3, date('d-m-Y', strtotime('+ 2 month')));
    //var_dump($indicadores);
    $inicio = $_POST['inicio'];
    $fim = $_POST['fim'];
    ?>

    <div class="table-responsive row">
        <table class="table table-bordered table-hover table-head-info" id="datatable">
            <thead class="thead-lg">
            <tr>
                <th class="text-center"><i class="fa fa-calendar-plus-o"></i></th>
                <th class="text-center">Empresa</th>
                <th class="text-center"><i class="mr-2 ti-user"></i>Cliente</th>
                <th class="text-center"><i class="mr-2 ti-location-pin"></i>Endereço</th>
                <th class="text-center"><i class="mr-2 ti-plus"></i>Unidade</th>
                <th class="text-center"><i class="mr-2 ti-book"></i>Plano</th>
                <th class="text-center"><i class="mr-2 ti-stats-up"></i>Status</th>
            </tr>
            </thead>
            <tbody>
            <?php

            foreach ($indicadores->getResult() as $row) :
                if ($row['data'] >= $inicio && $row['data'] <= $fim) :

                    ?>
                    <tr>
                        <td class="text-center text-light font-strong"><?php echo date('d/m/Y', strtotime($row['data'])); ?></td>
                        <td class="text-center" style="width: 5%">
                            <?php if ($row['metodo_faturamento'] == 1): ?>
                                <?php if ((empresa($row['tipo']) === 'Cross') && ($row['status'] == 'SUCESSO' || $row['status'] == 'PENDENTE')):; ?>
                                    <span class="btn-icon-only btn-redenilf font-strong font-20" data-toggle="tooltip" title="Cross">C</span>
                                <?php elseif ((empresa($row['tipo']) == 'Redenilf') && ($row['status'] == 'SUCESSO' || $row['status'] == 'PENDENTE')):; ?>
                                    <span class="btn-icon-only btn-redenilf2 font-strong font-20" data-toggle="tooltip" title="Redenilf">R</span>
                                <?php elseif ((empresa($row['tipo']) == 'Technet') && ($row['status'] == 'SUCESSO' || $row['status'] == 'PENDENTE')):; ?>
                                    <span class="btn-icon-only btn-technet font-strong font-20" data-toggle="tooltip" title="Technet">T</span>
                                <?php else: ?>
                                    <span class="btn-icon-only btn-danger font-strong font-20"><i
                                                class="fa fa-warning"></i></span>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="btn-icon-only btn-danger font-strong font-20"><i
                                            class="fa fa-warning"></i></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="mb-2">
                                <h6><?php echo utf8_encode($row['nome_razaosocial']); ?></h6>
                                <div class="my-2"></div>
                                <span class="float-right"><small class="text-muted ml-2">
                                    OS: <?php echo $row['codos']; ?></small></span>
                                <span class="font-13 text-light">
                                <?php echo ucfirst(mb_strtolower($row['os'], 'UTF-8')); ?></span>
                            </div>
                        </td>
                        <td class="text-center">
                            <div class="mb-2">
                                <span class="font-strong text-light font-13">
                                    <?php echo utf8_encode($row['cidade']); ?>
                                </span>
                                <div class="divider my-2"></div>
                                <span>
                                    <small class="font-strong text-light font-12">
                                        <?php echo utf8_encode($row['bairro']); ?>
                                    </small>
                                </span>
                            </div>
                        </td>
                        <td class="text-center text-light font-strong">
                            <?php if (!($row['metodo_faturamento'] == 1)) {
                                echo 'Cortesia';
                            } else {
                                echo unidade_financeira($row['tipo']);
                            } ?>

                            <?php if($row['vendedorcrm']):?>
                            <div class="divider my-2"></div>
                            <h6><?php echo utf8_encode($row['vendedorcrm']); ?></h6>
                             <?php endif;?>

                        </td>
                        <!--ALTERAR-->
                        <td class="text-center">
                            <?php echo utf8_encode($row['plano']); ?>
                        </td>
                        <td class="text-center">
                            <?php if ($row['status'] == 'SUCESSO'): ?>
                                <span class="text-uppercase badge badge-success"><?php echo $row['status']; ?></span>
                            <?php elseif ($row['status'] == 'PENDENTE'): ?>
                                <span class="text-uppercase badge badge-warning"><?php echo $row['status']; ?></span>
                            <?php else: ?>
                                <span class="text-uppercase badge badge-danger"><?php echo $row['status']; ?></span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php
                endif;
            endforeach;
            ?>
            </tbody>
        </table>
    </div>

<?php
elseif ($page == 'loadvendasanual'):

    $indicadores->carregaVendasAnual();
    echo $indicadores->getAcumudaloAnualInstalados();

    ?>

<?php elseif ($page == 'loadcidadestop'):

    $indicadores->carregarOS($_POST['data_i'], $_POST['data_f']);
    $indicadores->top_cidades($_POST['data_i'], $_POST['data_f']);

    $newarray = array();
    foreach ($indicadores->getCidades() as $row => $key) {

        if ($key >= 1) {

            array_push($newarray, ["label" => utf8_encode($row), "value" => $key]);
        }
    }
    function ordenar($a, $b)
    {

        return $a['value'] < $b['value'];
    }

    usort($newarray, 'ordenar');

    echo json_encode($newarray);
    ?>
<?php
endif; ?>