<?php
include_once "../../classes/Dashboard_Crm.php";
include_once "../../funcoes/funcoes.php";


$dashcrm = new Dashboard_Crm();

$page = isset($_GET['page']) ? $_GET['page'] : '';
$dt_start = isset($_POST['inicio']) ? $_POST['inicio'] : '';
$dt_end = isset($_POST['fim']) ? $_POST['fim'] : '';

if ($page === 'loadReuniao') :
    $dashcrm->loadReunioes($dt_start, $dt_end);
    ?>
    <div class="ibox-body">
        <div class="flexbox mb-4">
            <div class="flexbox">
                <span class="flexbox mr-3">
                    <span class="mr-2 text-muted">Agendadas</span>
                    <span class="h3 mb-0 text-light font-strong">
                        <?php
                        echo $dashcrm->getReunioesAgendadas() ? count($dashcrm->getReunioesAgendadas()) : 0;
                        ?></span>
                </span>
                <span class="flexbox">
                    <span class="mr-2 text-muted">Finalizadas</span>
                    <span class="h3 mb-0 text-success font-strong">
                        <?php
                        echo $dashcrm->getReunioesFinalizadas() ? count($dashcrm->getReunioesFinalizadas()) : 0;
                        ?></span>
                </span>
            </div>
            <!--
            <a class="flexbox" href="javascript:;" target="_blank">VIEW ALL
                <i class="ti-arrow-circle-right ml-2 font-18"></i>
            </a>
            -->
        </div>
        <div class="ibox-fullwidth-block">
            <table class="table">
                <thead class="thead-default thead-lg">
                <tr>
                    <th class="pl-4">Vendedor</th>
                    <th>Agendadas</th>
                    <th>Finalizadas</th>
                    <th class="pr-4">Produtividade</th>
                </tr>
                </thead>
                <tbody>
                <?php
                if (!empty($dashcrm->getVendedores())) :
                    foreach ($dashcrm->getVendedores() as $key => $vendedores) : ?>
                        <tr>
                            <td class="pl-4">
                                <div class="flexbox-b">
                                        <span class="btn-icon-only <?php echo $vendedores['color'] ?> font-20 mr-3">
                                            <?php
                                            echo iniciaisdeumapalavra($vendedores['vendedores']);
                                            ?>
                                        </span>
                                    <div>
                                        <h6 class="mb-1 d-none d-lg-block"><?php
                                            echo $vendedores['vendedores'];
                                            ?></h6>
                                        <div>
                                                <span class="text-muted font-13 d-none col-sm"><i
                                                            class="ti-user mr-2"></i>
                                                    Gerente de Negócios
                                                </span>
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <h4 class="font-strong text-light mb-0"><?php


                                    $totalagendadas = 0;
                                    if (!empty($dashcrm->getReunioesAgendadas())) {
                                        foreach ($dashcrm->getReunioesAgendadas() as $row) {

                                            if ($row['first_name'] . ' ' . $row['last_name'] === $vendedores['vendedores']) {

                                                $totalagendadas++;

                                            }
                                        }
                                    }
                                    echo $totalagendadas;
                                    ?></h4>
                            </td>
                            <td>
                                <h4 class="font-strong text-success mb-0">
                                    <?php


                                    $totalfinalizadas = 0;
                                    if (!empty($dashcrm->getReunioesFinalizadas())) {
                                        foreach ($dashcrm->getReunioesFinalizadas() as $row) {

                                            if ($row['first_name'] . ' ' . $row['last_name'] === $vendedores['vendedores']) {

                                                $totalfinalizadas++;

                                            }
                                        }
                                    }
                                    echo $totalfinalizadas;
                                    ?>
                                </h4>
                            </td>
                            <td class="pr-4">
                                <?php
                                $percentual = 0;
                                if (!empty($dashcrm->getReunioes())) {
                                    $percentual = round((($totalfinalizadas + $totalagendadas)
                                            / count($dashcrm->getReunioes())) * 100);
                                }
                                ?>
                                <div class="easypie"
                                     data-percent="<?php echo $percentual; ?>"
                                     data-bar-color="#5c6bc0"
                                     data-size="56" data-line-width="3">
                                        <span class="easypie-data h5 font-strong"><?php echo $percentual
                                            ?>%</span>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

<?php
elseif ($page === 'loadOportunidade') :

    $dashcrm->loadOportunidades($dt_start, $dt_end);
    ?>
    <div class="table-responsive row">
        <table class="table table-bordered table-hover table-head-redenilfcolor" id="datatable-oportunidade">
            <thead class="thead-lg">
            <tr>
                <th class="text-center"><i class="fa fa-calendar-plus-o"></i></th>
                <th class="text-center">Vendedor</th>
                <th class="text-center"><i class="mr-2 ti-user"></i>Cliente</th>
                <th class="text-center"><i class="mr-2 ti-location-pin"></i>Cidade</th>
                <th class="text-center"><i class="mr-2 ti-layers"></i>Tipo</th>
                <th class="text-center"><i class="mr-2 ti-stats-up"></i>Probabilidade</th>
                <th class="text-center"><i class="mr-2 ti-money"></i>Valor</th>
                <th class="text-center"><i class="mr-2 ti-stats-up"></i>Status</th>
                <th></th>
            </tr>
            </thead>
            <tbody>
            <?php
            if (!empty($dashcrm->getOportunidades())):
                foreach ($dashcrm->getOportunidades() as $row) :
                    ?>
                    <tr>
                        <td class="text-center text-light font-13 font-strong"><?php
                            echo date('d/m/Y', strtotime($row['date_closed'])); ?></td>
                        <td class="pl-4">
                            <div class="flexbox-b">
                    <span class="btn-icon-only font-20 mr-3 <?php
                    echo $dashcrm->loadCorVendedor($row['first_name'] . ' ' . $row['last_name']); ?> text-white">
                        <?php
                        echo iniciaisdeumapalavra($row['first_name'] . ' ' . $row['last_name']);
                        ?></span>
                                <div>
                                    <h6 class="mb-1 d-none d-lg-block"><?php
                                        echo $row['first_name'] . ' ' . $row['last_name'];
                                        ?>
                                    </h6>
                                    <div class="d-none d-lg-block">
                            <span class="text-muted font-13"><i class="ti-user mr-2"></i>
                           <?php echo $row['title']; ?>
                            </span>
                                    </div>
                                </div>
                            </div>
                        </td>
                        <td class="text-center">
                            <div class="mb-2">
                    <span class="font-strong text-light font-13 text-uppercase"><?php
                        echo substr($row['cliente'], 0, 31);
                        ?></span>
                                <div class="divider my-2"></div>
                                <span>
                        <small class="font-strong text-light font-12"><?php
                            echo $row['descricao'];
                            ?></small>
                                 </span>
                            </div>
                        </td>
                        <td class="text-center text-uppercase font-13 text-light"><?php
                            echo $row['billing_address_city'];
                            ?></td>
                        <td class="text-center text-uppercase font-13 text-light"><?php
                            echo $row['tipo'];
                            ?></td>
                        <td class="text-center">
                            <div class="easypie"
                                 data-percent="<?php echo $row['probability']; ?>"
                                 data-bar-color="#5c6bc0"
                                 data-size="46" data-line-width="2">
                                <span class="easypie-data font-strong"><?php
                                    echo $row['probability'];
                                    ?>%</span>
                            </div>
                        </td>
                        <td class="text-center text-uppercase text-light font-strong"><?php
                            echo formata_valor($row['amount']);
                            ?>
                        </td>
                        <td class="text-center">
                            <?php if ($row['FaseVenda'] === 'Ganhamos'): ?>
                                <span class="text-uppercase badge badge-success"><?php echo $row['FaseVenda']; ?></span>
                            <?php elseif ($row['FaseVenda'] === 'Em Análise'): ?>
                                <span class="text-uppercase badge badge-warning"><?php echo $row['FaseVenda']; ?></span>
                            <?php elseif ($row['FaseVenda'] === 'Negociando'): ?>
                                <span class="text-uppercase badge badge-primary"><?php echo $row['FaseVenda']; ?></span>
                            <?php elseif ($row['FaseVenda'] === 'Enviada'): ?>
                                <span class="text-uppercase badge badge-dark"><?php echo $row['FaseVenda']; ?></span>
                            <?php else : ?>
                                <span class="text-uppercase badge badge-danger"><?php echo $row['FaseVenda']; ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php
                            echo $row['amount'];
                            ?>
                        </td>
                    </tr>
                <?php endforeach; endif; ?>
            </tbody>
            <tfoot>
            <tr>
                <th colspan="6">Total: </th>
                <th colspan="2"></th>
            </tr>
            </tfoot>
        </table>
    </div>

<?php
elseif ($page === 'loadSomaOportunidades') :
    $dashcrm->loadSomaOportunidades($dt_start, $dt_end);
    ?>

    <div class="ibox-body">
        <?php
        if (!empty($dashcrm->getSomaOportunidades())):
            foreach ($dashcrm->getSomaOportunidades() as $row) :
                ?>
                <?php if ($row['FaseVenda'] === 'Ganhamos'):
                $valor = round(($row['valor'] / $dashcrm->getTotalOportunidade()) * 100)?>
                <div class="h2 m-0">R$ <?php echo formata_valor($row['valor']);?><i
                        class="ti-stats-up float-right text-success">
                        <span style="font-size: 12px"><?php
                            echo $valor
                            ?>%</span></i>
                </div>
                <div class="m-t-5 text-success">Ganhamos</div>
            <?php endif; ?>
            <?php endforeach; endif; ?>

        <?php
        if (!empty($dashcrm->getSomaOportunidades())):
            foreach ($dashcrm->getSomaOportunidades() as $row) :
                ?>
                <div class="my-4">
                <?php if ($row['FaseVenda'] === 'Em Análise'):
                   $valor = round(($row['valor'] / $dashcrm->getTotalOportunidade()) * 100)?>
                <div class="h4 m-0">R$ <?php echo formata_valor($row['valor']); ?></div>
                <div class="flexbox">
                    <small class="text-warning">Em Análise</small>
                    <span class="text-warning font-12" style="font-size: 12px;"><i
                            class="fa fa-level-up"></i> <?php
                        echo $valor
                        ?>%</span>
                </div>
                <div class="progress mt-1">
                    <div class="progress-bar bg-warning" role="progressbar" style="width:<?php echo $valor?>%; height:5px;"
                         aria-valuenow="<?php echo $valor ?>" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
                </div>
                <div class="mb-4">
            <?php elseif ($row['FaseVenda'] === 'Negociando'):
                $valor = round(($row['valor'] / $dashcrm->getTotalOportunidade()) * 100)?>
                <div class="h4 m-0">R$ <?php echo formata_valor($row['valor']); ?></div>
                <div class="flexbox">
                    <small class="text-primary">Negociando</small>
                    <span class="text-primary font-12" style="font-size: 12px;"><i
                                class="fa fa-level-up"></i> <?php echo $valor?>%</span>
                </div>
                <div class="progress mt-1">
                    <div class="progress-bar bg-primary" role="progressbar" style="width:<?php echo $valor?>%; height:5px;"
                         aria-valuenow="<?php echo $valor ?>" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
                </div>
                <div class="mb-4">
            <?php elseif ($row['FaseVenda'] === 'Enviada'):
                $valor = round(($row['valor'] / $dashcrm->getTotalOportunidade()) * 100)?>
                <div class="h4 m-0">R$ <?php echo formata_valor($row['valor']); ?></div>
                <div class="flexbox">
                    <small class="text-dark">Enviada</small>
                    <span class="text-dark font-12" style="font-size: 12px;"><i
                                class="fa fa-level-up"></i> <?php echo $valor?>%</span>
                </div>
                <div class="progress mt-1">
                    <div class="progress-bar bg-dark" role="progressbar" style="width:<?php echo $valor?>%; height:5px;"
                         aria-valuenow="<?php echo $valor ?>" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
                </div>

            <?php endif; ?>
            <?php endforeach; endif; ?>

    </div>
<?php
endif;
?>

