<?php
include_once "../../classes/Dashboard_OS.php";
include_once "../../funcoes/funcoes.php";
// RECEBE O PRIMEIRO E O ULTIMO DIA DO MES CORRENTE
$dt_i = date('Y-m-d', mktime(0, 0, 0, date('m'), 1,
    date('Y')));
$dt_f = date('Y-m-d', mktime(23, 59, 59, date('m'),
    date("t"), date('Y')));

$dt_f_next = date('Y-m-d', strtotime('+ 1 month'));
$dt_lastYear = date('Y-m-d', mktime(0, 0, 0, date('m'), 1, date('Y', strtotime('-1 year'))));
$dt_last11Months = date('Y-m-d', mktime(0, 0, 0, date('m', strtotime('-11 months')), 1, date('Y', strtotime('-1 year'))));

$dt_amanha = date('Y-m-d', strtotime('+1 day'));

// DATA DE ONTEM
$dt_o = date('Y-m-d', strtotime('-1 days'));

$page = isset($_GET['page']) ? $_GET['page'] : '';

//CARREGA TODAS AS OS DO PERIODO INFORMADO
$os = new Dashboard_OS($dt_lastYear, $dt_f_next);

$dt_start = isset($_POST['inicio']) ? $_POST['inicio'] : '';
$dt_end = isset($_POST['fim']) ? $_POST['fim'] : '';


if ($page == 'load_os_tipo'): ?>
    <div class="ibox-body">
        <div class="flexbox mb-5">
            <div class="flexbox">
                    <span class="flexbox mr-3">
                        <i class="mr-2 ti-check font-14 text-success"></i>
                        <span class="h3 mb-0 text-success font-strong" data-toggle="tooltip" title="Concluidas"
                              style="cursor:pointer;">
                            <?php $os->os_concluidas($dt_start, $dt_end);
                            echo count($os->getConcluidas());
                            ?>
                        </span>
                    </span>
            </div>
        </div>
        <div class="tab-content">
            <div class="tab-pane fade show active" id="tab_hoje">
                <div class="row">
                    <?php foreach ($os->getTipoOs() as $row):
                        $os->os_tipo_os($row, $dt_start, $dt_end) ?>
                        <div class="col-md-4 col-sm-4 mb-2">
                            <div class="text-center">
                                <div class="mb-3"><?php echo $row; ?></div>
                                <div class="easypie" data-percent="<?php if (count($os->getTotalTipoOs()) > 0) {
                                    echo round(count($os->getTotalTipoOs()) /
                                        count($os->getConcluidas()) * 100);
                                } ?>" data-bar-color="<?php echo color_os($row); ?>" data-size="80"
                                     data-line-width="8">
                                <span class="easypie-data h3 font-strong"><?php ;
                                    if (!empty($os->getTotalTipoOs())) {
                                        echo count($os->getTotalTipoOs());
                                    } else {
                                        echo 0;
                                    } ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
<?php
elseif ($page == 'chart_os_pendente'):

    $new_array = array();
    $array = array();
    $os->os_pendentes($dt_start, $dt_end);
    foreach ($os->getOsPendentes() as $osPendente) {
        foreach ($os->getTipoOs() as $tipoOs) {
            if (tipo_os($osPendente['tipo_os']) == $tipoOs) {

                array_push($array, $tipoOs);
            }
        }
    }

    $array = array_count_values($array);
    ksort($array);
    foreach ($array as $key => $item) {

        array_push($new_array, ['label' => $key, 'value' => $item]);
    }

    echo json_encode($new_array);

    ?>
<?php
elseif ($page == 'chart_os_mes'):

    $data = array();
    $array = array();
    $new_array = array();
    $new_array2 = array();
    $os->os_concluidas($dt_i, $dt_f);
    foreach ($os->getConcluidas() as $os_row) {
        foreach ($os->getTipoOs() as $tipoOs) {
            if (tipo_os($os_row['tipo_os']) == $tipoOs) {

                array_push($array, ['tipo' => $tipoOs, 'data' => $os_row['data']]);
            }
        }
    }

    foreach ($array as $key => $item) {

        $array_date[$item['data']][] = $item['tipo'];

        foreach ($array_date as $keyP => $valueP) {

            $array_value[$keyP] = array_count_values($array_date[$keyP]);
        }
    }

    ksort($array_value);

    echo json_encode($array_value);
    ?>
<?php
elseif ($page == 'chart_os_ano'):

    $data = array();
    $array = array();
    $new_array = array();
    $new_array2 = array();
    $os->os_concluidas($dt_last11Months, date('Y-m-d'));
    foreach ($os->getConcluidas() as $os_row) {
        foreach ($os->getTipoOs() as $tipoOs) {
            if (tipo_os($os_row['tipo_os']) == $tipoOs) {

                array_push($array, ['tipo' => $tipoOs,
                    'mes' => exibe_mes(date('m', strtotime($os_row['data'])))]);
            }
        }
    }

    foreach ($array as $key => $item) {

        $array_date[$item['mes']][] = $item['tipo'];

        foreach ($array_date as $keyP => $valueP) {

            $array_value[$keyP] = array_count_values($array_date[$keyP]);
        }
    }

    echo json_encode($array_value); ?>
<?php
else: ?>
<div class="ibox-body">
    <div class="flexbox mb-4">
        <div class="flexbox">
                                        <span class="flexbox mr-3">
                                            <span class="mr-2 text-muted">Concluídas</span>
                                            <span class="h3 mb-0 text-primary font-strong"><?php
                                                $os->os_concluidas($dt_start, $dt_end);
                                                echo count($os->getConcluidas()); ?></span>
                                        </span>
            <span class="flexbox">
                                            <span class="mr-2 text-muted">Pendentes</span>
                        <span class="h3 mb-0 text-warning font-strong"><?php
                            $os->os_pendentes($dt_start, $dt_end);
                            echo count($os->getOsPendentes());
                            ?></span>
                                        </span>
        </div>
    </div>
    <div class="table-responsive row">
        <table class="table table-sm table-head-info table-bordered" id="datatable-tec">
            <thead class="thead-lg">
            <tr class="text-uppercase">
                <th class="text-center pl-4">Técnico</th>
                <?php foreach ($os->getTipoOs() as $row): ?>
                    <th class="text-center"><?php echo $row; ?></th>
                <?php endforeach; ?>
                <th class="text-center pr-4">Perc</th>
                <th class="text-center">Total</th>
            </tr>
            </thead>
            <tbody class="text-center">
            <?php foreach ($os->getTecnicos() as $tecnico): ?>
                <tr>
                    <td>
                        <div class="flexbox-b">
                                <span class="btn-icon-only btn-primary font-20 mr-3">
                                    <i class="fa fa-user"></i></span>
                            <div>
                                <h6 class="mb-1"><?php echo $tecnico['nome']; ?></h6>
                            </div>
                        </div>
                    </td>
                    <?php foreach ($os->getTipoOs() as $tipo):
                        $encerrados = array();
                        $pendentes = array();
                        $os->os_tecnico_tipo_os($tecnico['codigo'], $tipo, $dt_start, $dt_end);
                        if (!empty($os->getOsTecnicosTipo())) {
                            foreach ($os->getOsTecnicosTipo() as $row) {

                                if ($row['encerrado'] == 'S' &&
                                    verifica_ecerramento_os($row['encerramento']) == 'FINALIZADO COM SUCESSO') {

                                    array_push($encerrados, $row);
                                } elseif ($row['encerrado'] == 'N') {

                                    array_push($pendentes, $row);
                                }
                            }
                        };
                        //var_dump($pendentes);

                        ?>
                        <td><h5 class="font-strong text-light mb-0">
                                       <span class="ml-1" data-toggle="tooltip" title="OS Concluídas">
                                           <i class="fa fa-check text-success mr-1"></i>
                                        <?php echo count($encerrados); ?></span>
                                <span style="border-right:2px solid rgba(0,0,0,.1);"></span>
                                <span class="ml-1 mr-1" data-toggle="tooltip" title="Os Pendente">
                                        <i class="ml-1 fa fa-clock-o text-warning mr-1"></i>
                                            <?php echo count($pendentes); ?></span>
                            </h5>
                        </td>
                    <?php endforeach; ?>
                    <td>
                        <?php
                        $bar = 0;
                        $encerrados = array();
                        $pendentes = array();
                        $os->os_Tecnico($tecnico['codigo'], $dt_start, $dt_end);
                        if (!empty($os->getOsTecnicos())) {
                            foreach ($os->getOsTecnicos() as $row) {

                                if ($row['encerrado'] == 'S' &&
                                    verifica_ecerramento_os($row['encerramento']) == 'FINALIZADO COM SUCESSO') {

                                    array_push($encerrados, $row);
                                } elseif ($row['encerrado'] == 'N') {

                                    array_push($pendentes, $row);
                                }
                            }
                            $bar = ((count($encerrados) / (count($encerrados) + count($pendentes))) * 100);
                        };
                        ?>
                        <div class="easypie" data-percent="<?php echo round($bar); ?>"
                             data-bar-color="#5c6bc0"
                             data-size="56" data-line-width="3">
                            <span class="easypie-data h5 font-strong"><?php echo round($bar); ?>%</span>
                        </div>
                    </td>
                    <td>
                        <h5 class="font-strong text-dark mb-0"><?php
                            echo(count($encerrados) + count($pendentes));
                            ?></h5>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>
