<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 14/12/2018
 * Time: 10:30
 */

require_once "../../classes/Financeiro.php";
require_once "../../classes/Comercial.php";
require_once "../../classes/Residencia.php";
require_once "../../classes/Empresa.php";
require_once "../../classes/Conexoes.php";
require_once "../../classes/ISP.php";
require_once "../../funcoes/funcoes.php";

$financeiro = new Financeiro();
$comercial = new Comercial();
$empresarial = new Empresa();
$isp = new ISP();
$residencial = new Residencia();
$conexoes = new Conexoes();

// DATAS DO MES CORRENTE
$dt_i = date('d-m-Y', mktime(0, 0, 0, date('m'), 1, date('Y')));
$dt_f = date('d-m-Y', mktime(23, 59, 59, date('m'), date("t"), date('Y')));

// PRIMEIRO DIA DESTE MES A UM ANO ATRÁS
$dt_i12 = date('d-m-Y', mktime(0, 0, 0, date('m'), 1, date('Y') - 1));

// DATAS DO MES PASSADO
$dt_i2 = date('d-m-Y', mktime(0, 0, 0, date('m') - 1,
    1, date('Y')));
$dt_f2 = date('d-m-Y', mktime(0, 0, 0, date('m'),
    date('d') - date('j'), date('Y')));

//DATA DO MES RETRASADO
$dt_i3 = date('d-m-Y', mktime(0, 0, 0, date('m') - 2,
    1, date('Y')));
$dt_f3 = date('d-m-Y', mktime(23, 59, 59, date('m') - 1,
    date('d') - date('j'), date('Y')));

$page = isset($_GET['page']) ? $_GET['page'] : '';

if ($page == 'loadchart1'):

    //carrega o CR
    $financeiro->carregarCR($dt_i, date('d-m-Y', strtotime('-1 day')));
    // var_dump($financeiro->getResult());

    echo json_encode($financeiro->agrupaCR()); ?>

<?php elseif ($page == 'loadchart2'):


    //carrega o CR
    $financeiro->carregarCR($dt_i2, $dt_f2);
    // var_dump($financeiro->getResult());


    echo json_encode($financeiro->agrupaCR());
    ?>
<?php elseif ($page == 'loadchart3'):

    //carrega o CR
    $financeiro->carregarCR($dt_i3, $dt_f3);
    // var_dump($financeiro->getResult());

    echo json_encode($financeiro->agrupaCR());
    ?>
<?php elseif ($page == 'extratodetalhado'):

    $data = getdiasuteisMes($_POST['data_i'], $_POST['data_f'], 'Financeiro');
    $financeiro->carregarCR($_POST['data_i'], $_POST['data_f']);

    $residencial->faturamento($_POST['data_i'], $_POST['data_f']);
    $comercial->faturamento($_POST['data_i'], $_POST['data_f']);
    $empresarial->faturamento($_POST['data_i'], $_POST['data_f']);
    $isp->faturamento($_POST['data_i'], $_POST['data_f']);
    ?>
<!-- START TABELA DE FATURAMENTO -->
    <div class="table-responsive row">
        <table class="font-13 table table-bordered table-head-redenilfcolor table-border-redenilfcolor
                 table-hover" id="tabela_extrato_detalhado">
            <thead class="thead-default thead-lg">
            <tr>
                <th></th>
                <?php if (!empty($data)) {
                    foreach ($data as $row_data) {
                        echo "<th class='text-center'>" . $row_data . "</th>";
                    }
                } else {
                    echo "<th></th>";
                } ?>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td class="bg-redenilf text-white">Cartão</td>
                <?php
                for ($i = 0; $i < count($data); $i++) {
                    echo "<td class='font-strong' style='border-top: 1px solid #006e78'>" . formata_valor($financeiro->saldodia_Cartao($data[$i])) . "</td>";
                }
                ?>
            </tr>
            <tr>
                <td class="bg-redenilf text-white">Comercial</td>
                <?php
                for ($i = 0; $i < count($data); $i++) {
                    echo "<td class='font-strong' style='border-top: 1px solid #006e78'>" . formata_valor($comercial->totaldiario($data[$i])) . "</td>";
                }
                ?>
            </tr>
            <tr>
                <td class="bg-redenilf text-white">Empresarial</td>
                <?php
                for ($i = 0; $i < count($data); $i++) {
                    echo "<td class='font-strong' style='border-top: 1px solid #006e78'>" . formata_valor($empresarial->totaldiario($data[$i])) . "</td>";
                }
                ?>
            </tr>
            <tr>
                <td class="bg-redenilf text-white">ISP</td>
                <?php
                for ($i = 0; $i < count($data); $i++) {
                    echo "<td class='font-strong' style='border-top: 1px solid #006e78'>" . formata_valor($isp->totaldiario($data[$i])) . "</td>";
                }
                ?>
            </tr>
            <tr>
                <td class="bg-redenilf text-white">Caixa/Outros</td>
                <?php
                for ($i = 0; $i < count($data); $i++) {
                    echo "<td class='font-strong' style='border-top: 1px solid #006e78'>" . formata_valor($financeiro->saldodia_NaoIdentificados($data[$i])) . "</td>";
                }
                ?>
            </tr>
            <tr>
                <td class="bg-redenilf text-white">PagSeguro</td>
                <?php
                for ($i = 0; $i < count($data); $i++) {
                    echo "<td class='font-strong' style='border-top: 1px solid #006e78'>" . formata_valor($financeiro->saldodia_Pagseguro($data[$i])) . "</td>";
                }
                ?>
            </tr>
            <tr>
                <td class="bg-redenilf text-white">Residencial</td>
                <?php
                for ($i = 0; $i < count($data); $i++) {
                    echo "<td class='font-strong' style='border-top: 1px solid #006e78'>" . formata_valor($residencial->totaldiario($data[$i])) . "</td>";
                }
                ?>
            </tr>
            <tr>
                <td class="bg-redenilf text-white">Total</td>
                <?php
                for ($i = 0; $i < count($data); $i++) {
                    $total = formata_valor($financeiro->saldodia_Pagseguro($data[$i]) +
                        $isp->totaldiario($data[$i]) +
                        $financeiro->saldodia_Cartao($data[$i]) + $comercial->totaldiario($data[$i]) +
                        $empresarial->totaldiario($data[$i]) + $financeiro->saldodia_NaoIdentificados($data[$i]) +
                        $residencial->totaldiario($data[$i]));

                    if ($total == formata_valor(($financeiro->saldodia_CR($data[$i]) + $financeiro->saldodia_CR_Pix($data[$i]) +
                            $financeiro->saldodia_Cartao($data[$i]) + $financeiro->saldodia_Caixa($data[$i]) +
                            $financeiro->saldodia_Pagseguro($data[$i]))) || $total == formata_valor($financeiro->saldodia_CR($data[$i]) + $financeiro->saldodia_CR_Pix($data[$i]))) {
                        echo "<td class='bg-success-50 font-extra-bold' style='border-top: 1px solid #006e78'>" . $total . "</td>";
                    } else {
                        echo "<td class='bg-danger font-strong text-white' data-toggle='tooltip' 
                                title='Valor em processo de verificação'  style='border-top: 1px solid #006e78'>" .
                            $total . "</td>";
                    }
                }
                ?>
            </tr>
            </tbody>
        </table>
    </div>
<!-- END TABELA DE FATURAMENTO -->

<?php elseif ($page == 'historico_conexao_new'):

    $dates = implode(",", $conexoes->getDates());

    $conexoes->loadDesbloqueadosMes();
    $total_desbloqueados_mes = count($conexoes->getResult());
    $total_acumulado_desbloqueado = array_sum(array_column($conexoes->getResult(), 'previsao'));
    $total_desbloqueados_dia = implode(",", $conexoes->getHistoricoDias());
    $conexoes->loadBloqueadosMes();
    $total_bloqueados_mes = count($conexoes->getResult());
    $total_acumulado_bloqueado = array_sum(array_column($conexoes->getResult(), 'previsao'));
    $total_bloqueados_dia = implode(",", $conexoes->getHistoricoDias());
    $conexoes->loadReduzidosMes();
    $total_reduzidos_mes = count($conexoes->getResult());
    $total_acumulado_reduzido = array_sum(array_column($conexoes->getResult(), 'previsao'));
    $total_reduzidos_dia = implode(",", $conexoes->getHistoricoDias());

    // CHART ACUMULADO
    $conexoes->loadAllHistory();
    $label_mes_acumulado = implode(",", $conexoes->getLabelMesesAcumulado());
    $acumulado_bloqueados = implode(",", $conexoes->getBloqueadoAcumulado());
    $acumulado_desbloqueados = implode(",", $conexoes->getDesbloqueadoAcumulado());
    //END CHART ACUMULADO
    ?>

  <!-- START GRAFICO DE BLOQUEADOS -->
    <div class="ibox-body">
        <div>
            <canvas id="line_conexao_historico"
                    data-dates="<?php echo $dates; ?>"
                    data-desbloqueados_dia="<?php echo $total_desbloqueados_dia; ?>"
                    data-bloqueados_dia="<?php echo $total_bloqueados_dia; ?>"
                    data-reduzidos_dia="<?php echo $total_reduzidos_dia; ?>"
                    style="height:293px;">
            </canvas>
        </div>
    </div>
    <!-- END GRAFICO DE BLOQUEADOS -->

    <!-- START GRAFICO ACUMULADO BLOQUEADOS -->
    <div class="ibox-body">
        <div class="text-muted">Acumulado</div>
        <div class="row align-items-center">
            <div class="col-6" data-print-hidden>
                <canvas id="chart_acumulado_historico_conexao"
                        data-desbloqueados="<?php echo $acumulado_desbloqueados; ?>"
                        data-bloqueados="<?php echo $acumulado_bloqueados; ?>"
                        data-label-mes="<?php echo $label_mes_acumulado; ?>"
                        style="height:100px;"></canvas>
            </div>
            <div class="col-6 text-center">
                <div class="row">
                    <div class="col-lg-4 col-md-4 col-sm-4" style="border-right: 1px solid rgba(0,0,0,.1);">
                        <button class="btn text-center btn-success text-white" data-toggle="tooltip"
                                title="Desbloqueados dos meses anteriores"
                                onclick="loadModalHistorico('Desbloqueados')">
                            <i class="ti-user mr-2"></i>
                            <span class="h4 m-0"><?php echo $total_desbloqueados_mes ?>
                              </span>
                        </button>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-4" style="border-right: 1px solid rgba(0,0,0,.1);">
                        <button class="btn text-center btn-pink text-white" data-toggle="tooltip" title="Bloqueados"
                                onclick="loadModalHistorico('Bloqueados')">
                            <i class="ti-user mr-2"></i>
                            <span class="h4 m-0"><?php echo $total_bloqueados_mes ?>
                            </span>
                        </button>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-4">
                        <button class="btn text-center btn-warning text-white" data-toggle="tooltip" title="Reduzidos"
                                onclick="loadModalHistorico('Reduzidos')">
                            <i class="ti-user mr-2"></i>
                            <span class="h4 m-0"><?php echo $total_reduzidos_mes ?>
                            </span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="col-lg-4 col-md-4 col-sm-4 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                <div class="text-muted mb-2">DESBLOQUEADOS</div>
                <span class="h4">
                    <span class="text-success">R$ <?php echo formata_valor($total_acumulado_desbloqueado) ?></span>
                </span>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-4 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                <div class="text-muted mb-2">BLOQUEADOS</div>
                <span class="h4">
                    <span class="text-pink">R$ <?php echo formata_valor($total_acumulado_bloqueado) ?></span>
                </span>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-4 text-center">
                <div class="text-muted mb-2">REDUZIDOS</div>
                <span class="h4">
                    <span class="text-warning">R$ <?php echo formata_valor($total_acumulado_reduzido) ?></span>
                </span>
            </div>
        </div>
    </div>
    <!-- END GRAFICO ACUMULADO BLOQUEADOS -->

<?php elseif ($page == 'historico_conexao_modal'):
    $data = $_POST['data'];

    if ($data === 'Bloqueados') {

        $conexoes->loadBloqueadosMes();
        $data_bd = 'ult_bloqueio';
        $color = 'pink';

    }

    if ($data === 'Desbloqueados') {

        $conexoes->loadDesbloqueadosMes();
        $data_bd = 'ult_desbloqueio';
        $color = 'success';


    }

    if ($data === 'Reduzidos') {

        $conexoes->loadReduzidosMes();
        $data_bd = 'ult_reducao';
        $color = 'warning';


    }
    ?>
    <div class="modal-body">
        <div class="ibox">
            <div class="ibox-body">
                <div class="table-responsive row">
                    <table class="font-11 font-strong table table-bordered table-head-<?php echo $color;?>
                        table-border-<?php echo $color;?> table-hover"
                          cellspacing="0" width="100%" id="datatable-modal-<?php echo $data; ?>">
                        <thead class="thead-default thead-lg">
                        <tr class="text-uppercase">
                            <th class="text-center"><?php echo $data_bd; ?></th>
                            <?php if ($data == 'Desbloqueados'): ?>
                                <th class="text-center">Ult Bloqueio</th>
                            <?php endif; ?>
                            <th class="text-center">Previsão</th>
                            <th class="text-center">Cliente</th>
                            <th class="text-center">Tipo</th>
                            <th class="text-center">Cidade</th>
                            <th class="text-center">Conexão</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($conexoes->getResult() as $item): ?>
                            <tr class="text-center">
                                <td><?php echo date('d/m/Y', strtotime($item[$data_bd])); ?></td>
                                <?php if ($data == 'Desbloqueados'): ?>
                                    <td><?php if (!empty($item['ult_bloqueio'])) {
                                            echo date('d/M', strtotime($item['ult_bloqueio']));
                                        } else {
                                            echo null;
                                        } ?></td>
                                <?php endif; ?>
                                <td><?php echo formata_valor($item['previsao']); ?></td>
                                <td><?php echo utf8_encode($item['nome_razaosocial']); ?></td>
                                <td><?php echo unidade_financeira($item['plano_contas']); ?></td>
                                <td><?php echo utf8_encode($item['cidade']); ?></td>
                                <td><?php echo $item['codconexao']; ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

<?php elseif ($page == 'comparativo_fat'):
    ?>
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <?php
            $financeiro->carregarCR($_POST['dt_a'], $_POST['dt_b']);
            $workdays = getdiasuteisMes($_POST['dt_a'], $dt_f, "Financeiro");
            ?>
            <div class="ibox animated zoomIn">
                <div class="ibox-body bg-info" style="padding: 25px 25px 10px">
                    <div class="flexbox">
                        <div class="d-flex justify-content-end">
                            <span class="text-white h5 mr-3"><i class="la la-money widget-stat-icon text-white"></i>
                                <span>R$ <?php echo formata_valor($financeiro->acumuladoCR()[1]); ?></span>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="ibox-body" style="padding: 10px 25px 15px">
                    <div class="flexbox">
                        <small class="font-strong text-info pb-1 d-inline-block"
                               style="border-bottom:2px solid;">
                            <?php echo exibe_mes(date('m')); ?>
                        </small>
                    </div>
                    <div class="flexbox">
                        <div class="mt-2">
                                        <span class="text-info font-13 mr-1"><i class="fa fa-level-up"></i>
                                        Dias Faturados:</span>
                            <span class="font-13 text-primary"><?php echo $financeiro->acumuladoCR()[0]; ?>
                            </span>
                        </div>
                    </div>
                    <div class="flexbox">
                        <div class="mt-1">
                                        <span class="text-info font-13 mr-1"><i class="fa fa-plus"></i>
                                        Dias Restantes:</span>
                            <span class="font-13 text-warning"><?php echo count($workdays) - $financeiro->acumuladoCR()[0]; ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-12 col-md-12">
            <?php
            $financeiro->carregarCR($_POST['dt_c'], $_POST['dt_d']);
            $workdays = getdiasuteisMes($_POST['dt_c'], $dt_f2, "Financeiro");
            ?>
            <div class="ibox animated zoomIn">
                <div class="ibox-body bg-success" style="padding: 25px 25px 10px">
                    <div class="flexbox">
                        <div class="d-flex justify-content-end">
                            <span class="text-white h5 mr-3"><i class="la la-money widget-stat-icon text-white"></i>
                                <span>R$ <?php echo formata_valor($financeiro->acumuladoCR()[1]); ?></span>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="ibox-body" style="padding: 10px 25px 15px">
                    <div class="flexbox">
                        <small class="font-strong text-success pb-1 d-inline-block"
                               style="border-bottom:2px solid;">
                            <?php echo exibe_mes(date('m', strtotime($dt_f2))) ?>
                        </small>
                    </div>
                    <div class="flexbox">
                        <div class="mt-2">
                                        <span class="text-success font-13 mr-1"><i class="fa fa-level-up"></i>
                                        Dias Faturados:</span>
                            <span class="font-13 text-primary"><?php echo $financeiro->acumuladoCR()[0]; ?>
                        </div>
                    </div>
                    <div class="flexbox">
                        <div class="mt-1">
                                        <span class="text-success font-13 mr-1"><i class="fa fa-plus"></i>
                                        Dias Restantes:</span>
                            <span class="font-13 text-warning"><?php echo count($workdays) - $financeiro->acumuladoCR()[0]; ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-12 col-md-12">
            <?php
            $financeiro->carregarCR($_POST['dt_e'], $_POST['dt_f']);
            $workdays = getdiasuteisMes($_POST['dt_e'], $dt_f3, "Financeiro");
            ?>
            <div class="ibox animated zoomIn">
                <div class="ibox-body bg-success" style="padding: 25px 25px 10px">
                    <div class="flexbox">
                        <div class="d-flex justify-content-end">
                            <span class="text-white h5 mr-3"><i class="la la-money widget-stat-icon text-white"></i>
                                <span>R$ <?php echo formata_valor($financeiro->acumuladoCR()[1]); ?></span>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="ibox-body" style="padding: 10px 25px 15px">
                    <div class="flexbox">
                        <small class="font-strong text-success pb-1 d-inline-block"
                               style="border-bottom:2px solid;">
                            <?php echo exibe_mes(date('m', strtotime($dt_f3))); ?>
                        </small>
                    </div>
                    <div class="flexbox">
                        <div class="mt-2">
                                        <span class="text-success font-13 mr-1"><i class="fa fa-level-up"></i>
                                        Dias Faturados:</span>
                            <span class="font-13 text-primary"><?php echo $financeiro->acumuladoCR()[0]; ?>
                        </div>
                    </div>
                    <div class="flexbox">
                        <div class="mt-1">
                                        <span class="text-success font-13 mr-1"><i class="fa fa-plus"></i>
                                        Dias Restantes:</span>
                            <span class="font-13 text-warning"><?php echo count($workdays) - $financeiro->acumuladoCR()[0]; ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
<?php elseif ($page == 'loadanual_recebimento'):
    $financeiro->carregarCR($dt_i12, date('d-m-Y', strtotime('-1 day')));
    echo $financeiro->agrupaCRmes();
    ?>
<?php
endif; ?>
