<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 05/12/2018
 * Time: 11:32
 */
require_once "../classes/Cancelamento.php";
require_once "../funcoes/funcoes.php";


$dt_i = date('d-m-Y', mktime(0, 0, 0, date('m'), 1, date('Y')));
$dt_f = date('d-m-Y', mktime(23, 59, 59, date('m'), date("t"), date('Y')));

$cancelamento = new Cancelamento();
$cancelamento->carragar_Cancelamento($dt_i, $dt_f);
$page = isset($_GET['page']) ? $_GET['page'] : '';
$dt_start = isset($_POST['inicio']) ? $_POST['inicio'] : '';
$dt_end = isset($_POST['fim']) ? $_POST['fim'] : '';

?>

<?php
if ($page == 'load'):
    $cancelamento->carragar_Cancelamento($dt_start, $dt_end);

    ?>
    <div class="table-responsive row">
        <table class="font-13 table table-bordered table-head-redenilfcolor table-border-redenilfcolor
                 table-hover" cellspacing="0" width="100%" id="datatable">
            <thead class="thead-default thead-lg">
            <tr class="text-uppercase">
                <th class="text-center">Cancelado em</th>
                <th class="text-center">Cliente</th>
                <th class="text-center">Mensalidade</th>
                <th class="text-center">Plano/Contrato</th>
                <th class="text-center">Unidade</th>
                <th class="text-center">Abertura O.S</th>
                <th class="text-center">Status</th>
                <th class="text-center">Motivo</th>
                <th class="text-center">Bairro</th>
                <th class="text-center">Cidade</th>
            </tr>
            </thead>
            <tbody>
            <?php
            if (!empty($cancelamento->getResult())):
                foreach ($cancelamento->getResult() as $item):
                    ?>
                    <tr>
                        <td class="text-center">
                            <span>
                                <small class="font-bold"><?php
                                    echo date("d/m/Y", strtotime($item['data'])); ?>
                                </small>
                            </span>
                        </td>
                        <td class="text-center">
                            <span>
                                <small class="font-bold"><?php
                                    echo utf8_encode($item['nome']); ?>
                                </small>
                            </span>
                        </td>
                        <td class="text-center">
                            <span>
                                <small class="font-bold"><?php
                                    echo formata_valor($item['mensalidade']); ?>
                                </small>
                            </span>
                        </td>
                        <td class="text-center">
                            <span>
                                <small class="font-bold"><?php
                                    echo utf8_encode($item['plano']); ?>
                                </small>
                                <hr>
                                <small class="font-bold"><?php
                                    echo utf8_encode($item['codcontrato']); ?>
                                </small>
                            </span>
                        </td>
                        <td class="text-center">
                            <span>
                                <small class="font-bold"><?php
                                    echo utf8_encode($item['tipo2']); ?>
                                </small>
                                 <hr>
                                <small class="font-bold"><?php
                                    echo unidade_financeira($item['tipo']); ?>
                                </small>
                            </span>
                        </td>
                        <td class="text-center">
                            <span>
                                <small class="font-bold">
                                    <?php echo $item['data_abertura'] ?
                                        date('d/m/Y', strtotime($item['data_abertura'])) : "Não vinculada" ?>
                                </small>
                            </span>
                        </td>
                        <td class="text-center"><?php
                            if (!empty($item['data_abertura']) &&
                                date('m', strtotime($item['data_abertura'])) !==
                                date('m', strtotime($item['data']))) : ?>
                                <span class="label label-warning">
                                  <small class="font-bold"><?php echo "Em Atraso"; ?></small>
                                </span>
                            <?php else : ?>
                                <span class="label label-success">
                                  <small class="font-bold"><?php echo "No Mês"; ?></small>
                                </span>
                            <?php endif; ?>
                        </td>
                        <td class="text-center">
                            <span>
                                <small class="font-bold"><?php
                                    echo utf8_encode($item['motivo']); ?>
                                </small>
                            </span>
                        </td>
                        <td class="text-center">
                            <span>
                                <small class="font-bold"><?php
                                    echo utf8_encode($item['bairro']); ?>
                                </small>
                            </span>
                        </td>
                        <td class="text-center">
                            <span>
                                <small class="font-bold"><?php
                                    echo utf8_encode($item['cidade']); ?>
                                </small>
                            </span>
                        </td>
                    </tr>
                <?php
                endforeach;
            endif;
            ?>
            </tbody>
        </table>
    </div>

<?php
elseif ($page == 'loadfluxo') :
    $cancelamento->carregarFluxo();
    $array_danger = array();
    $array_warning = array();
    $array_info = array();

    foreach ($cancelamento->getResultfluxo() as $item) {

        if ($item['agenda'] == 'REAGENDAR' || $item['os'] == 'AGENDAR' ||
            $item['os'] == 'OS SEM CONEXAO') {

            array_push($array_danger, 1);
        }
        if ($item['ticket'] == 'PENDENTE' && $item['os'] == '-' || ($item['os'] == 'AGUARDANDO')) {

            array_push($array_warning, 1);

        }
        if ($item['ticket'] == 'PENDENTE' && ($item['os'] == 'CONCLUIDO')) {

            array_push($array_info, 1);
        }
    }
    ?>
    <div class="ibox-body">
        <div class="row">
            <div class="col-lg-8">
                <div class="d-flex flex-wrap mb-3">
                    <div class="static-widget"
                         style="cursor:pointer; background-color: #f39c1285"
                         data-toggle="tooltip"
                         title="Aguardando OS ou andamento do ticket"
                         onclick="onclickAutosearch('Aguardando');">
                        <i class="ti-ticket"></i>
                        <h4 class="m-0"><?php echo array_sum($array_warning); ?></h4>
                        <small>AGUARDANDO</small>
                    </div>
                    <div class="static-widget"
                         style="cursor:pointer; background-color: #2cc4cb94;"
                         data-toggle="tooltip"
                         title="Ticket para Encerrar"
                         onclick="onclickAutosearch('Pendente Concluido');">
                        <i class="ti-check-box"></i>
                        <h4 class="m-0"><?php echo array_sum($array_info); ?></h4>
                        <small>P/ ENCERRAR</small>
                    </div>
                    <div class="static-widget"
                         style="cursor:pointer; background-color: #f75a5f80;"
                         data-toggle="tooltip"
                         title="Aguardando Revisão" onclick="onclickAutosearch('Agendar');">
                        <i class="ti-close"></i>
                        <h4 class="m-0"><?php echo count($array_danger); ?></h4>
                        <small>P/ REVISAR</small>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="d-flex flex-wrap">
                    <input class="form-control form-control-rounded form-control-solid"
                           id="key-search-fluxo"
                           type="text"
                           placeholder="Procurar ...">
                </div>
                <div class="d-flex float-right">
                    <button type="button" onclick="loadfluxo()" class="btn btn-redenilf mt-5
                     btn-sm btn-fix">
                        <strong class="btn-icon"><i
                                    class="la la-search"></i>Atualizar</strong>
                    </button>
                </div>
            </div>
        </div>
        <div class="table-responsive row">
            <table class="font-13 table table-bordered table-head-redenilfcolor table-border-redenilfcolor
                                table-hover" cellspacing="0" width="100%" id="datatable-fluxo">
                <thead class="thead-default thead-lg">
                <tr class="text-uppercase">
                    <th class="text-center">Data</th>
                    <th class="text-center">Cliente</th>
                    <th class="text-center">Cidade</th>
                    <th class="text-center">Ticket</th>
                    <th class="text-center">Operador</th>
                    <th class="text-center">OS</th>
                    <th class="text-center">Agenda</th>
                    <th class="text-center">Encerramento</th>
                </tr>
                </thead>
                <tbody>
                <?php
                if (!empty($cancelamento->getResultfluxo())):
                    foreach ($cancelamento->getResultfluxo() as $item):
                        ?>
                        <tr <?php if ($item['ticket'] == 'ENCERRADO' && ($item['os'] == 'CONCLUIDO' ||
                                $item['os'] == '-')) {
                            echo "style='background-color: #00ca2e82;'";
                        } elseif ($item['agenda'] == 'REAGENDAR' || $item['os'] == 'AGENDAR' ||
                            $item['os'] == 'OS SEM CONEXAO') {
                            array_push($array_danger, 1);
                            echo "style='background-color: #f75a5f80;'";
                        } elseif ($item['ticket'] == 'PENDENTE' && ($item['os'] == 'AGUARDANDO' ||
                                $item['os'] == '-')) {
                            echo "style='background-color: #f39c1285;'";
                        } elseif ($item['ticket'] == 'PENDENTE' && ($item['os'] == 'CONCLUIDO')) {
                            echo "style='background-color: #2cc4cb94;'";
                        } ?>>
                            <td class="text-center">
                                <div class="mb-2">
                                                 <span class="font-extra-bold"><?php echo
                                                     date("d/m/Y", strtotime($item['data'])); ?>
                                                </span>
                                </div>
                            </td>
                            <td class="text-center text-uppercase">
                                <div class="mb-2">
                                    <span class="font-bold"><?php echo utf8_encode($item['cliente']); ?></span>
                                    <?php if (!empty($item['codigo'])): ?>
                                        <div class="mb-2 mt-2 divider"></div>
                                        <small class="font-bold">Cliente nº
                                        </small><br/>
                                        <small class="font-bold">
                                            <?php echo utf8_encode($item['codigo']); ?>
                                        </small>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <!--ENDEREÇO -->
                            <td class="text-center">
                                <div class="mb-2">
                                                <span>
                                                    <small class="font-bold"><?php echo utf8_encode($item['cidade']); ?>
                                                    </small>
                                                </span>
                                    <div class="divider mb-2 mt-2"></div>
                                    <span>
                                                    <small class="font-bold"><?php echo utf8_encode($item['bairro']); ?>
                                                    </small>
                                                </span>
                                </div>
                            </td>
                            <td class="text-center text-uppercase">
                                <div class="mb-2">
                                    <?php if (!($item['ticket'] == '-')): ?>
                                        <span class="label <?php if ($item['ticket'] == 'ENCERRADO') {
                                            echo "label-success";
                                        } elseif ($item['ticket'] == 'PENDENTE') {
                                            echo "label-warning";
                                        } else {
                                            echo "label-danger";
                                        } ?>"><small class="font-bold">
                                                            <?php echo utf8_encode($item['ticket']); ?>
                                                        </small>
                                                    </span>
                                    <?php else: ?>
                                        <span class="font-bold"><?php echo $item['ticket']; ?></span>
                                    <?php endif; ?>
                                    <?php if (!empty($item['codatendimento'])): ?>
                                        <div class="mb-2 mt-2 divider"></div>
                                        <small class="font-bold">Ticket nº
                                        </small><br/>
                                        <small class="font-bold">
                                            <?php echo utf8_encode($item['codatendimento']); ?>
                                        </small>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="text-center">
                                                <span>
                                                    <small class="font-bold"><?php
                                                        echo utf8_encode($item['operador']); ?>
                                                    </small>
                                                </span>
                            </td>
                            <!-- OS -->
                            <td class="text-center text-uppercase">
                                <div class="mb-2">
                                    <?php if (!($item['os'] == '-')): ?>
                                        <span class="label <?php if ($item['os'] == 'CONCLUIDO') {
                                            echo "label-success";
                                        } elseif ($item['os'] == 'AGUARDANDO') {
                                            echo "label-warning";
                                        } else {
                                            echo "label-danger";
                                        } ?>"><small class="font-bold">
                                                            <?php echo $item['os']; ?>
                                                        </small>
                                                    </span>
                                    <?php else: ?>
                                        <span class="font-bold"><?php echo $item['os']; ?></span>
                                    <?php endif; ?>
                                    <?php if (!empty($item['codos'])): ?>
                                        <div class="mb-2 mt-2 divider"></div>
                                        <small class="font-bold">O.S. nº
                                        </small><br/>
                                        <small class="font-bold">
                                            <?php echo utf8_encode($item['codos']); ?>
                                        </small>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <!-- PREVISAO -->
                            <td class="text-center text-uppercase">
                                <div class="mb-2">
                                    <?php
                                    if (strpos($item['agenda'], 'CONCLUIDO') !== false):?>
                                        <span class="label label-success">
                                                        <small class="font-bold">
                                                            <?php echo utf8_encode($item['agenda']); ?>
                                                        </small>
                                                    </span>
                                    <?php elseif (strpos($item['agenda'], 'REAGENDAR') !== false ||
                                        strpos($item['agenda'], 'AGENDAR') !== false): ?>
                                        <span class="label label-danger">
                                                        <small class="font-bold"><?php echo utf8_encode($item['agenda']); ?>
                                                        </small>
                                                    </span>
                                    <?php else:; ?>
                                        <span>
                                                        <small class="font-bold"><?php echo utf8_encode($item['agenda']); ?>
                                                        </small>
                                                    </span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="text-center">
                                <div class="mb-2">
                                                <span>
                                                    <small class="font-bold"><?php if (!empty($item['encerramento'])) {
                                                            echo
                                                            date('d/m/Y', strtotime($item['encerramento']));
                                                        } else {
                                                            echo '-';
                                                        }; ?>
                                                    </small>
                                                </span>
                                    <div class="divider mb-2 mt-2"></div>
                                    <span>
                                                    <small class="font-bold"><?php echo utf8_encode($item['classificacao']); ?>
                                                    </small>
                                                </span>
                                </div>
                            </td>
                        </tr>
                    <?php
                    endforeach;
                endif;
                ?>
                </tbody>
            </table>
        </div>
    </div>
<?php
elseif ($page == 'loadinativos'):
    $cancelamento->carregarInativos(date('d-m-Y', strtotime('- 60 days'))); ?>
    <div class="ibox-body">
        <div class="table-responsive row">
            <table class="table table-bordered table-hover table-head-info" id="datatable-inativos">
                <thead class="thead-lg">
                <tr>
                    <th class="text-center"><i class="fa fa-calendar-plus-o"></i></th>
                    <th class="text-center"><i class="mr-2 ti-user"></i>Cliente</th>
                    <th class="text-center"><i class="mr-2 ti-location-pin"></i>Contrato</th>
                    <th class="text-center"><i class="mr-2 ti-plus"></i>Parcelas Vencidas</th>
                    <th class="text-center"><i class="mr-2 ti-book"></i>Conexão Bloqueada</th>
                </tr>
                </thead>
                <tbody>
                <?php

                foreach ($cancelamento->getInativos() as $item) :

                    ?>
                    <tr>
                        <td class="text-center text-light font-strong"><?php echo date('d/m/Y', strtotime($item['adesao'])); ?></td>
                        <td>
                            <div class="mb-2">
                                <h6><?php echo utf8_encode($item['nome_razaosocial']); ?></h6>
                                <div class="my-2"></div>
                                <span class="float-right"><small class="text-muted ml-2">
                                    Cod Cliente: <?php echo utf8_encode($item['codpessoa']); ?></small></span>
                                <span class="font-13 text-light">
                                <?php echo unidade_financeira($item['unidade_financeira']); ?></span>
                            </div>
                        </td>
                        <td class="text-center">
                            <?php echo utf8_encode($item['codcontrato']); ?>
                        </td>
                        <td class="text-center">
                            <span class="badge badge-danger badge-pill mb-2"
                                  data-container="body"
                                  data-toggle="popover" data-trigger="hover"
                                  data-placement="top"
                                  data-content="Quantidade de parcelas vencidas"><?php
                                echo $item['qtd_aberto'];
                                ?>
                            </span>
                            <hr>
                            <span class="text-center">
                                <?php echo date('d/m/Y', strtotime($item['pri_vencto'])); ?>
                            </span>
                        </td>
                        <td class="text-center">
                            <span class="badge <?php echo ($item['conexao_bloqueada'] == 'S')
                                ? 'badge-danger' : 'badge-success'
                            ?> badge-pill mb-2"
                                  data-container="body"
                                  data-toggle="popover" data-trigger="hover"
                                  data-placement="top"
                                  data-content="Conexão Bloqueada?"><?php
                                echo $item['conexao_bloqueada'];
                                ?></span>
                        </td>


                    </tr>
                <?php

                endforeach;
                ?>
                </tbody>
            </table>
        </div>
    </div>
<?php
elseif ($page == 'loadanual') :
    $cancelamento->carregaCancelamentoAnual();
    echo $cancelamento->getResult();
    ?>
<?php
elseif ($page == 'loadClienteEequip'):

    $tipo = $_POST['tipo'];
    $mes = $_POST['mes'];
    $array = array();
    $cancelamento->carregaEquipamentoPerdido();
    ?>
    <div class="modal-body">
        <div class="ibox">
            <div class="ibox-body">
                <div class="table-responsive row">
                    <table class="table font-11 table-sm table-bordered table-head-redenilfcolor table-border-redenilfcolor table-hover"
                           id="table_perdidos">
                        <thead class="thead-default">
                        <tr>
                            <th class="text-center">Código</th>
                            <th class="text-center">Nome</th>
                            <th class="text-center">E-mail</th>
                            <th class="text-center">Telefone</th>
                            <th class="text-center">Bairro</th>
                            <th class="text-center">Cidade</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if ($tipo == 'Fibra'): foreach ($cancelamento->getPerdidoFibra($mes) as $row): ?>
                            <tr>
                                <td class="text-center"><?php echo $row['codigo']; ?></td>
                                <td class="text-center"><?php echo utf8_encode($row['nome']); ?></td>
                                <td class="text-center"><?php echo utf8_encode($row['email']); ?></td>
                                <td class="text-center"><?php echo utf8_encode($row['telefone']); ?></td>
                                <td class="text-center"><?php echo utf8_encode($row['bairro']); ?></td>
                                <td class="text-center"><?php echo utf8_encode($row['cidade']); ?></td>
                            </tr>
                        <?php endforeach;
                        else: foreach ($cancelamento->getPerdidoRadio($mes) as $row): ?>
                            <tr>
                                <td class="text-center"><?php echo $row['codigo']; ?></td>
                                <td class="text-center"><?php echo utf8_encode($row['nome']); ?></td>
                                <td class="text-center"><?php echo utf8_encode($row['email']); ?></td>
                                <td class="text-center"><?php echo utf8_encode($row['telefone']); ?></td>
                                <td class="text-center"><?php echo utf8_encode($row['bairro']); ?></td>
                                <td class="text-center"><?php echo utf8_encode($row['cidade']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php elseif ($page == 'loadCanceladosDetalhes') :
    $tipo = $_POST['tipo'];

    $cancelamento->canceladosMes_Atraso();
    if ($tipo == 'Mes') {
        $result = $cancelamento->getMes();
    } else {
        $result = $cancelamento->getAtraso();
    }

    ?>
    <div class="modal-body">
        <div class="ibox">
            <div class="ibox-body">
                <div class="table-responsive row">
                    <table class="table font-11 table-sm table-bordered table-head-redenilfcolor table-border-redenilfcolor table-hover"
                           id="table_cancelados">
                        <thead class="thead-default">
                        <tr>
                            <th class="text-center">Abertura O.S</th>
                            <th class="text-center">Cliente</th>
                            <th class="text-center">Mensalidade</th>
                            <th class="text-center">Plano</th>
                            <th class="text-center">Tipo</th>
                            <th class="text-center">Contrato</th>
                            <th class="text-center">Cancelado em</th>
                            <th class="text-center">Motivo</th>
                            <th class="text-center">Bairro</th>
                            <th class="text-center">Cidade</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        foreach ($result as $item) : ?>
                            <tr>
                                <td class="text-center"><?php echo $item['data_abertura'] ?
                                        date('d/m/Y', strtotime($item['data_abertura'])) : "Não vinculada" ?></td>
                                <td class="text-center"><?php echo utf8_encode($item['nome']) ?></td>
                                <td class="text-center"><?php echo formata_valor($item['mensalidade']) ?></td>
                                <td class="text-center"><?php echo $item['plano'] ?></td>
                                <td class="text-center"><?php echo $item['tipo2'] ?></td>
                                <td class="text-center"><?php echo $item['codcontrato'] ?></td>
                                <td class="text-center"><?php echo date('d/m/Y', strtotime($item['data'])) ?></td>
                                <td class="text-center"><?php echo utf8_encode($item['motivo']) ?></td>
                                <td class="text-center"><?php echo utf8_encode($item['bairro']) ?></td>
                                <td class="text-center"><?php echo utf8_encode($item['cidade']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php elseif ($page == 'historico_os'):

    // carrega datas do mes
    $dates = implode(",", $cancelamento->getDates());
    $total_clientes_cancelados_mes = count($cancelamento->getResult());
    $total_mensalidades_cancelados_mes = array_sum(array_column($cancelamento->getResult(), 'mensalidade'));
    $cancelamento->loadResultDia('data');
    $total_cancelados_dia = implode(",", $cancelamento->getTotalDia());

    //carrega OS pendente de cancelamento de contratos nao cancelados
    $cancelamento->carregarOS_Pendente_Cancelamento($dt_i, $dt_f);
    $total_emcancelamento_mes = count($cancelamento->getResult());
    $total_mensalidades_emcancelamento_mes = array_sum(array_column($cancelamento->getResult(), 'mensalidade'));


    $cancelamento->loadResultDia('data_abertura');
    $total_aberto_dia = implode(",", $cancelamento->getTotalDia());

    // carrega equipamentos perdidos
    $cancelamento->carregaEquipamentoPerdido();
    $last = sizeof($cancelamento->getResult());


    $cont = 0;
    ?>
    <div class="ibox-body pb-0">
        <i class="ti-help-alt widget-stat-icon" id="help_cancelamento"></i>
        <div>
            <canvas id="line_os_cancelamento" style="height:264px;"
                    data-dates="<?php echo $dates; ?>"
                    data-pendente_dia="<?php echo $total_aberto_dia; ?>"
                    data-cancelados_dia="<?php echo $total_cancelados_dia; ?>">
            </canvas>
        </div>
    </div>
    <div class="ibox-body pb-0">

        <div class="row">
            <div class="col text-right">
                <span class="h3 mr-3">
                    <i class="ti-user text-pink mr-2"></i>
                    <span><?php
                        echo $total_clientes_cancelados_mes;
                        ?></span>
                </span>

                <span class="h3 mr-3">
                    <i class="ti-user text-warning mr-2"></i>
                    <span><?php
                        echo $total_emcancelamento_mes;
                        ?></span>
                </span>
            </div>
        </div>
        <hr>
    </div>
    <div class="ibox-body pt-0 py-0">
        <div class="row align-items-center">
            <div class="col-12 mb-1">
                <div class="text-muted mb-4">Equipamentos Perdidos</div>

                <div class="row">
                    <?php foreach ($cancelamento->getResult() as $item):
                        $cont++; ?>
                        <div class="col-4 text-center mb-1"<?php echo ($cont < $last) ? "style='border-right: 1px solid rgba(0,0,0,.1)';" : null ?>>
                            <div class="text-muted mb-2"><?php echo $item['Mes']; ?></div>
                            <span class="h4 mr-2" data-type="Radio"
                                  data-month="<?php echo $item['Mes']; ?>"
                                  style="cursor: pointer"
                                  onclick="busca_cli_equip(this);">
                                     <i class="fa fa-wifi text-primary h1 mb-0 mr-2" data-toggle="tooltip"
                                        title="Rádio"></i>
                                    <span><?php echo $item['Radio']; ?></span>
                             </span>
                            <span class="h4 mr-2" data-type="Fibra"
                                  data-month="<?php echo $item['Mes'] ?>"
                                  style="cursor: pointer"
                                  onclick="busca_cli_equip(this);">
                                     <i class="fa fa-link text-success h1 mb-0 mr-2" data-toggle="tooltip"
                                        title="Fibra"></i>
                                 <span><?php echo $item['Fibra']; ?></span>
                             </span>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <hr>
    </div>
    <div class="ibox-body pt-0">
        <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-6 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                <div class="text-muted mb-2">TOTAL CANCELADOS</div>
                <span class="h4">
                    <span class="text-pink">R$ <?php echo formata_valor($total_mensalidades_cancelados_mes); ?></span>
                </span>
            </div>
            <div class="col-lg-6 col-md-6 col-sm-6 text-center">
                <div class="text-muted mb-2">EM CANCELAMENTO</div>
                <span class="h4">
                    <span class="text-warning">R$ <?php
                        echo formata_valor($total_mensalidades_emcancelamento_mes);
                        ?></span>
                </span>
            </div>
        </div>
    </div>
<?php endif;
?>
