<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 05/12/2018
 * Time: 11:32
 */
require_once "../classes/Cobranca.php";
require_once "../funcoes/funcoes.php";

$cobranca = new Cobranca();
$page = isset($_GET['page']) ? $_GET['page'] : '';

$cobranca->loadSPC();

function StatusLabelSPC($string)
{
    $label = null;

    switch ($string) {
        case 'ENVIAR SPC':
            $label = 'label label-pink';
            break;
        case 'AGUARDAR':
            $label = 'label label-warning';
            break;
        case 'FINALIZADO':
            $label = 'label label-success';
            break;
    }

    return $label;

}

function statusTrSPC($item)
{

    $result = null;

     if (array_search('ENVIAR SPC', $item, true)) {

        $result = 'bg-danger-50';

    } else if (array_search('AGUARDAR', $item, true)) {

        $result = 'bg-warning-50';

    }else if (array_search('FINALIZADO', $item, true)) {

        $result = 'bg-info-50';
    }

    return $result;
}

//Função que retorna cores da label de acordo com a string fornecida
function StatusLabelCobr($string)
{
    $label = null;

    switch ($string) {
        case 'ACORDO VENCIDO':
            $label = 'label label-pink';
            break;
        case 'AGUARDANDO PAGAMENTO':
            $label = 'label label-warning';
            break;
        case 'AGUARDANDO RETIRADA':
            $label = 'label label-warning';
            break;
        case 'LIQUIDADO':
            $label = 'label label-success';
            break;
        case 'ABRIR OS':
            $label = 'label label-pink';
            break;
        case 'SPC OK':
            $label = 'label label-info';
            break;
        case 'SPC ENV':
            $label = 'label label-pink';
            break;
    }

    return $label;

}

function statusTrCobr($item)
{

    $result = null;

    if (array_search('ACORDO VENCIDO', $item, true)) {

        $result = 'bg-danger-50';

    } else if (array_search('AGUARDANDO PAGAMENTO', $item, true) ||
        array_search('AGUARDANDO RETIRADA', $item, true)) {

        $result = 'bg-warning-50';

    } else if (array_search('LIQUIDADO', $item, true)) {

        $result = 'bg-success-50';

    } else if (array_search('SPC OK', $item, true)) {

        $result = 'bg-info-50';

    } else if (array_search('ENVIAR SPC', $item, true)) {

        $result = 'bg-danger-50';

    } else if (array_search('AGUARDAR', $item, true)) {

        $result = 'bg-warning-50';

    }else if (array_search('FINALIZADO', $item, true)) {

        $result = 'bg-info-50';
    }

    return $result;
}

?>

<?php if ($page == 'loadCobranca'): ?>
    <div class="table-responsive row">
        <table class="table table-bordered table-hover table-head-info" id="datatable-cobranca">
            <thead class="thead-lg">
            <tr>
                <th class="text-center"><i class="mr-2 ti-user"></i>Código</th>
                <th class="text-center"><i class="mr-2 ti-user"></i>Cliente</th>
                <th class="text-center"><i class="mr-2 ti-location-pin"></i>Endereço</th>
                <th class="text-center" style="width: 15%"><i class="mr-2 ti-plus"></i>Total Devido</th>
                <th class="text-center" style="width: 15%"><i class="mr-2 ti-book"></i>Dias em atraso</th>
            </tr>
            </thead>
            <tbody class="text-center">
            <?php
            if (!empty($cobranca->getSemCobranca())) {
                foreach ($cobranca->getSemCobranca() as $item) :
                    ?>
                    <tr>
                        <td>
                            <span class="text-muted ml-2">
                                    <?php echo $item['codpessoa']; ?>
                            </span>
                        </td>
                        <td>
                            <div class="mb-2">
                                <h6><?php echo utf8_encode($item['nome_razaosocial']); ?></h6>
                            </div>
                        </td>
                        <td class="text-center">
                            <div class="mb-2">
                                <h6><?php echo utf8_encode($item['bairro']); ?></h6>
                                <div class="my-2"></div>
                                <span>
                                    <small class="text-muted ml-2">
                                     <?php echo utf8_encode($item['cidade']); ?>
                                    </small>
                                </span>
                            </div>
                        </td>
                        <td class="text-center">
                            <span>
                                <?php echo formata_valor($item['total']); ?>
                            </span>
                        </td>
                        <td class="text-center">
                            <span class="badge <?php echo ($item['dias_em_atraso'] > 45)
                                ? 'badge-danger' : 'badge-warning'
                            ?> mb-2"
                                  data-container="body"
                                  data-toggle="popover" data-trigger="hover"
                                  data-placement="top"
                                  data-content="Dias em Atraso"><?php
                                echo intval($item['dias_em_atraso']);
                                ?></span>
                        </td>
                    </tr>
                <?php

                endforeach;
            }
            ?>
            </tbody>
        </table>
    </div>

<?php elseif ($page == 'loadSPC'):?>
    <div class="table-responsive row">
        <table class="table table-bordered table-hover table-head-info" id="datatable-spc">
            <thead class="thead-lg">
            <tr>
                <th class="text-center"><i class="mr-2 ti-calendar"></i>Início</th>
                <th class="text-center"><i class="mr-2 ti-user"></i>Cliente</th>
                <th class="text-center"><i class="mr-2 ti-write"></i>Fatura</th>
                <th class="text-center" style="width: 15%"><i class="mr-2 ti-book"></i>Ticket</th>
                <th class="text-center" style="width: 15%"><i class="mr-2 ti-alert"></i>SPC</th>
            </tr>
            </thead>
            <tbody class="text-center">
            <?php
            if (!empty($cobranca->getLoadSPC())) {
                foreach ($cobranca->getLoadSPC() as $item) :
                    ?>
                    <tr class="<?php echo statusTrSPC($item) ?>">
                        <td style="width: 10%">
                            <span class="ml-2">
                                    <?php echo date('d/m/Y', strtotime($item['data_inicio'])); ?>
                            </span>
                        </td>
                        <td class="text-center" style="width: 45%">
                            <div class="mb-2">
                                <h6><?php echo utf8_encode($item['nome_razaosocial']); ?></h6>
                                <div class="my-2"></div>
                                <span>
                                    <small class="ml-2">
                                     <?php echo $item['cd_pessoa']; ?>
                                    </small>
                                </span>
                            </div>
                        </td>
                        <td class="text-center">
                            <div class="mb-2">
                                <h6><?php echo $item['fatura_spc']; ?></h6>
                                <div class="my-2"></div>
                                <span>
                                    <small class="ml-2">
                                     <?php echo $item['liquidado']; ?>
                                    </small>
                                </span>
                            </div>
                        </td>
                        <td class="text-center">
                            <div class="mb-2">
                                <h6><?php echo $item['ticket']; ?></h6>
                                <div class="my-2"></div>
                                <span>
                                    <small class="ml-2">
                                     <?php echo $item['atendimento']; ?>
                                    </small>
                                </span>
                            </div>
                        </td>
                        <td>
                            <div class="mb-2">
                                <span class="<?php echo StatusLabelSPC($item['spc']) ?>">
                                    <?php echo $item['spc']; ?>
                                </span>
                            </div>
                        </td>
                    </tr>
                <?php

                endforeach;
            }
            ?>
            </tbody>
        </table>
    </div>

<?php elseif ($page == 'loadCobranca2'): ?>
    <div class="table-responsive row">
        <table class="table font-13 table-bordered table-head-info" id="datatable-cobranca2">
            <thead class="thead-lg">
            <tr>
                <th class="text-center"><i class="mr-2 ti-calendar"></i>Início</th>
                <th class="text-center"><i class="mr-2 ti-user"></i>Cliente</th>
                <th class="text-center"><i class="mr-2 ti-location-pin"></i>Endereço</th>
                <th class="text-center"><i class="mr-2 ti-write"></i>Acordo</th>
                <th class="text-center"><i class="mr-2 ti-book"></i>Atraso</th>
                <th class="text-center"><i class="mr-2 ti-panel"></i>Status</th>
                <th class="text-center"><i class="mr-2 ti-flag"></i>Os</th>
                <th class="text-center"><i class="mr-2 ti-alert"></i>SPC</th>
            </tr>
            </thead>
            <tbody class="text-center">
            <?php
            foreach ($cobranca->getComCobranca() as $item) :

                ?>
                <tr class="<?php echo statusTrCobr($item) ?>">
                    <td class="text-center">
                        <div class="mb-4">
                                <span>
                                    <small class="font-bold ml-2">
                                     <?php echo date('d/m/Y', strtotime($item['data_inicio'])); ?>
                                    </small>
                                </span>
                        </div>
                    </td>
                    <td style="width: 40%">
                        <div>
                            <h6 class="my-3"><?php echo utf8_encode($item['nome_razaosocial']); ?></h6>
                            <div class="my-2 divider"></div>
                            <div class="row">
                                <div class="col" style="border-right: 1px solid #efefef">
                                    <small>Cliente nº</small>
                                    <br/>
                                    <small>
                                        <?php echo utf8_encode($item['codpessoa']); ?>
                                    </small>
                                </div>
                                <div class="col">
                                    <small class="font-extra-bold">
                                        <img class="img-circle"
                                             src="./images/users/profile/<?php echo utf8_encode($item['operador']) ?>.jpg"
                                             alt="image" width="30" height="30"/><br/>
                                        <?php echo utf8_encode($item['operador']) ?>
                                    </small>
                                </div>
                            </div>
                        </div>
                    </td>
                    <td class="text-center" style="width: 20%">
                        <div class="mb-4">
                                <span><small class="ml-2 font-bold">
                                        <?php echo utf8_encode($item['bairro']); ?>
                                    </small></span>
                            <div class="my-2 divider"></div>
                            <span>
                                    <small class=ml-2">
                                     <?php echo utf8_encode($item['cidade']); ?>
                                    </small>
                                </span>
                        </div>
                    </td>
                    <td class="text-center">
                        <div class="mb-4">
                                <span>
                                    <small class="font-bold ml-2">
                                     Fat: <?php echo $item['codfatura']; ?>
                                    </small>
                                </span>
                            <div class="my-2 divider"></div>
                            <span>
                                    <small class="font-bold ml-2">
                                     <?php echo date('d/m/Y', strtotime($item['prazo_acordo'])); ?>
                                    </small>
                                </span>
                        </div>
                    </td>
                    <td class="text-center">
                            <span class="badge <?php echo ($item['dias_atraso'] > 45)
                                ? 'badge-danger' : 'badge-warning'
                            ?> mb-2"
                                  data-container="body"
                                  data-toggle="popover" data-trigger="hover"
                                  data-placement="top"
                                  data-content="Dias em Atraso"><?php
                                echo intval($item['dias_atraso']);
                                ?></span>
                    </td>
                    <td class="text-center" style="width: 20%;">
                        <div class="mb-2">
                                <span class="<?php echo StatusLabelCobr($item['acordo']) ?>">
                                        <?php echo utf8_encode($item['acordo']) ?>
                                    </span>
                        </div>
                    </td>
                    <td>
                        <div class="mb-2">
                            <span class="font-bold <?php echo StatusLabelCobr($item['codos']) ?>">
                                <?php echo $item['codos']; ?>
                            </span>
                            <div class="my-2 divider"></div>
                            <span>
                                        <small class="ml-2">
                                         <?php echo utf8_encode($item['encerrado']); ?>
                                        </small>
                                    </span>
                        </div>
                    </td>
                    <td>
                        <div class="mb-2">
                                <span class="<?php echo StatusLabelCobr($item['spc']) ?>">
                                    <?php echo utf8_encode($item['spc']); ?>
                                </span>
                        </div>
                    </td>
                </tr>
            <?php

            endforeach;
            ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>
